/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.fus;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.participants.SchemaCompareParticipant;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.participants.SchemaCompareParticipantForDacpac;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.participants.SchemaCompareParticipantForDatabase;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.participants.SchemaCompareParticipantForProject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018J\u001e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018J\u001e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018J\u001e\u0010 \u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018J\u001e\u0010!\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018J\u001e\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0018R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/fus/RiderSchemaCompareStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "COMPARISON_CANCELLED", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "COMPARISON_STARTED", "DEPLOY_SCRIPT_GENERATION_CANCELLED", "DEPLOY_SCRIPT_GENERATION_STARTED", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "PARTICIPANTS", "", "SOURCE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "TARGET", "UPDATE_TARGET_CANCELLED", "UPDATE_TARGET_STARTED", "dacpac", "database", "project", "getGroup", "getStringFromParticipant", "participant", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/participants/SchemaCompareParticipant;", "logComparisonCancelled", "", "Lcom/intellij/openapi/project/Project;", "source", "target", "logComparisonStarted", "logDeployScriptGenerationCancelled", "logDeployScriptGenerationStarted", "logUpdateTargetCancelled", "logUpdateTargetStarted", "intellij.rider.plugins.appender"})
public final class RiderSchemaCompareStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final RiderSchemaCompareStatisticsCollector INSTANCE = new RiderSchemaCompareStatisticsCollector();
    @NotNull
    private static final String database = "database";
    @NotNull
    private static final String project = "project";
    @NotNull
    private static final String dacpac = "dacpac";
    @JvmField
    @NotNull
    public static final EventLogGroup GROUP = new EventLogGroup("rider.sqlproj.schemaCompare", 1, null, 4, null);
    @NotNull
    private static final List<String> PARTICIPANTS;
    @NotNull
    private static final StringEventField SOURCE;
    @NotNull
    private static final StringEventField TARGET;
    @NotNull
    private static final EventId2<String, String> COMPARISON_STARTED;
    @NotNull
    private static final EventId2<String, String> COMPARISON_CANCELLED;
    @NotNull
    private static final EventId2<String, String> UPDATE_TARGET_STARTED;
    @NotNull
    private static final EventId2<String, String> UPDATE_TARGET_CANCELLED;
    @NotNull
    private static final EventId2<String, String> DEPLOY_SCRIPT_GENERATION_STARTED;
    @NotNull
    private static final EventId2<String, String> DEPLOY_SCRIPT_GENERATION_CANCELLED;

    private RiderSchemaCompareStatisticsCollector() {
    }

    public final void logComparisonStarted(@NotNull Project project, @NotNull SchemaCompareParticipant source, @NotNull SchemaCompareParticipant target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)project);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        COMPARISON_STARTED.log(project, (Object)this.getStringFromParticipant(source), (Object)this.getStringFromParticipant(target));
    }

    public final void logComparisonCancelled(@NotNull Project project, @NotNull SchemaCompareParticipant source, @NotNull SchemaCompareParticipant target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)project);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        COMPARISON_CANCELLED.log(project, (Object)this.getStringFromParticipant(source), (Object)this.getStringFromParticipant(target));
    }

    public final void logUpdateTargetStarted(@NotNull Project project, @NotNull SchemaCompareParticipant source, @NotNull SchemaCompareParticipant target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)project);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        UPDATE_TARGET_STARTED.log(project, (Object)this.getStringFromParticipant(source), (Object)this.getStringFromParticipant(target));
    }

    public final void logDeployScriptGenerationCancelled(@NotNull Project project, @NotNull SchemaCompareParticipant source, @NotNull SchemaCompareParticipant target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)project);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        UPDATE_TARGET_CANCELLED.log(project, (Object)this.getStringFromParticipant(source), (Object)this.getStringFromParticipant(target));
    }

    public final void logDeployScriptGenerationStarted(@NotNull Project project, @NotNull SchemaCompareParticipant source, @NotNull SchemaCompareParticipant target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)project);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DEPLOY_SCRIPT_GENERATION_STARTED.log(project, (Object)this.getStringFromParticipant(source), (Object)this.getStringFromParticipant(target));
    }

    public final void logUpdateTargetCancelled(@NotNull Project project, @NotNull SchemaCompareParticipant source, @NotNull SchemaCompareParticipant target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)project);
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        DEPLOY_SCRIPT_GENERATION_CANCELLED.log(project, (Object)this.getStringFromParticipant(source), (Object)this.getStringFromParticipant(target));
    }

    private final String getStringFromParticipant(SchemaCompareParticipant participant) {
        String string;
        SchemaCompareParticipant schemaCompareParticipant = participant;
        if (schemaCompareParticipant instanceof SchemaCompareParticipantForDatabase) {
            string = database;
        } else if (schemaCompareParticipant instanceof SchemaCompareParticipantForProject) {
            string = project;
        } else if (schemaCompareParticipant instanceof SchemaCompareParticipantForDacpac) {
            string = dacpac;
        } else {
            throw new Exception("Unknown participant");
        }
        return string;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Object[] objectArray = new String[]{database, project, dacpac};
        PARTICIPANTS = CollectionsKt.listOf((Object[])objectArray);
        SOURCE = EventFields.String((String)"source_participant", PARTICIPANTS);
        TARGET = EventFields.String((String)"target_participant", PARTICIPANTS);
        COMPARISON_STARTED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"comparison.started", (EventField)((EventField)SOURCE), (EventField)((EventField)TARGET), null, (int)8, null);
        COMPARISON_CANCELLED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"comparison.cancelled", (EventField)((EventField)SOURCE), (EventField)((EventField)TARGET), null, (int)8, null);
        UPDATE_TARGET_STARTED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"deploy.updateTarget.started", (EventField)((EventField)SOURCE), (EventField)((EventField)TARGET), null, (int)8, null);
        UPDATE_TARGET_CANCELLED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"deploy.updateTarget.cancelled", (EventField)((EventField)SOURCE), (EventField)((EventField)TARGET), null, (int)8, null);
        DEPLOY_SCRIPT_GENERATION_STARTED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"deploy.script.generation.started", (EventField)((EventField)SOURCE), (EventField)((EventField)TARGET), null, (int)8, null);
        DEPLOY_SCRIPT_GENERATION_CANCELLED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"deploy.script.generation.cancelled", (EventField)((EventField)SOURCE), (EventField)((EventField)TARGET), null, (int)8, null);
    }
}

