/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj;

import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.jetbrains.rider.plugins.appender.database.sqlproj.SqlProjProjectModelChanges;
import com.jetbrains.rider.plugins.appender.database.sqlproj.utils.DatabaseExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/SqlProjProjectModelSnapshot;", "", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "changes", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/SqlProjProjectModelChanges;", "(Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/SqlProjProjectModelChanges;)V", "getChanges", "()Lcom/jetbrains/rider/plugins/appender/database/sqlproj/SqlProjProjectModelChanges;", "getDatabaseProjects", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "hasDatabaseProjects", "", "intellij.rider.plugins.appender"})
public final class SqlProjProjectModelSnapshot {
    @NotNull
    private final ImmutableEntityStorage storage;
    @Nullable
    private final SqlProjProjectModelChanges changes;

    public SqlProjProjectModelSnapshot(@NotNull ImmutableEntityStorage storage, @Nullable SqlProjProjectModelChanges changes) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        this.changes = changes;
    }

    @Nullable
    public final SqlProjProjectModelChanges getChanges() {
        return this.changes;
    }

    @NotNull
    public final List<ProjectModelEntity> getDatabaseProjects() {
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((EntityStorage)((EntityStorage)this.storage));
        if (projectModelEntity == null) {
            return CollectionsKt.emptyList();
        }
        ProjectModelEntity solutionEntity = projectModelEntity;
        var visitor2 = new ProjectModelEntityVisitor(){
            @NotNull
            private final ArrayList<ProjectModelEntity> projects;
            {
                this.projects = new ArrayList<E>();
            }

            @NotNull
            public final ArrayList<ProjectModelEntity> getProjects() {
                return this.projects;
            }

            @NotNull
            protected ProjectModelEntityVisitor.Result visitProject(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                if (DatabaseExtensionsKt.isDatabaseProject(entity)) {
                    this.projects.add(entity);
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }
        };
        visitor2.visit(solutionEntity);
        return visitor2.getProjects();
    }

    public final boolean hasDatabaseProjects() {
        return !((Collection)this.getDatabaseProjects()).isEmpty();
    }
}

