/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.driver;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.application.PathManager;
import com.jetbrains.rider.NetCoreRuntime;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/driver/JbDriverParamsProvider;", "Lcom/intellij/database/run/ConsoleConfigurationParamProvider;", "()V", "getPathToBackend", "", "getPathToDotnet", "populate", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/ParametersList;", "env", "", "intellij.rider.plugins.appender"})
public final class JbDriverParamsProvider
implements ConsoleConfigurationParamProvider {
    public void populate(@NotNull LocalDataSource dataSource, @NotNull ParametersList params2, @NotNull Map<String, String> env) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        if (MsUtils.isJbMsDriver((DatabaseDriver)dataSource.getDatabaseDriver())) {
            params2.addProperty("jetbrains.sqlserver.driver.dotnet.path", this.getPathToDotnet());
            params2.addProperty("jetbrains.sqlserver.driver.backend.path", this.getPathToBackend());
        }
    }

    private final String getPathToDotnet() {
        return (String)NetCoreRuntime.INSTANCE.getCliPath().getValue();
    }

    private final String getPathToBackend() {
        return PathManager.getHomePath() + "/tools/JbMsDriver/Backend/JdbcDriver.Backend.Host.dll";
    }
}

