/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.driver;

import com.intellij.database.actions.diagnostic.JdbcLogSettings;
import com.intellij.database.actions.diagnostic.LogInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dialects.mssql.MsUtils;
import com.intellij.database.remote.jdbc.RemoteDriver;
import com.jetbrains.rider.plugins.appender.database.driver.IdeConsoleHandler;
import java.io.StringWriter;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J \u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/driver/JbDriverLogInterceptor;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor;", "()V", "createLoggingConfig", "", "intercept", "Ljava/util/concurrent/CompletionStage;", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "proto", "silent", "", "isUserLoggingEnabled", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nJbDriverLogInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JbDriverLogInterceptor.kt\ncom/jetbrains/rider/plugins/appender/database/driver/JbDriverLogInterceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class JbDriverLogInterceptor
implements DatabaseConnectionInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String baseLoggerName = "com.jetbrains.jdbc.sqlserver";
    private static final String ideConsoleHandler = IdeConsoleHandler.class.getName();
    private static final Level loggingLevel = Level.INFO;

    @Nullable
    public CompletionStage<DatabaseConnectionInterceptor.ProtoConnection> intercept(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        if (!MsUtils.isJbMsDriver((DatabaseDriver)proto.getConnectionPoint().getDatabaseDriver()) || this.isUserLoggingEnabled(proto)) {
            return CompletableFuture.completedFuture(proto);
        }
        RemoteDriver remoteDriver = proto.getDriver();
        if (remoteDriver != null) {
            remoteDriver.setLogConfig(this.createLoggingConfig());
        }
        LogInterceptor.Companion.getLOG_OVERRIDDEN().put(proto.getExtraProperties(), (Object)true);
        return CompletableFuture.completedFuture(proto);
    }

    private final boolean isUserLoggingEnabled(DatabaseConnectionInterceptor.ProtoConnection proto) {
        JdbcLogSettings jdbcLogSettings;
        JdbcLogSettings $this$isUserLoggingEnabled_u24lambda_u240 = jdbcLogSettings = new JdbcLogSettings(false, null, null, null, null, false, 63, null);
        boolean bl = false;
        $this$isUserLoggingEnabled_u24lambda_u240.load(proto.getConnectionPoint());
        JdbcLogSettings settings2 = jdbcLogSettings;
        return settings2.getEnabled();
    }

    private final String createLoggingConfig() {
        Properties properties2;
        Properties $this$createLoggingConfig_u24lambda_u241 = properties2 = new Properties();
        boolean bl = false;
        $this$createLoggingConfig_u24lambda_u241.setProperty("com.jetbrains.jdbc.sqlserver.handlers", ideConsoleHandler);
        $this$createLoggingConfig_u24lambda_u241.setProperty("com.jetbrains.jdbc.sqlserver.level", loggingLevel.getName());
        $this$createLoggingConfig_u24lambda_u241.setProperty(ideConsoleHandler + ".level", loggingLevel.getName());
        Properties properties3 = properties2;
        StringWriter writer = new StringWriter();
        properties3.store(writer, null);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/driver/JbDriverLogInterceptor$Companion;", "", "()V", "baseLoggerName", "", "ideConsoleHandler", "kotlin.jvm.PlatformType", "loggingLevel", "Ljava/util/logging/Level;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

