/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.url.session;

import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Driver;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DriverDownloadingManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.ModificationType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSessionBase;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.UrlEditorModelProvider;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.url.services.ProcessedUrl;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.url.services.UrlProcessor;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.url.ui.UrlsComboBox;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\u001a\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010)H\u0014J\u0016\u0010-\u001a\u00020%2\u0006\u0010.\u001a\u00020/2\u0006\u0010&\u001a\u00020'R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u001c8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/url/session/UrlSelectedDriverSession;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSessionBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "driver", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "oldSession", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;", "driverDownloadingManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverDownloadingManager;", "modelProvider", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/UrlEditorModelProvider;", "urlsComboBox", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/url/ui/UrlsComboBox;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverDownloadingManager;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/UrlEditorModelProvider;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/url/ui/UrlsComboBox;)V", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "getConnectionType", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "forceNoAuthProvider", "", "getForceNoAuthProvider", "()Z", "setForceNoAuthProvider", "(Z)V", "processedUrl", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/url/services/ProcessedUrl;", "getProcessedUrl", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "processingUrl", "getProcessingUrl", "urlProcessor", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/url/services/UrlProcessor;", "modelStateChanged", "", "modificationType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/ModificationType;", "selectAuthProviderAfterDataSourceChange", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "oldAuthProvider", "urlChanged", "newUrl", "", "intellij.rider.plugins.appender"})
public final class UrlSelectedDriverSession
extends SelectedDriverSessionBase {
    @NotNull
    private final UrlsComboBox urlsComboBox;
    @NotNull
    private final UrlProcessor urlProcessor;
    @NotNull
    private final ConnectionType connectionType;
    private boolean forceNoAuthProvider;

    public UrlSelectedDriverSession(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull Driver driver, @Nullable SelectedDriverSession oldSession, @NotNull DriverDownloadingManager driverDownloadingManager, @NotNull UrlEditorModelProvider modelProvider, @NotNull UrlsComboBox urlsComboBox) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)driverDownloadingManager, (String)"driverDownloadingManager");
        Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)urlsComboBox), (String)"urlsComboBox");
        super(lifetime, project, driver, oldSession, true, driverDownloadingManager, modelProvider);
        this.urlsComboBox = urlsComboBox;
        this.connectionType = ConnectionType.Url;
        this.urlProcessor = new UrlProcessor(project, this, this.urlsComboBox);
        this.startProblemsAnalyzer();
    }

    @NotNull
    public final IPropertyView<Boolean> getProcessingUrl() {
        return this.urlProcessor.getProcessing();
    }

    @NotNull
    public final IPropertyView<ProcessedUrl> getProcessedUrl() {
        return this.urlProcessor.getProcessedUrl();
    }

    @Override
    @NotNull
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public final boolean getForceNoAuthProvider() {
        return this.forceNoAuthProvider;
    }

    public final void setForceNoAuthProvider(boolean bl) {
        this.forceNoAuthProvider = bl;
    }

    public final void urlChanged(@NotNull String newUrl, @NotNull ModificationType modificationType) {
        UrlEditorModel urlEditorModel;
        Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)modificationType), (String)"modificationType");
        UrlEditorModel $this$urlChanged_u24lambda_u240 = urlEditorModel = this.getModel();
        boolean bl = false;
        $this$urlChanged_u24lambda_u240.setUrl(newUrl);
        $this$urlChanged_u24lambda_u240.commit((Object)modificationType);
    }

    @Override
    protected void modelStateChanged(@NotNull ModificationType modificationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)modificationType), (String)"modificationType");
        if (modificationType == ModificationType.Code) {
            this.urlsComboBox.setText(this.getModel().getUrl());
        }
    }

    @Override
    @NotNull
    protected DatabaseAuthProvider selectAuthProviderAfterDataSourceChange(@NotNull LocalDataSource dataSource, @Nullable DatabaseAuthProvider oldAuthProvider) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (this.forceNoAuthProvider) {
            DatabaseAuthProvider databaseAuthProvider = DatabaseAuthProvider.Companion.get("no-auth");
            Intrinsics.checkNotNull((Object)databaseAuthProvider);
            return databaseAuthProvider;
        }
        return super.selectAuthProviderAfterDataSourceChange(dataSource, oldAuthProvider);
    }
}

