/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.drivers;

import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Driver;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Drivers;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.ComboBoxListener;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.drivers.DriversComboBox;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.drivers.DriversComboBoxItem;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.drivers.DriversComboBoxRenderer;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.drivers.DriversComboBoxSeparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0018\u0019\u001aB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox;", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBoxItem;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "drivers", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;)V", "currentDriver", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "getCurrentDriver", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "listener", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ComboBoxListener;", "popularDriversManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$PopularDriversManager;", "recentDriversManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$RecentDriversManager;", "getItemsToDisplay", "", "()[Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBoxItem;", "DriversComboBoxModel", "PopularDriversManager", "RecentDriversManager", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDriversComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriversComboBox.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,111:1\n1045#2:112\n37#3,2:113\n*S KotlinDebug\n*F\n+ 1 DriversComboBox.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox\n*L\n36#1:112\n55#1:113,2\n*E\n"})
public final class DriversComboBox
extends ComboBox<DriversComboBoxItem> {
    @NotNull
    private final Drivers drivers;
    @NotNull
    private final RecentDriversManager recentDriversManager;
    @NotNull
    private final PopularDriversManager popularDriversManager;
    @NotNull
    private final ComboBoxListener<DriversComboBoxItem> listener;
    @NotNull
    private final IPropertyView<Driver> currentDriver;

    public DriversComboBox(@NotNull Project project, @NotNull Lifetime lifetime, @NotNull Drivers drivers) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)drivers, (String)"drivers");
        this.drivers = drivers;
        this.recentDriversManager = new RecentDriversManager(project, this.drivers);
        this.popularDriversManager = new PopularDriversManager(this.drivers);
        this.listener = new ComboBoxListener(this);
        this.currentDriver = PropertyCombinatorsKt.map(this.listener.getCurrentItem(), (Function1)currentDriver.1.INSTANCE);
        this.setModel(new DriversComboBoxModel(this.getItemsToDisplay()));
        this.setSelectedItem(this.drivers.getDefaultDriver());
        this.renderer = new DriversComboBoxRenderer();
        this.setSwingPopup(false);
        SourceExKt.adviseNotNull((ISource)this.currentDriver.getChange(), (Lifetime)lifetime, (Function1)((Function1)new Function1<Driver, Unit>(){

            public final void invoke(@NotNull Driver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                recentDriversManager.addToRecent(it);
            }
        }));
    }

    @NotNull
    public final IPropertyView<Driver> getCurrentDriver() {
        return this.currentDriver;
    }

    private final DriversComboBoxItem[] getItemsToDisplay() {
        Set recentDrivers = CollectionsKt.toSet((Iterable)CollectionsKt.reversed((Iterable)this.recentDriversManager.getRecent()));
        Set popularDrivers = CollectionsKt.toSet((Iterable)CollectionsKt.minus((Iterable)this.popularDriversManager.getPopularDrivers(), (Iterable)recentDrivers));
        Iterable $this$sortedBy$iv = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)this.drivers.getAll(), (Iterable)recentDrivers), (Iterable)popularDrivers);
        boolean $i$f$sortedBy = false;
        List otherDrivers = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Driver it = (Driver)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                it = (Driver)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
            }
        });
        List items2 = new ArrayList();
        if (!((Collection)recentDrivers).isEmpty()) {
            items2.add(new DriversComboBoxSeparator("Recent"));
            items2.addAll(recentDrivers);
        }
        if (!((Collection)popularDrivers).isEmpty()) {
            items2.add(new DriversComboBoxSeparator("Popular"));
            items2.addAll(popularDrivers);
        }
        if (!((Collection)otherDrivers).isEmpty()) {
            items2.add(new DriversComboBoxSeparator("Other"));
            items2.addAll(otherDrivers);
        }
        Collection $this$toTypedArray$iv = items2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DriversComboBoxItem[0]);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$DriversComboBoxModel;", "Ljavax/swing/DefaultComboBoxModel;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBoxItem;", "items", "", "([Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBoxItem;)V", "setSelectedItem", "", "item", "", "intellij.rider.plugins.appender"})
    private static final class DriversComboBoxModel
    extends DefaultComboBoxModel<DriversComboBoxItem> {
        public DriversComboBoxModel(@NotNull DriversComboBoxItem[] items2) {
            Intrinsics.checkNotNullParameter((Object)items2, (String)"items");
            super(items2);
        }

        @Override
        public void setSelectedItem(@NotNull Object item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (item instanceof DriversComboBoxSeparator) {
                return;
            }
            super.setSelectedItem(item);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$PopularDriversManager;", "", "drivers", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;", "(Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;)V", "getPopularDrivers", "", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "Companion", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nDriversComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriversComboBox.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$PopularDriversManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1603#2,9:112\n1855#2:121\n288#2,2:122\n1856#2:125\n1612#2:126\n1#3:124\n*S KotlinDebug\n*F\n+ 1 DriversComboBox.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$PopularDriversManager\n*L\n103#1:112,9\n103#1:121\n107#1:122,2\n103#1:125\n103#1:126\n103#1:124\n*E\n"})
    private static final class PopularDriversManager {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Drivers drivers;
        @NotNull
        private static final Set<Dbms> popularDbms;
        @NotNull
        private static final Map<Dbms, String> dbmsToDriverId;

        public PopularDriversManager(@NotNull Drivers drivers) {
            Intrinsics.checkNotNullParameter((Object)drivers, (String)"drivers");
            this.drivers = drivers;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<Driver> getPopularDrivers() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = popularDbms;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Driver driver;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Dbms dbms = (Dbms)element$iv$iv;
                boolean bl2 = false;
                Collection<Driver> driversForDbms = this.drivers.getDriversFor(dbms);
                if (dbmsToDriverId.get(dbms) == null) {
                    driver = (Driver)CollectionsKt.firstOrNull((Iterable)driversForDbms);
                } else {
                    Object v1;
                    block4: {
                        Iterable $this$firstOrNull$iv = driversForDbms;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            String driverIdForThisDbms;
                            Driver it = (Driver)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getDatabaseDriver().getId(), (Object)driverIdForThisDbms)) continue;
                            v1 = element$iv;
                            break block4;
                        }
                        v1 = null;
                    }
                    driver = v1;
                }
                if (driver == null) continue;
                Driver it$iv$iv = driver;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        static {
            Object object = SetsKt.createSetBuilder();
            Set $this$popularDbms_u24lambda_u242 = object;
            boolean bl = false;
            Dbms dbms = Dbms.MSSQL;
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"MSSQL");
            $this$popularDbms_u24lambda_u242.add(dbms);
            Dbms dbms2 = Dbms.MSSQL_LOCALDB;
            Intrinsics.checkNotNullExpressionValue((Object)dbms2, (String)"MSSQL_LOCALDB");
            $this$popularDbms_u24lambda_u242.add(dbms2);
            Dbms dbms3 = Dbms.MYSQL;
            Intrinsics.checkNotNullExpressionValue((Object)dbms3, (String)"MYSQL");
            $this$popularDbms_u24lambda_u242.add(dbms3);
            Dbms dbms4 = Dbms.MONGO;
            Intrinsics.checkNotNullExpressionValue((Object)dbms4, (String)"MONGO");
            $this$popularDbms_u24lambda_u242.add(dbms4);
            Dbms dbms5 = Dbms.POSTGRES;
            Intrinsics.checkNotNullExpressionValue((Object)dbms5, (String)"POSTGRES");
            $this$popularDbms_u24lambda_u242.add(dbms5);
            Dbms dbms6 = Dbms.SQLITE;
            Intrinsics.checkNotNullExpressionValue((Object)dbms6, (String)"SQLITE");
            $this$popularDbms_u24lambda_u242.add(dbms6);
            Dbms dbms7 = RedisDbms.REDIS;
            Intrinsics.checkNotNullExpressionValue((Object)dbms7, (String)"REDIS");
            $this$popularDbms_u24lambda_u242.add(dbms7);
            Dbms dbms8 = Dbms.MARIA;
            Intrinsics.checkNotNullExpressionValue((Object)dbms8, (String)"MARIA");
            $this$popularDbms_u24lambda_u242.add(dbms8);
            Dbms dbms9 = Dbms.ORACLE;
            Intrinsics.checkNotNullExpressionValue((Object)dbms9, (String)"ORACLE");
            $this$popularDbms_u24lambda_u242.add(dbms9);
            popularDbms = SetsKt.build((Set)object);
            Object $this$dbmsToDriverId_u24lambda_u243 = object = MapsKt.createMapBuilder();
            boolean bl2 = false;
            Dbms dbms10 = Dbms.MONGO;
            Intrinsics.checkNotNullExpressionValue((Object)dbms10, (String)"MONGO");
            $this$dbmsToDriverId_u24lambda_u243.put(dbms10, "mongo");
            dbmsToDriverId = MapsKt.build((Map)object);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$PopularDriversManager$Companion;", "", "()V", "dbmsToDriverId", "", "Lcom/intellij/database/Dbms;", "", "popularDbms", "", "intellij.rider.plugins.appender"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$RecentDriversManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "drivers", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Drivers;)V", "addToRecent", "", "driver", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "getRecent", "", "Companion", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nDriversComboBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriversComboBox.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$RecentDriversManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1603#2,9:112\n1855#2:121\n1856#2:123\n1612#2:124\n1#3:122\n*S KotlinDebug\n*F\n+ 1 DriversComboBox.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$RecentDriversManager\n*L\n71#1:112,9\n71#1:121\n71#1:123\n71#1:124\n71#1:122\n*E\n"})
    private static final class RecentDriversManager {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Project project;
        @NotNull
        private final Drivers drivers;
        @NotNull
        private static final String LRU_KEY = "DatabaseDriversLRU";

        public RecentDriversManager(@NotNull Project project, @NotNull Drivers drivers) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)drivers, (String)"drivers");
            this.project = project;
            this.drivers = drivers;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<Driver> getRecent() {
            void $this$mapNotNullTo$iv$iv;
            List list2 = DatabaseViewActions.getLRUNames((Project)this.project, (String)LRU_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLRUNames(...)");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Driver it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (this.drivers.findById(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public final void addToRecent(@NotNull Driver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            DatabaseViewActions.addToLRUNames((Project)this.project, (int)5, (String)LRU_KEY, (String)driver.getId());
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/drivers/DriversComboBox$RecentDriversManager$Companion;", "", "()V", "LRU_KEY", "", "intellij.rider.plugins.appender"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

