/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.reactive.Signal;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u000fJ\r\u0010\u001b\u001a\t\u0018\u00010\u001c\u00a2\u0006\u0002\b\u001dJ\u000b\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b J\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u0015J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u000fH\u0002J\"\u0010%\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\t2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\u0016\u0010)\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0015J\u0006\u0010+\u001a\u00020\u000fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "currentModel", "Lcom/intellij/database/dataSource/url/template/UrlEditorModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/access/DatabaseCredentials;Lcom/intellij/database/dataSource/url/template/UrlEditorModel;)V", "authPanel", "Lcom/intellij/database/dataSource/url/ui/DatabaseAuthPanel;", "authTypeSelected", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getAuthTypeSelected", "()Lcom/jetbrains/rd/util/reactive/Signal;", "fieldValueChanged", "getFieldValueChanged", "isPopupOpen", "", "loopPreventor", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler$LoopPreventor;", "authFieldValueChanged", "disable", "enable", "getAuthWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "Lorg/jetbrains/annotations/Nullable;", "getComponent", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "getPreferredFocusedComponent", "isNeeded", "isUserChangeToAuthFields", "processAuthTypeSelection", "reinitialize", "model", "authProvider", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "save", "copyCredentials", "updateFromUrl", "LoopPreventor", "intellij.rider.plugins.appender"})
public final class AuthHandler {
    @NotNull
    private UrlEditorModel currentModel;
    @NotNull
    private final DatabaseAuthPanel authPanel;
    @NotNull
    private final LoopPreventor loopPreventor;
    private boolean isPopupOpen;
    @NotNull
    private final Signal<Unit> authTypeSelected;
    @NotNull
    private final Signal<Unit> fieldValueChanged;

    public AuthHandler(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DatabaseCredentials credentials2, @NotNull UrlEditorModel currentModel2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)credentials2, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)currentModel2, (String)"currentModel");
        this.currentModel = currentModel2;
        this.authPanel = new DatabaseAuthPanel(project, (DatabaseConnectionConfig)dataSource, credentials2);
        this.loopPreventor = new LoopPreventor();
        this.authTypeSelected = new Signal();
        this.fieldValueChanged = new Signal();
        this.authPanel.addListeners(this::authFieldValueChanged, arg_0 -> AuthHandler._init_$lambda$0(this, arg_0));
        this.authPanel.getAuthComboBox().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(@Nullable PopupMenuEvent e) {
                isPopupOpen = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(@Nullable PopupMenuEvent e) {
                isPopupOpen = false;
                this.processAuthTypeSelection();
            }

            @Override
            public void popupMenuCanceled(@Nullable PopupMenuEvent e) {
                isPopupOpen = false;
            }
        });
        AuthHandler.reinitialize$default(this, dataSource, this.currentModel, null, 4, null);
    }

    @NotNull
    public final Signal<Unit> getAuthTypeSelected() {
        return this.authTypeSelected;
    }

    @NotNull
    public final Signal<Unit> getFieldValueChanged() {
        return this.fieldValueChanged;
    }

    public final void updateFromUrl() {
        this.loopPreventor.enable();
        DatabaseAuthProvider.AuthWidget authWidget = this.authPanel.getAuthWidget();
        if (authWidget != null) {
            authWidget.updateFromUrl((ParametersHolder)this.currentModel);
        }
        this.loopPreventor.disable();
        this.authPanel.getComponent().revalidate();
        this.authPanel.getComponent().repaint();
    }

    public final void reinitialize(@NotNull LocalDataSource dataSource, @NotNull UrlEditorModel model, @Nullable DatabaseAuthProvider authProvider) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.currentModel = model;
        this.loopPreventor.enable();
        this.authPanel.reset((DatabaseConnectionConfig)dataSource, false);
        this.authPanel.validateAuthTypes((DatabaseConnectionConfig)dataSource, authProvider);
        this.loopPreventor.disable();
        this.authPanel.getComponent().revalidate();
        this.authPanel.getComponent().repaint();
    }

    public static /* synthetic */ void reinitialize$default(AuthHandler authHandler, LocalDataSource localDataSource, UrlEditorModel urlEditorModel, DatabaseAuthProvider databaseAuthProvider, int n, Object object) {
        if ((n & 4) != 0) {
            databaseAuthProvider = null;
        }
        authHandler.reinitialize(localDataSource, urlEditorModel, databaseAuthProvider);
    }

    public final void save(@NotNull LocalDataSource dataSource, boolean copyCredentials) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.authPanel.save((DatabaseConnectionConfig)dataSource, copyCredentials);
    }

    private final void processAuthTypeSelection() {
        if (this.isPopupOpen) {
            return;
        }
        this.updateFromUrl();
        this.authTypeSelected.fire((Object)Unit.INSTANCE);
    }

    private final void authFieldValueChanged() {
        if (this.isUserChangeToAuthFields()) {
            if (this.currentModel.isParserValid()) {
                DatabaseAuthProvider.AuthWidget authWidget = this.authPanel.getAuthWidget();
                if (authWidget != null) {
                    authWidget.updateUrl((MutableParametersHolder)this.currentModel);
                }
            }
            this.currentModel.commit((Object)true);
        }
        this.fieldValueChanged.fire((Object)Unit.INSTANCE);
    }

    public final boolean isNeeded() {
        return this.authPanel.isNeeded();
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.authPanel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.authPanel.getPreferredFocusedComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getPreferredFocusedComponent(...)");
        return jComponent;
    }

    @Nullable
    public final DatabaseAuthProvider.AuthWidget getAuthWidget() {
        return this.authPanel.getAuthWidget();
    }

    public final void enable() {
        this.getComponent().setEnabled(true);
        DatabaseAuthProvider.AuthWidget authWidget = this.authPanel.getAuthWidget();
        JComponent jComponent = authWidget != null ? authWidget.getComponent() : null;
        if (jComponent != null) {
            jComponent.setEnabled(true);
        }
    }

    public final void disable() {
        this.getComponent().setEnabled(false);
        DatabaseAuthProvider.AuthWidget authWidget = this.authPanel.getAuthWidget();
        JComponent jComponent = authWidget != null ? authWidget.getComponent() : null;
        if (jComponent != null) {
            jComponent.setEnabled(false);
        }
    }

    private final boolean isUserChangeToAuthFields() {
        return !this.loopPreventor.isActive();
    }

    private static final void _init_$lambda$0(AuthHandler this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.processAuthTypeSelection();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler$LoopPreventor;", "", "()V", "<set-?>", "", "isActive", "()Z", "disable", "", "enable", "intellij.rider.plugins.appender"})
    private static final class LoopPreventor {
        private boolean isActive;

        public final boolean isActive() {
            return this.isActive;
        }

        public final void enable() {
            this.isActive = true;
        }

        public final void disable() {
            this.isActive = false;
        }
    }
}

