/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.states;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.dialog.DatabaseConnectionDialogManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Navigator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.StepExtensionsKt;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.StepStates;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.states.StepState;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.ConfigurationStatusComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H$J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0014J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/states/NotSupportedDriverStateBase;", "T", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/states/StepState;", "project", "Lcom/intellij/openapi/project/Project;", "step", "session", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;", "navigator", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "dialogManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialogManager;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialogManager;)V", "getStep", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "entered", "", "stateActiveLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "from", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/StepStates;", "getComponentForWarningDisplay", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/ConfigurationStatusComponent;", "nextPressed", "prepareComponentsForStateEntering", "previousPressed", "intellij.rider.plugins.appender"})
public abstract class NotSupportedDriverStateBase<T extends DatabaseConnectionStep>
implements StepState {
    @NotNull
    private final Project project;
    @NotNull
    private final T step;
    @NotNull
    private final SelectedDriverSession session;
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final DatabaseConnectionDialogManager dialogManager;

    public NotSupportedDriverStateBase(@NotNull Project project, @NotNull T step, @NotNull SelectedDriverSession session, @NotNull Navigator navigator, @NotNull DatabaseConnectionDialogManager dialogManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)dialogManager, (String)"dialogManager");
        this.project = project;
        this.step = step;
        this.session = session;
        this.navigator = navigator;
        this.dialogManager = dialogManager;
    }

    @NotNull
    protected final T getStep() {
        return this.step;
    }

    @Override
    public void nextPressed() {
        this.dialogManager.close();
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        DbPsiFacade facade = dbPsiFacade;
        DataSourceManagerDialog.showDialog((DbPsiFacade)facade, (Object)this.session.getDataSource(), (DatabaseCredentials)this.session.getCredentials());
    }

    @Override
    public void previousPressed() {
        this.navigator.movePrevious();
    }

    @Override
    public void entered(@NotNull Lifetime stateActiveLifetime, @NotNull StepStates from) {
        Intrinsics.checkNotNullParameter((Object)stateActiveLifetime, (String)"stateActiveLifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)from), (String)"from");
        StepExtensionsKt.enable(this.step);
        this.prepareComponentsForStateEntering();
        Object object = this.getComponentForWarningDisplay();
        ConfigurationStatusComponent $this$entered_u24lambda_u240 = object;
        boolean bl = false;
        $this$entered_u24lambda_u240.enable();
        ConfigurationStatusComponent.showWarning$default($this$entered_u24lambda_u240, RiderDatabaseBundle.message("setup.process.for.this.database.type.will.proceed.in.full.ui", new Object[0]), null, 2, null);
        Object $this$entered_u24lambda_u241 = object = this.dialogManager;
        boolean bl2 = false;
        if (this.navigator.isCurrentStepFirst()) {
            $this$entered_u24lambda_u241.disableBackButton();
        } else {
            $this$entered_u24lambda_u241.enableBackButton();
        }
        $this$entered_u24lambda_u241.setNextButtonText(RiderDatabaseBundle.message("dialog.button.next", new Object[0]));
        ((DatabaseConnectionStep)this.step).focus(stateActiveLifetime, this.dialogManager.getNextButton());
    }

    protected void prepareComponentsForStateEntering() {
    }

    @NotNull
    protected abstract ConfigurationStatusComponent getComponentForWarningDisplay();
}

