/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.ui.DynamicJdbcUrlEditor;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.common.StringFun;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.AddRemove;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IViewableSet;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Driver;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DriverDownloadingManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.problems.ProblemsManager;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.ModificationType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SharedStorage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.UrlEditorModelProvider;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.AuthHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u00109\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\"\u0010;\u001a\u00020 2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010 H\u0002J\u000e\u0010?\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010@J\b\u0010A\u001a\u000206H\u0016J\b\u0010B\u001a\u00020\u0017H\u0016J\b\u0010C\u001a\u00020=H\u0016J\b\u0010D\u001a\u00020\u0017H\u0002J\r\u0010E\u001a\u00070\u0017\u00a2\u0006\u0002\bFH\u0016J\u0010\u0010G\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010H\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010I\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010J\u001a\u00020:2\u0006\u0010K\u001a\u00020LH\u0014J\u0012\u0010J\u001a\u00020:2\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J@\u0010O\u001a\u00020:26\u0010P\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u001106\u00a2\u0006\f\bR\u0012\b\bS\u0012\u0004\b\b(T\u0012\u0004\u0012\u00020:0QH\u0016J\b\u0010U\u001a\u00020:H\u0016J\u0010\u0010V\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010W\u001a\u00020X2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010Y\u001a\u0004\u0018\u00010XH\u0014J\u001a\u0010Z\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010Y\u001a\u0004\u0018\u00010XH\u0002J\u0010\u0010[\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\\\u001a\u00020:H\u0004J\u0010\u0010]\u001a\u00020:2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001cR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0%0$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006^"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSessionBase;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "driver", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "oldSession", "isUrlOnly", "", "driverDownloadingManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverDownloadingManager;", "modelProvider", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/UrlEditorModelProvider;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;ZLcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverDownloadingManager;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/UrlEditorModelProvider;)V", "_isDriverDownloaded", "Lcom/jetbrains/rd/util/reactive/Property;", "authHandler", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler;", "getAuthHandler", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDriver", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "isDriverDownloaded", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/intellij/database/dataSource/url/template/UrlEditorModel;", "getModel", "()Lcom/intellij/database/dataSource/url/template/UrlEditorModel;", "problems", "Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "", "Lcom/intellij/database/dataSource/validation/DataSourceProblem;", "getProblems", "()Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "problemsManager", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/problems/ProblemsManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "storage", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SharedStorage;", "getStorage", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SharedStorage;", "tempCredentials", "Lcom/intellij/database/access/DatabaseCredentials;", "getTempCredentials", "()Lcom/intellij/database/access/DatabaseCredentials;", "applyChangesToDataSource", "", "createNewModel", "url", "", "oldModel", "downloadDriver", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCredentials", "getDataSource", "getDataSourceIdentifier", "getDataSourceWithoutSync", "getOneTimeDataSource", "Lorg/jetbrains/annotations/NotNull;", "handleChangeInDataSource", "hasActiveConfigurations", "isAddedSuccessfully", "modelStateChanged", "modificationType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/ModificationType;", "arg", "", "modify", "func", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "credentials", "resetCredentials", "saveDataSource", "selectAuthProviderAfterDataSourceChange", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "oldAuthProvider", "setAppropriateAuthProvider", "shouldDeactivate", "startProblemsAnalyzer", "updateUrl", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nSelectedDriverSessionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectedDriverSessionBase.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSessionBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StringFun.kt\ncom/intellij/database/util/common/StringFun\n*L\n1#1,183:1\n1#2:184\n133#3:185\n*S KotlinDebug\n*F\n+ 1 SelectedDriverSessionBase.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSessionBase\n*L\n79#1:185\n*E\n"})
public abstract class SelectedDriverSessionBase
implements SelectedDriverSession {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Project project;
    @NotNull
    private final Driver driver;
    private final boolean isUrlOnly;
    @NotNull
    private final DriverDownloadingManager driverDownloadingManager;
    @NotNull
    private final UrlEditorModelProvider modelProvider;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AuthHandler authHandler;
    @NotNull
    private final UrlEditorModel model;
    @NotNull
    private final ProblemsManager problemsManager;
    @NotNull
    private final LocalDataSource dataSource;
    @NotNull
    private final Property<Boolean> _isDriverDownloaded;
    @NotNull
    private final DatabaseCredentials tempCredentials;
    @NotNull
    private final IOptPropertyView<Collection<DataSourceProblem>> problems;
    @NotNull
    private final SharedStorage storage;
    @NotNull
    private final IPropertyView<Boolean> isDriverDownloaded;

    /*
     * WARNING - void declaration
     */
    public SelectedDriverSessionBase(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull Driver driver, @Nullable SelectedDriverSession oldSession, boolean isUrlOnly, @NotNull DriverDownloadingManager driverDownloadingManager, @NotNull UrlEditorModelProvider modelProvider) {
        void $this$dataSource_u24lambda_u240;
        LocalDataSource localDataSource;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)driverDownloadingManager, (String)"driverDownloadingManager");
        Intrinsics.checkNotNullParameter((Object)modelProvider, (String)"modelProvider");
        this.lifetime = lifetime;
        this.project = project;
        this.driver = driver;
        this.isUrlOnly = isUrlOnly;
        this.driverDownloadingManager = driverDownloadingManager;
        this.modelProvider = modelProvider;
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)this.lifetime.getCoroutineScope(), null, (boolean)false, (int)3, null);
        this.problemsManager = new ProblemsManager(this.lifetime, this.project);
        LocalDataSource localDataSource2 = localDataSource = this.driver.getDatabaseDriver().createDataSource(null);
        SelectedDriverSessionBase selectedDriverSessionBase = this;
        boolean bl = false;
        $this$dataSource_u24lambda_u240.setPasswordStorage(LocalDataSource.Storage.PERSIST);
        $this$dataSource_u24lambda_u240.setAutoSynchronize(false);
        LocalDataSource localDataSource3 = localDataSource;
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource3, (String)"apply(...)");
        selectedDriverSessionBase.dataSource = localDataSource3;
        this._isDriverDownloaded = new Property((Object)this.driverDownloadingManager.checkDriver(this.driver.getDatabaseDriver()));
        DatabaseCredentials databaseCredentials = DatabaseCredentialsUi.newUIInstance();
        Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"newUIInstance(...)");
        this.tempCredentials = databaseCredentials;
        this.problems = this.problemsManager.getProblems();
        this.storage = new SharedStorage();
        this.isDriverDownloaded = (IPropertyView)this._isDriverDownloaded;
        SelectedDriverSession selectedDriverSession = oldSession;
        this.model = this.createNewModel(this.driver, StringFun.or((String)this.dataSource.getUrl(), (String)""), (UrlEditorModel)(selectedDriverSession != null ? selectedDriverSession.getModel() : null));
        this.authHandler = new AuthHandler(this.project, this.getDataSourceWithoutSync(), this.tempCredentials, this.model);
        this.model.addListener(this::modelStateChanged, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null));
        this.authHandler.getFieldValueChanged().advise(this.lifetime, (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.startProblemsAnalyzer();
            }
        });
        this.authHandler.getAuthTypeSelected().advise(this.lifetime, (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.startProblemsAnalyzer();
            }
        });
        this.driverDownloadingManager.getDownloadedDrivers().getChange().advise(this.lifetime, (Function1)new Function1<IViewableSet.Event<DatabaseDriver>, Unit>(){

            public final void invoke(@NotNull IViewableSet.Event<DatabaseDriver> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                if (!Intrinsics.areEqual((Object)event.getValue(), (Object)this.getDriver().getDatabaseDriver())) {
                    return;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[event.getKind().ordinal()]) {
                    case 1: {
                        _isDriverDownloaded.set((Object)true);
                        break;
                    }
                    case 2: {
                        _isDriverDownloaded.set((Object)false);
                    }
                }
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[AddRemove.values().length];
                    try {
                        nArray[AddRemove.Add.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[AddRemove.Remove.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                if (this.shouldDeactivate(dataSource)) {
                    SessionsUtil.deactivateDataSourceAsync$default((Project)this.getProject(), (LocalDataSource)dataSource, null, (int)4, null);
                }
            }
        });
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public final Driver getDriver() {
        return this.driver;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    @Override
    @NotNull
    public final AuthHandler getAuthHandler() {
        return this.authHandler;
    }

    @Override
    @NotNull
    public final UrlEditorModel getModel() {
        return this.model;
    }

    @NotNull
    public final DatabaseCredentials getTempCredentials() {
        return this.tempCredentials;
    }

    @Override
    @NotNull
    public IOptPropertyView<Collection<DataSourceProblem>> getProblems() {
        return this.problems;
    }

    @Override
    @NotNull
    public SharedStorage getStorage() {
        return this.storage;
    }

    @Override
    @NotNull
    public IPropertyView<Boolean> isDriverDownloaded() {
        return this.isDriverDownloaded;
    }

    @Override
    @NotNull
    public LocalDataSource getDataSource() {
        LocalDataSource localDataSource;
        LocalDataSource $this$getDataSource_u24lambda_u241 = localDataSource = this.dataSource;
        boolean bl = false;
        this.saveDataSource($this$getDataSource_u24lambda_u241);
        return localDataSource;
    }

    @Override
    @NotNull
    public LocalDataSource getOneTimeDataSource() {
        LocalDataSource localDataSource;
        LocalDataSource $this$getOneTimeDataSource_u24lambda_u242 = localDataSource = this.dataSource.copy(true);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$getOneTimeDataSource_u24lambda_u242);
        this.saveDataSource($this$getOneTimeDataSource_u24lambda_u242);
        LocalDataSource localDataSource2 = localDataSource;
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource2, (String)"apply(...)");
        return localDataSource2;
    }

    @Override
    @NotNull
    public DatabaseCredentials getCredentials() {
        return this.tempCredentials;
    }

    @Override
    @NotNull
    public String getDataSourceIdentifier() {
        LocalDataSource dataSource = this.getDataSource();
        String string = DynamicJdbcUrlEditor.getIdentifier((UrlEditorModel)this.model, (DatabaseDriver)this.driver.getDatabaseDriver(), (RawConnectionConfig)((RawConnectionConfig)dataSource), (String)this.model.getUrl());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
        String identifierFromParameters = string;
        CharSequence $this$isNotNullOrEmpty$iv = identifierFromParameters;
        boolean $i$f$isNotNullOrEmpty = false;
        boolean bl = $this$isNotNullOrEmpty$iv.length() > 0;
        if (bl) {
            return identifierFromParameters;
        }
        String string2 = dataSource.getDbms().getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        return string2;
    }

    @Override
    public void modify(@NotNull Function2<? super LocalDataSource, ? super DatabaseCredentials, Unit> func) {
        Intrinsics.checkNotNullParameter(func, (String)"func");
        LocalDataSource dataSource = this.getDataSource();
        DatabaseCredentials credentials2 = this.getCredentials();
        DatabaseAuthProvider oldAuthProvider = DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)dataSource);
        func.invoke((Object)dataSource, (Object)credentials2);
        dataSource.setDatabaseDriver(this.driver.getDatabaseDriver());
        dataSource.setConfiguredByUrl(this.isUrlOnly);
        this.setAppropriateAuthProvider(dataSource, oldAuthProvider);
        this.updateUrl(dataSource);
        this.handleChangeInDataSource(dataSource);
        this.startProblemsAnalyzer();
    }

    @Override
    @Nullable
    public Object downloadDriver(@NotNull Continuation<? super Boolean> $completion) {
        return this.driverDownloadingManager.downloadDriver(this.driver.getDatabaseDriver(), $completion);
    }

    @Override
    public void resetCredentials() {
        this.authHandler.reinitialize(this.getDataSource(), this.model, DatabaseAuthProvider.Companion.get("no-auth"));
    }

    protected final void startProblemsAnalyzer() {
        this.problemsManager.scheduleFindProblems(this.getDataSource());
    }

    protected void modelStateChanged(@NotNull ModificationType modificationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)modificationType), (String)"modificationType");
    }

    protected void applyChangesToDataSource(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
    }

    protected void handleChangeInDataSource(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
    }

    private final void setAppropriateAuthProvider(LocalDataSource dataSource, DatabaseAuthProvider oldAuthProvider) {
        DatabaseAuthProvider it = this.selectAuthProviderAfterDataSourceChange(dataSource, oldAuthProvider);
        boolean bl = false;
        this.authHandler.reinitialize(dataSource, this.model, it);
    }

    private final void updateUrl(LocalDataSource dataSource) {
        block0: {
            String string = dataSource.getUrl();
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            this.model.setUrl(it);
            this.model.commit((Object)ModificationType.Code);
        }
    }

    @NotNull
    protected DatabaseAuthProvider selectAuthProviderAfterDataSourceChange(@NotNull LocalDataSource dataSource, @Nullable DatabaseAuthProvider oldAuthProvider) {
        DatabaseAuthProvider databaseAuthProvider;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        String string = dataSource.getAuthProviderId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAuthProviderId(...)");
        DatabaseAuthProvider userSelectedAuthProvider = DatabaseAuthProvider.Companion.get(string);
        if (userSelectedAuthProvider != null && DatabaseAuthProvider.Companion.isApplicable(userSelectedAuthProvider, (DatabaseConnectionPoint)dataSource)) {
            databaseAuthProvider = userSelectedAuthProvider;
        } else {
            databaseAuthProvider = oldAuthProvider;
            if (databaseAuthProvider == null) {
                databaseAuthProvider = DatabaseAuthProvider.Companion.getDefault((DatabaseConnectionPoint)dataSource);
            }
        }
        return databaseAuthProvider;
    }

    private final UrlEditorModel createNewModel(Driver driver, String url, UrlEditorModel oldModel) {
        UrlEditorModel newModel = this.modelProvider.getModelForDriver(driver.getDatabaseDriver());
        if (oldModel != null && Intrinsics.areEqual((Object)oldModel.getUrl(), (Object)url)) {
            newModel.assign(oldModel);
        } else {
            newModel.setUrl(url);
        }
        newModel.setUrlOnly(this.isUrlOnly);
        newModel.commit((Object)ModificationType.Code);
        return newModel;
    }

    private final void modelStateChanged(Object arg) {
        ModificationType modificationType = arg instanceof ModificationType ? (ModificationType)((Object)arg) : null;
        if (modificationType == null) {
            return;
        }
        ModificationType modificationType2 = modificationType;
        this.authHandler.updateFromUrl();
        this.modelStateChanged(modificationType2);
        this.startProblemsAnalyzer();
    }

    private final void saveDataSource(LocalDataSource dataSource) {
        dataSource.setDatabaseDriver(this.driver.getDatabaseDriver());
        dataSource.setUrl(this.model.getAnonymizedUrl());
        dataSource.setConfiguredByUrl(this.isUrlOnly);
        this.applyChangesToDataSource(dataSource);
        this.authHandler.save(dataSource, true);
    }

    private final LocalDataSource getDataSourceWithoutSync() {
        return this.dataSource;
    }

    private final boolean shouldDeactivate(LocalDataSource dataSource) {
        return !this.isAddedSuccessfully(dataSource) && this.hasActiveConfigurations(dataSource);
    }

    private final boolean isAddedSuccessfully(LocalDataSource dataSource) {
        return LocalDataSourceManager.getInstance((Project)this.project).getDataSources().contains(dataSource);
    }

    private final boolean hasActiveConfigurations(LocalDataSource dataSource) {
        List list2 = JdbcDriverManager.getDriverManager((Project)this.project).getActiveConfigurations(dataSource);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActiveConfigurations(...)");
        return !((Collection)list2).isEmpty();
    }
}

