/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.problems;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.ConcurrencyUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/problems/ProblemsProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "dispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "loadAllProblems", "", "Lcom/intellij/database/dataSource/validation/DataSourceProblem;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "loadDataSourceProblems", "infoProvider", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/problems/ProblemsProvider$SimpleActualConfigInfoProvider;", "loadDriverProblems", "loadProblems", "(Lcom/intellij/database/dataSource/LocalDataSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SimpleActualConfigInfoProvider", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nProblemsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProblemsProvider.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/problems/ProblemsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class ProblemsProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorCoroutineDispatcher dispatcher;

    public ProblemsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ThreadPoolExecutor threadPoolExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Database Connection Dialog: Data Source problems");
        Intrinsics.checkNotNullExpressionValue((Object)threadPoolExecutor, (String)"newSingleThreadExecutor(...)");
        this.dispatcher = ExecutorsKt.from((ExecutorService)threadPoolExecutor);
    }

    @Nullable
    public final Object loadProblems(@NotNull LocalDataSource dataSource, @NotNull Continuation<? super Set<? extends DataSourceProblem>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Set<? extends DataSourceProblem>>, Object>(this, dataSource, null){
            int label;
            final /* synthetic */ ProblemsProvider this$0;
            final /* synthetic */ LocalDataSource $dataSource;
            {
                this.this$0 = $receiver;
                this.$dataSource = $dataSource;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return ProblemsProvider.access$loadAllProblems(this.this$0, this.$dataSource);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Set<? extends DataSourceProblem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final Set<DataSourceProblem> loadAllProblems(LocalDataSource dataSource) {
        SimpleActualConfigInfoProvider infoProvider = new SimpleActualConfigInfoProvider(this.project, dataSource);
        return SetsKt.plus(this.loadDataSourceProblems(infoProvider), (Iterable)this.loadDriverProblems(infoProvider));
    }

    private final Set<DataSourceProblem> loadDataSourceProblems(SimpleActualConfigInfoProvider infoProvider) {
        Set set = DatabaseConfigValidator.getProblems((Project)this.project, (Object)infoProvider.getDataSource(), (ActualConfigInfoProvider)infoProvider);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getProblems(...)");
        return set;
    }

    private final Set<DataSourceProblem> loadDriverProblems(SimpleActualConfigInfoProvider infoProvider) {
        Set set;
        Set set2;
        DatabaseDriver databaseDriver = infoProvider.getDriver();
        if (databaseDriver != null) {
            DatabaseDriver it = databaseDriver;
            boolean bl = false;
            set2 = DatabaseConfigValidator.getProblems((Project)this.project, (Object)it, (ActualConfigInfoProvider)infoProvider);
        } else {
            set2 = set = null;
        }
        if (set2 == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public static final /* synthetic */ Set access$loadAllProblems(ProblemsProvider $this, LocalDataSource dataSource) {
        return $this.loadAllProblems(dataSource);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0016J\u001f\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/problems/ProblemsProvider$SimpleActualConfigInfoProvider;", "Lcom/intellij/database/view/ui/ActualConfigInfoProvider;", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "driver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "Lorg/jetbrains/annotations/Nullable;", "getDriver", "()Lcom/intellij/database/dataSource/DatabaseDriver;", "getDataSources", "", "getTempTargetOrTarget", "T", "", "target", "(Ljava/lang/Object;)Ljava/lang/Object;", "intellij.rider.plugins.appender"})
    private static final class SimpleActualConfigInfoProvider
    implements ActualConfigInfoProvider {
        @NotNull
        private final LocalDataSource dataSource;
        @NotNull
        private final DbDataSource dbDataSource;
        @Nullable
        private final DatabaseDriver driver;

        public SimpleActualConfigInfoProvider(@NotNull Project project, @NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            this.dataSource = dataSource;
            this.driver = this.dataSource.getDatabaseDriver();
            DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)dbPsiFacade, (String)"null cannot be cast to non-null type com.intellij.database.psi.DbPsiFacadeImpl");
            DbPsiFacadeImpl dbPsiFacade2 = (DbPsiFacadeImpl)dbPsiFacade;
            LocalDataSourceManager localDataSourceManager = LocalDataSourceManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)localDataSourceManager, (String)"getInstance(...)");
            LocalDataSourceManager localDataSourceManager2 = localDataSourceManager;
            DbDataSource dbDataSource = dbPsiFacade2.createDataSourceWrapperElement((RawDataSource)this.dataSource, (DataSourceManager)localDataSourceManager2);
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"createDataSourceWrapperElement(...)");
            this.dbDataSource = dbDataSource;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        @Nullable
        public final DatabaseDriver getDriver() {
            return this.driver;
        }

        @NotNull
        public List<DbDataSource> getDataSources() {
            return CollectionsKt.listOf((Object)this.dbDataSource);
        }

        @NotNull
        public <T> T getTempTargetOrTarget(@NotNull T target) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            return target;
        }
    }
}

