/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation;

import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.DatabaseConnectionDialogPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Steps;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u0018J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u0018J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120\u0018J\u0016\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/RailTracks;", "", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "(Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;)V", "currentSteps", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Steps;", "<set-?>", "currentTrack", "getCurrentTrack", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "manualSteps", "urlSteps", "addStep", "", "step", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "page", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/DatabaseConnectionDialogPage;", "currentStep", "currentStepPosition", "", "getStepsByConnectionType", "goToStep", "Lkotlin/Pair;", "moveNext", "movePrevious", "moveToBeginning", "removeStep", "selectTrack", "", "intellij.rider.plugins.appender"})
public final class RailTracks {
    @NotNull
    private final Steps manualSteps;
    @NotNull
    private final Steps urlSteps;
    @NotNull
    private Steps currentSteps;
    @NotNull
    private ConnectionType currentTrack;

    public RailTracks(@NotNull ConnectionType connectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        this.manualSteps = new Steps();
        this.urlSteps = new Steps();
        this.currentSteps = this.getStepsByConnectionType(connectionType);
        this.currentTrack = connectionType;
    }

    @NotNull
    public final ConnectionType getCurrentTrack() {
        return this.currentTrack;
    }

    public final boolean selectTrack(@NotNull ConnectionType connectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        if (connectionType == this.currentTrack) {
            return false;
        }
        this.currentSteps.moveToBeginning();
        this.currentSteps = this.getStepsByConnectionType(connectionType);
        this.currentTrack = connectionType;
        return true;
    }

    public final void addStep(@NotNull DatabaseConnectionStep step, @NotNull DatabaseConnectionDialogPage page) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.getStepsByConnectionType(step.getConnectionType()).add(step, page);
    }

    public final void removeStep(@NotNull DatabaseConnectionStep step, @NotNull DatabaseConnectionDialogPage page) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.getStepsByConnectionType(step.getConnectionType()).remove(step, page);
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> moveToBeginning() {
        return this.currentSteps.moveToBeginning();
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> moveNext() {
        return this.currentSteps.moveNext();
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> movePrevious() {
        return this.currentSteps.movePrevious();
    }

    @NotNull
    public final DatabaseConnectionStep currentStep() {
        return this.currentSteps.currentStep();
    }

    public final int currentStepPosition() {
        return this.currentSteps.currentStepPosition();
    }

    @NotNull
    public final Pair<DatabaseConnectionStep, DatabaseConnectionDialogPage> goToStep(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        return this.currentSteps.goToStep(step);
    }

    private final Steps getStepsByConnectionType(ConnectionType connectionType) {
        return connectionType == ConnectionType.Url ? this.urlSteps : this.manualSteps;
    }
}

