/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation;

import com.intellij.ui.JBCardLayout;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.DatabaseConnectionDialogPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.RailTracks;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001dJ\u0006\u0010$\u001a\u00020\u001dJ\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u000eJ$\u0010%\u001a\u00020\u001d2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001f0(2\u0006\u0010)\u001a\u00020*H\u0002J\u0006\u0010+\u001a\u00020\u001dR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "panel", "Ljavax/swing/JPanel;", "layout", "Lcom/intellij/ui/JBCardLayout;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;Ljavax/swing/JPanel;Lcom/intellij/ui/JBCardLayout;)V", "_currentTrack", "Lcom/jetbrains/rd/util/reactive/Property;", "<set-?>", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "currentStep", "getCurrentStep", "()Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "currentStepPosition", "", "currentTrack", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getCurrentTrack", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "railTracks", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/RailTracks;", "stepShownLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "addPage", "", "page", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/DatabaseConnectionDialogPage;", "changeTrack", "isCurrentStepFirst", "", "moveNext", "movePrevious", "moveTo", "databaseConnectionStep", "stepAndPage", "Lkotlin/Pair;", "direction", "Lcom/intellij/ui/JBCardLayout$SwipeDirection;", "moveToBeginning", "intellij.rider.plugins.appender"})
public final class Navigator {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final JBCardLayout layout;
    @NotNull
    private final SequentialLifetimes stepShownLifetimes;
    @NotNull
    private final RailTracks railTracks;
    @NotNull
    private final Property<ConnectionType> _currentTrack;
    @NotNull
    private final IPropertyView<ConnectionType> currentTrack;
    private DatabaseConnectionStep currentStep;
    private int currentStepPosition;

    public Navigator(@NotNull Lifetime lifetime, @NotNull ConnectionType connectionType, @NotNull JPanel panel2, @NotNull JBCardLayout layout) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.lifetime = lifetime;
        this.panel = panel2;
        this.layout = layout;
        this.stepShownLifetimes = new SequentialLifetimes(this.lifetime);
        this.railTracks = new RailTracks(connectionType);
        this._currentTrack = new Property((Object)this.railTracks.getCurrentTrack());
        this.currentTrack = (IPropertyView)this._currentTrack;
        this.currentStepPosition = -1;
    }

    @NotNull
    public final IPropertyView<ConnectionType> getCurrentTrack() {
        return this.currentTrack;
    }

    @NotNull
    public final DatabaseConnectionStep getCurrentStep() {
        DatabaseConnectionStep databaseConnectionStep = this.currentStep;
        if (databaseConnectionStep != null) {
            return databaseConnectionStep;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentStep");
        return null;
    }

    public final void changeTrack(@NotNull ConnectionType connectionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        if (this.railTracks.selectTrack(connectionType)) {
            this.moveToBeginning();
        }
    }

    public final void addPage(@NotNull DatabaseConnectionDialogPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.panel.add((Component)page.getComponent(), page.getId());
        InterfacesKt.viewNotNull((IViewable)((IViewable)page.getSteps()), (Lifetime)this.lifetime, (Function2)((Function2)new Function2<Lifetime, DatabaseConnectionStep, Unit>(this, page){
            final /* synthetic */ Navigator this$0;
            final /* synthetic */ DatabaseConnectionDialogPage $page;
            {
                this.this$0 = $receiver;
                this.$page = $page;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lf, @NotNull DatabaseConnectionStep step) {
                Intrinsics.checkNotNullParameter((Object)lf, (String)"lf");
                Intrinsics.checkNotNullParameter((Object)step, (String)"step");
                lf.bracketIfAlive((Function0)new Function0<Unit>(this.this$0, step, this.$page){
                    final /* synthetic */ Navigator this$0;
                    final /* synthetic */ DatabaseConnectionStep $step;
                    final /* synthetic */ DatabaseConnectionDialogPage $page;
                    {
                        this.this$0 = $receiver;
                        this.$step = $step;
                        this.$page = $page;
                        super(0);
                    }

                    public final void invoke() {
                        Navigator.access$getRailTracks$p(this.this$0).addStep(this.$step, this.$page);
                    }
                }, (Function0)new Function0<Unit>(this.this$0, step, this.$page){
                    final /* synthetic */ Navigator this$0;
                    final /* synthetic */ DatabaseConnectionStep $step;
                    final /* synthetic */ DatabaseConnectionDialogPage $page;
                    {
                        this.this$0 = $receiver;
                        this.$step = $step;
                        this.$page = $page;
                        super(0);
                    }

                    public final void invoke() {
                        Navigator.access$getRailTracks$p(this.this$0).removeStep(this.$step, this.$page);
                    }
                });
            }
        }));
    }

    public final void moveNext() {
        this.moveTo(this.railTracks.moveNext(), JBCardLayout.SwipeDirection.FORWARD);
    }

    public final void movePrevious() {
        this.moveTo(this.railTracks.movePrevious(), JBCardLayout.SwipeDirection.BACKWARD);
    }

    public final void moveToBeginning() {
        this.moveTo(this.railTracks.moveToBeginning(), JBCardLayout.SwipeDirection.BACKWARD);
    }

    public final void moveTo(@NotNull DatabaseConnectionStep databaseConnectionStep) {
        Intrinsics.checkNotNullParameter((Object)databaseConnectionStep, (String)"databaseConnectionStep");
        this.railTracks.selectTrack(databaseConnectionStep.getConnectionType());
        this.moveTo(this.railTracks.goToStep(databaseConnectionStep), JBCardLayout.SwipeDirection.AUTO);
    }

    public final boolean isCurrentStepFirst() {
        return this.currentStepPosition == 0;
    }

    private final void moveTo(Pair<? extends DatabaseConnectionStep, ? extends DatabaseConnectionDialogPage> stepAndPage, JBCardLayout.SwipeDirection direction) {
        DatabaseConnectionStep step = (DatabaseConnectionStep)stepAndPage.getFirst();
        DatabaseConnectionDialogPage page = (DatabaseConnectionDialogPage)stepAndPage.getSecond();
        Lifetime stepShownLifetime = Lifetime.Companion.intersect(step.getStepLifetime(), (Lifetime)this.stepShownLifetimes.next());
        this.currentStep = this.railTracks.currentStep();
        this.currentStepPosition = this.railTracks.currentStepPosition();
        this._currentTrack.set((Object)this.railTracks.getCurrentTrack());
        step.beforeShown(stepShownLifetime);
        this.layout.swipe((Container)this.panel, page.getId(), direction, () -> Navigator.moveTo$lambda$0(stepShownLifetime, step));
    }

    private static final void moveTo$lambda$0(Lifetime $stepShownLifetime, DatabaseConnectionStep $step) {
        Intrinsics.checkNotNullParameter((Object)$stepShownLifetime, (String)"$stepShownLifetime");
        Intrinsics.checkNotNullParameter((Object)$step, (String)"$step");
        if (RLifetimeKt.isAlive((Lifetime)$stepShownLifetime)) {
            $step.shown();
        }
    }

    public static final /* synthetic */ RailTracks access$getRailTracks$p(Navigator $this) {
        return $this.railTracks;
    }
}

