/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.ChangeCredentialsFix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.ChangeParametersFix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.ChangeUrlFix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.ConfigureManuallyFix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.DatagripFixAdapter;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.DatagripFixExecutor;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.NavigationFix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.fixes.UseUrlFix;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Navigator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.session.SelectedDriverSession;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.ui.AuthHandler;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.url.ui.UrlsComboBox;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/FixesFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;", "navigator", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "fixExecutor", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/DatagripFixExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/session/SelectedDriverSession;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/DatagripFixExecutor;)V", "changeCredentialsFix", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/NavigationFix;", "step", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "authHandler", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/ui/AuthHandler;", "changeParametersFix", "changeUrlFix", "urlsComboBox", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/url/ui/UrlsComboBox;", "configureManuallyFix", "createDatagripFix", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/fixes/DatagripFixAdapter;", "fix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "useUrlFix", "intellij.rider.plugins.appender"})
public final class FixesFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final SelectedDriverSession session;
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final DatagripFixExecutor fixExecutor;

    public FixesFactory(@NotNull Project project, @NotNull SelectedDriverSession session, @NotNull Navigator navigator, @NotNull DatagripFixExecutor fixExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)fixExecutor, (String)"fixExecutor");
        this.project = project;
        this.session = session;
        this.navigator = navigator;
        this.fixExecutor = fixExecutor;
    }

    @NotNull
    public final NavigationFix changeCredentialsFix(@NotNull DatabaseConnectionStep step, @NotNull AuthHandler authHandler) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)authHandler, (String)"authHandler");
        return new ChangeCredentialsFix(this.project, this.session, this.navigator, step, authHandler);
    }

    @NotNull
    public final NavigationFix useUrlFix(@NotNull DatabaseConnectionStep step, @NotNull UrlsComboBox urlsComboBox) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)((Object)urlsComboBox), (String)"urlsComboBox");
        return new UseUrlFix(this.project, this.session, this.navigator, step, urlsComboBox);
    }

    @NotNull
    public final NavigationFix changeUrlFix(@NotNull DatabaseConnectionStep step, @NotNull UrlsComboBox urlsComboBox) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        Intrinsics.checkNotNullParameter((Object)((Object)urlsComboBox), (String)"urlsComboBox");
        return new ChangeUrlFix(this.project, this.session, this.navigator, step, urlsComboBox);
    }

    @NotNull
    public final NavigationFix configureManuallyFix(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        return new ConfigureManuallyFix(this.project, this.session, this.navigator, step);
    }

    @NotNull
    public final NavigationFix changeParametersFix(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        return new ChangeParametersFix(this.project, this.session, this.navigator, step);
    }

    @NotNull
    public final DatagripFixAdapter createDatagripFix(@NotNull ErrorInfo.Fix fix) {
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
        return new DatagripFixAdapter(this.project, fix, this.session, this.fixExecutor);
    }
}

