/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.Driver;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.drivers.DriverFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ*\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0004H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverProvider;", "", "()V", "getDrivers", "", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/Driver;", "project", "Lcom/intellij/openapi/project/Project;", "filter", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverFilter;", "getOneDriverPerDbms", "", "", "Lcom/intellij/database/dataSource/DatabaseDriver;", "drivers", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDriverProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriverProvider.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,40:1\n766#2:41\n857#2,2:42\n1855#2,2:48\n125#3:44\n152#3,3:45\n*S KotlinDebug\n*F\n+ 1 DriverProvider.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/drivers/DriverProvider\n*L\n10#1:41\n10#1:42,2\n31#1:48,2\n23#1:44\n23#1:45,3\n*E\n"})
public final class DriverProvider {
    @NotNull
    public static final DriverProvider INSTANCE = new DriverProvider();

    private DriverProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<Driver> getDrivers(@NotNull Project project, @NotNull DriverFilter filter) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Collection collection = DatabaseDriverManager.getInstance().getDrivers();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDrivers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DatabaseDriver it = (DatabaseDriver)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!filter.isIncluded(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredDrivers = (List)destination$iv$iv;
        Map<String, DatabaseDriver> driverKeyToDriver = this.getOneDriverPerDbms(project, filteredDrivers);
        Function function = LocalDataSourceManager.getDisplayDriverNamer(driverKeyToDriver.values());
        Intrinsics.checkNotNullExpressionValue((Object)function, (String)"getDisplayDriverNamer(...)");
        Function driverNames = function;
        Map<String, DatabaseDriver> $this$map$iv = driverKeyToDriver;
        boolean $i$f$map = false;
        Map<String, DatabaseDriver> $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add(DriverProvider.getDrivers$createDriver(driverNames, (String)it.getKey(), (DatabaseDriver)it.getValue(), ((DatabaseDriver)it.getValue()).isPredefined()));
        }
        return (List)destination$iv$iv2;
    }

    private final Map<String, DatabaseDriver> getOneDriverPerDbms(Project project, Collection<? extends DatabaseDriver> drivers) {
        Map keyToDriver = new LinkedHashMap();
        LocalDataSourceManager localDataSourceManager = LocalDataSourceManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSourceManager, (String)"getInstance(...)");
        LocalDataSourceManager localDataSourceManager2 = localDataSourceManager;
        Iterable $this$forEach$iv = drivers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseDriver it = (DatabaseDriver)element$iv;
            boolean bl = false;
            String driverKey = localDataSourceManager2.getDriverKey(it);
            keyToDriver.putIfAbsent(driverKey, it);
        }
        return keyToDriver;
    }

    private static final Driver getDrivers$createDriver(Function<DatabaseDriver, String> driverNames, String id, DatabaseDriver databaseDriver, boolean isSupported2) {
        String string = driverNames.apply(databaseDriver);
        if (string == null) {
            string = databaseDriver.getName();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return new Driver(id, string2, databaseDriver, isSupported2);
    }
}

