/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages;

import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ViewableSet;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.DatabaseConnectionDialogPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.pages.InitialPage;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.services.navigation.Navigator;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.DatabaseConnectionStep;
import com.jetbrains.rider.plugins.appender.database.dialog.steps.shared.steps.StepExtensionsKt;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J&\u0010\u001e\u001a\u00020\u0018*\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/InitialPage;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/pages/DatabaseConnectionDialogPage;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "navigator", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/services/navigation/Navigator;)V", "_steps", "Lcom/jetbrains/rd/util/reactive/ViewableSet;", "Lcom/jetbrains/rider/plugins/appender/database/dialog/steps/shared/steps/DatabaseConnectionStep;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "id", "", "getId", "()Ljava/lang/String;", "steps", "getSteps", "()Lcom/jetbrains/rd/util/reactive/ViewableSet;", "urlStepPanel", "Ljavax/swing/JPanel;", "addManualStep", "", "step", "addUrlStep", "createConstants", "Lcom/intellij/uiDesigner/core/GridConstraints;", "repaintAndRevalidate", "radioButton", "Lcom/intellij/ui/dsl/builder/Row;", "text", "connectionType", "Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectionType;", "intellij.rider.plugins.appender"})
public final class InitialPage
implements DatabaseConnectionDialogPage {
    @NotNull
    private final Navigator navigator;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JPanel urlStepPanel;
    @NotNull
    private final ViewableSet<DatabaseConnectionStep> _steps;
    @NotNull
    private final String id;
    @NotNull
    private final ViewableSet<DatabaseConnectionStep> steps;

    public InitialPage(final @NotNull Lifetime lifetime, @NotNull Navigator navigator) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        this.navigator = navigator;
        this.urlStepPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 1));
        this._steps = new ViewableSet(null, 1, null);
        this.id = "Initial";
        this.steps = this._steps;
        this.component = (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)false, (Function1)((Function1)new Function1<Panel, Unit>(){

                    public final void invoke(@NotNull Panel $this$buttonsGroup) {
                        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(){

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                this.radioButton($this$row, lifetime, RiderDatabaseBundle.message("radio.add.data.source.manually", new Object[0]), ConnectionType.Manual);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(){

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                this.radioButton($this$row, lifetime, RiderDatabaseBundle.message("radio.use.connection.string", new Object[0]), ConnectionType.Url);
                            }
                        }), (int)1, null);
                        Panel.row$default((Panel)$this$buttonsGroup, null, (Function1)((Function1)new Function1<Row, Unit>(){

                            public final void invoke(@NotNull Row $this$row) {
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                $this$row.cell((JComponent)urlStepPanel).resizableColumn().align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.FILL.INSTANCE);
                            }
                        }), (int)1, null).resizableRow();
                    }
                }), (int)3, null);
            }
        }));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ViewableSet<DatabaseConnectionStep> getSteps() {
        return this.steps;
    }

    public final void addUrlStep(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this.urlStepPanel.add((Component)step.getComponent(), this.createConstants());
        this._steps.add((Object)step);
        this.repaintAndRevalidate();
        this.navigator.getCurrentTrack().advise(step.getStepLifetime(), (Function1)new Function1<ConnectionType, Unit>(step){
            final /* synthetic */ DatabaseConnectionStep $step;
            {
                this.$step = $step;
                super(1);
            }

            public final void invoke(@NotNull ConnectionType it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                switch (addUrlStep.WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1: {
                        StepExtensionsKt.enable(this.$step);
                        break;
                    }
                    case 2: {
                        StepExtensionsKt.disable(this.$step);
                    }
                }
            }
        });
        step.getStepLifetime().onTermination((Function0)new Function0<Unit>(this, step){
            final /* synthetic */ InitialPage this$0;
            final /* synthetic */ DatabaseConnectionStep $step;
            {
                this.this$0 = $receiver;
                this.$step = $step;
                super(0);
            }

            public final void invoke() {
                InitialPage.access$getUrlStepPanel$p(this.this$0).remove(this.$step.getComponent());
                InitialPage.access$get_steps$p(this.this$0).remove((Object)this.$step);
            }
        });
    }

    public final void addManualStep(@NotNull DatabaseConnectionStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        step.getStepLifetime().bracketIfAlive((Function0)new Function0<Boolean>(this, step){
            final /* synthetic */ InitialPage this$0;
            final /* synthetic */ DatabaseConnectionStep $step;
            {
                this.this$0 = $receiver;
                this.$step = $step;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return InitialPage.access$get_steps$p(this.this$0).add((Object)this.$step);
            }
        }, (Function0)new Function0<Unit>(this, step){
            final /* synthetic */ InitialPage this$0;
            final /* synthetic */ DatabaseConnectionStep $step;
            {
                this.this$0 = $receiver;
                this.$step = $step;
                super(0);
            }

            public final void invoke() {
                InitialPage.access$get_steps$p(this.this$0).remove((Object)this.$step);
            }
        });
    }

    private final void radioButton(Row $this$radioButton, Lifetime lifetime, @NlsContexts.RadioButton String text, ConnectionType connectionType) {
        Row.radioButton$default((Row)$this$radioButton, (String)text, null, (int)2, null).applyToComponent((Function1)new Function1<JBRadioButton, Unit>(this, lifetime, connectionType){
            final /* synthetic */ InitialPage this$0;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ ConnectionType $connectionType;
            {
                this.this$0 = $receiver;
                this.$lifetime = $lifetime;
                this.$connectionType = $connectionType;
                super(1);
            }

            public final void invoke(@NotNull JBRadioButton $this$applyToComponent) {
                Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
                $this$applyToComponent.addActionListener(arg_0 -> radioButton.1.invoke$lambda$0(this.this$0, this.$connectionType, arg_0));
                InitialPage.access$getNavigator$p(this.this$0).getCurrentTrack().advise(this.$lifetime, (Function1)new Function1<ConnectionType, Unit>($this$applyToComponent, this.$connectionType){
                    final /* synthetic */ JBRadioButton $this_applyToComponent;
                    final /* synthetic */ ConnectionType $connectionType;
                    {
                        this.$this_applyToComponent = $this_applyToComponent;
                        this.$connectionType = $connectionType;
                        super(1);
                    }

                    public final void invoke(@NotNull ConnectionType it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        this.$this_applyToComponent.setSelected(it == this.$connectionType);
                    }
                });
            }

            private static final void invoke$lambda$0(InitialPage this$0, ConnectionType $connectionType, ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)$connectionType), (String)"$connectionType");
                InitialPage.access$getNavigator$p(this$0).changeTrack($connectionType);
            }
        });
    }

    private final GridConstraints createConstants() {
        GridConstraints gridConstraints = DatabaseUIUtils.createConstraints((int)0, (int)0, (int)1, (int)9, (int)3, (int)-1, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)gridConstraints, (String)"createConstraints(...)");
        return gridConstraints;
    }

    private final void repaintAndRevalidate() {
        this.urlStepPanel.revalidate();
        this.urlStepPanel.repaint();
    }

    public static final /* synthetic */ ViewableSet access$get_steps$p(InitialPage $this) {
        return $this._steps;
    }

    public static final /* synthetic */ Navigator access$getNavigator$p(InitialPage $this) {
        return $this.navigator;
    }
}

