/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.dialog;

import com.intellij.database.Dbms;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.ConnectionStringsProvider;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.PotentialConnectionString;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.DatabaseConnectionDialog;
import com.jetbrains.rider.plugins.appender.database.dialog.fus.RiderDatabaseConnectionDialogStatisticsCollector;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.DotnetDataProvider;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/dialog/ConnectToDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildDialog", "Lcom/jetbrains/rider/plugins/appender/database/dialog/DatabaseConnectionDialog;", "project", "Lcom/intellij/openapi/project/Project;", "connectionStrings", "", "Lcom/jetbrains/rider/plugins/appender/database/connectionStrings/PotentialConnectionString;", "getDbmsByConnectionStrings", "Lcom/intellij/database/Dbms;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nConnectToDatabaseAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectToDatabaseAction.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/ConnectToDatabaseAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1360#2:48\n1446#2,5:49\n1536#2:54\n1#3:55\n*S KotlinDebug\n*F\n+ 1 ConnectToDatabaseAction.kt\ncom/jetbrains/rider/plugins/appender/database/dialog/ConnectToDatabaseAction\n*L\n41#1:48\n41#1:49,5\n42#1:54\n*E\n"})
public final class ConnectToDatabaseAction
extends DumbAwareAction {
    public ConnectToDatabaseAction() {
        super(RiderDatabaseBundle.message("action.ConnectToDatabaseAction.text", new Object[0]), null, DatabaseIcons.Dbms);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        RiderDatabaseConnectionDialogStatisticsCollector.INSTANCE.logDialogOpened(project2, string);
        Collection<PotentialConnectionString> connectionStrings = ConnectionStringsProvider.Companion.getInstance(project2).getConnectionStrings();
        this.buildDialog(project2, connectionStrings).show();
    }

    private final DatabaseConnectionDialog buildDialog(Project project, Collection<PotentialConnectionString> connectionStrings) {
        DatabaseConnectionDialog.Builder $this$buildDialog_u24lambda_u240 = new DatabaseConnectionDialog.Builder(project);
        boolean bl = false;
        if (connectionStrings.isEmpty()) {
            $this$buildDialog_u24lambda_u240.useConnectionType(ConnectionType.Manual);
            Dbms dbms = Dbms.MSSQL;
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"MSSQL");
            $this$buildDialog_u24lambda_u240.selectDefaultDriverFor(dbms);
        } else {
            $this$buildDialog_u24lambda_u240.useConnectionType(ConnectionType.Url);
            Dbms dbms = this.getDbmsByConnectionStrings(connectionStrings);
            if (dbms == null) {
                dbms = Dbms.MSSQL;
            }
            Dbms dbms2 = dbms;
            Intrinsics.checkNotNull((Object)dbms2);
            $this$buildDialog_u24lambda_u240.selectDefaultDriverFor(dbms2);
            $this$buildDialog_u24lambda_u240.useConnectionStrings(connectionStrings);
        }
        return $this$buildDialog_u24lambda_u240.build();
    }

    /*
     * WARNING - void declaration
     */
    private final Dbms getDbmsByConnectionStrings(Collection<PotentialConnectionString> connectionStrings) {
        Object v1;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = connectionStrings;
        boolean $i$f$flatMap = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PotentialConnectionString it = (PotentialConnectionString)element$iv$iv;
            boolean bl = false;
            Object object = it.getProvider();
            if (object == null || (object = ((DotnetDataProvider)object).getDbms()) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupingBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupingBy = false;
        Iterable iterable = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<Dbms, Dbms>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<Dbms> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                Dbms it = (Dbms)element;
                boolean bl = false;
                return var2_2;
            }
        })).entrySet();
        iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v1 = null;
        } else {
            Object e = iterator.next();
            if (!iterator.hasNext()) {
                v1 = e;
            } else {
                Map.Entry it = (Map.Entry)e;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object e2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)e2;
                    $i$a$-maxByOrNull-ConnectToDatabaseAction$getDbmsByConnectionStrings$3 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    e = e2;
                    n = n2;
                } while (iterator.hasNext());
                v1 = e;
            }
        }
        Map.Entry entry = v1;
        return entry != null ? (Dbms)entry.getKey() : null;
    }
}

