/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.base.llm;

import com.intellij.lang.Language;
import com.intellij.ml.llm.core.chat.snippets.CodeSnippetProvider;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.lang.ProtocolLanguageManager;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.editors.RiderTextControlHost;
import com.jetbrains.rider.editors.sandboxes.SandboxManager;
import com.jetbrains.rider.model.ExtraInfo;
import com.jetbrains.rider.model.SandboxInfo;
import com.jetbrains.rider.plugins.appender.base.llm.ReSharperCodeSnippetProviderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/appender/base/llm/ReSharperCodeSnippetProvider;", "Lcom/intellij/ml/llm/core/chat/snippets/CodeSnippetProvider;", "()V", "isApplicableLanguage", "", "language", "Lcom/intellij/lang/Language;", "tryCreateEditor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "tryFinalizeEditor", "", "editor", "Companion", "intellij.rider.appender.base"})
public final class ReSharperCodeSnippetProvider
implements CodeSnippetProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String START_MARKER = "<RESHARPER_CODE_TO_SHOW_START>";
    @NotNull
    public static final String END_MARKER = "<RESHARPER_CODE_TO_SHOW_END>";

    private final boolean isApplicableLanguage(Language language) {
        if (language == null) {
            return false;
        }
        ProtocolLanguageManager protocolLanguageManager = ProtocolLanguageManager.Companion.getInstance();
        return protocolLanguageManager != null ? protocolLanguageManager.isProtocolLanguage(language) : false;
    }

    @Nullable
    public Editor tryCreateEditor(@NotNull Project project, @NotNull Document document, @NotNull Language language) {
        Object[] codeRange;
        String[] range;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        if (!this.isApplicableLanguage(language)) {
            return null;
        }
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        int codeToShowStart = StringsKt.indexOf$default((CharSequence)text, (String)START_MARKER, (int)0, (boolean)false, (int)6, null);
        int codeToShowEnd = StringsKt.indexOf$default((CharSequence)text, (String)END_MARKER, (int)0, (boolean)false, (int)6, null);
        if (codeToShowStart != -1 && codeToShowEnd != -1) {
            String fullCode;
            String string2 = fullCode = text;
            int n = codeToShowEnd + 28;
            string2 = fullCode = ((Object)StringsKt.removeRange((CharSequence)string2, (int)codeToShowEnd, (int)n)).toString();
            n = codeToShowStart + 30;
            fullCode = ((Object)StringsKt.removeRange((CharSequence)string2, (int)codeToShowStart, (int)n)).toString();
            range = new RdTextRange(codeToShowStart, codeToShowEnd - 30);
            String string3 = fullCode.substring(range.getStartOffset(), range.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            codeRange = string3;
            ApplicationKt.getApplication().runWriteAction(() -> ReSharperCodeSnippetProvider.tryCreateEditor$lambda$1(project, document, (String)codeRange));
            document.putUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_RANGE_KEY(), (Object)range);
            document.putUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_KEY(), (Object)fullCode);
        }
        range = new String[]{"mscorlib", "System", "System.Core", "Microsoft.CSharp", "System.ValueTuple"};
        List modules = CollectionsKt.listOf((Object[])range);
        codeRange = new String[]{"System", "System.IO", "System.Collections.Generic", "System.Console", "System.Dynamic", "System.Linq", "System.Linq.Expressions", "System.Text", "System.Threading.Tasks"};
        List imports = CollectionsKt.listOf((Object[])codeRange);
        String string4 = (String)document.getUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_KEY());
        if (string4 == null) {
            string4 = document.getText();
        }
        String string5 = string4;
        Intrinsics.checkNotNull((Object)string5);
        String fullCode = string5;
        RdTextRange rdTextRange = (RdTextRange)document.getUserData(ReSharperCodeSnippetProviderKt.getRESHARPER_CODE_RANGE_KEY());
        if (rdTextRange == null) {
            rdTextRange = RangeUtilKt.fromOffset((RdTextRange.Companion)RdTextRange.Companion, (int)0);
        }
        RdTextRange rdTextRange2 = rdTextRange;
        Intrinsics.checkNotNull((Object)rdTextRange2);
        RdTextRange range2 = rdTextRange2;
        RdTextRange rdTextRange3 = new RdTextRange(range2.getStartOffset(), range2.getStartOffset());
        ExtraInfo extraInfo = new ExtraInfo(imports, CollectionsKt.emptyList());
        List list2 = CollectionsKt.emptyList();
        RdLanguage rdLanguage = ProtocolLanguageManagerKt.toRdLanguageOrThrow((Language)language);
        List list3 = CollectionsKt.emptyList();
        SandboxInfo sandboxSource = new SandboxInfo("ChatCodeSnippet", null, fullCode, rdTextRange3, true, extraInfo, modules, true, list2, rdLanguage, false, null, true, list3);
        SandboxManager.Companion.getInstance().markAsSandbox(document, (AbstractSandboxInfo)sandboxSource);
        Editor editor2 = EditorFactory.getInstance().createViewer(document, project);
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        return (Editor)((EditorEx)editor2);
    }

    public void tryFinalizeEditor(@NotNull Project project, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!this.isApplicableLanguage(DocumentUtilKt.getLanguage((Editor)editor2))) {
            return;
        }
        if (DocumentExKt.getTextControlId((Editor)editor2) != null) {
            return;
        }
        FrontendTextControlHost frontendTextControlHost = FrontendTextControlHost.Companion.getInstance(project);
        Intrinsics.checkNotNull((Object)frontendTextControlHost, (String)"null cannot be cast to non-null type com.jetbrains.rider.editors.RiderTextControlHost");
        RiderTextControlHost textControlHost = (RiderTextControlHost)frontendTextControlHost;
        textControlHost.bindEditor(editor2);
    }

    private static final void tryCreateEditor$lambda$1$lambda$0(Document $document, String $codeRange) {
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$codeRange, (String)"$codeRange");
        $document.setReadOnly(false);
        $document.setText((CharSequence)$codeRange);
        $document.setReadOnly(true);
    }

    private static final void tryCreateEditor$lambda$1(Project $project, Document $document, String $codeRange) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)$codeRange, (String)"$codeRange");
        WriteCommandAction.writeCommandAction((Project)$project).run(() -> ReSharperCodeSnippetProvider.tryCreateEditor$lambda$1$lambda$0($document, $codeRange));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/appender/base/llm/ReSharperCodeSnippetProvider$Companion;", "", "()V", "END_MARKER", "", "START_MARKER", "intellij.rider.appender.base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

