/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.coverage.CoverageExecutor;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunSettings;
import com.intellij.javascript.karma.scope.KarmaScopeKind;
import com.intellij.javascript.nodejs.execution.runConfiguration.NodeRunConfigurationExtensionsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testing.AngularCliConfig;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.StringKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010(\u001a\u00020\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u001b\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/intellij/javascript/karma/execution/KarmaServerSettings;", "", "executor", "Lcom/intellij/execution/Executor;", "nodeInterpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "karmaPackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "settings", "Lcom/intellij/javascript/karma/execution/KarmaRunSettings;", "runConfiguration", "Lcom/intellij/javascript/karma/execution/KarmaRunConfiguration;", "(Lcom/intellij/execution/Executor;Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;Lcom/intellij/javascript/nodejs/util/NodePackage;Lcom/intellij/javascript/karma/execution/KarmaRunSettings;Lcom/intellij/javascript/karma/execution/KarmaRunConfiguration;)V", "angularProjectName", "", "getAngularProjectName", "()Ljava/lang/String;", "configurationFilePath", "getConfigurationFilePath", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "isDebug", "", "()Z", "isWithCoverage", "karmaOptions", "getKarmaOptions", "getKarmaPackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "myRunConfigurationExtensionsXml", "getNodeInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "nodeOptions", "getNodeOptions", "getRunConfiguration", "()Lcom/intellij/javascript/karma/execution/KarmaRunConfiguration;", "workingDirectorySystemDependent", "getWorkingDirectorySystemDependent", "equals", "other", "hashCode", "", "Companion", "intellij.karma"})
public final class KarmaServerSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor executor;
    @NotNull
    private final NodeJsInterpreter nodeInterpreter;
    @NotNull
    private final NodePackage karmaPackage;
    @NotNull
    private final KarmaRunConfiguration runConfiguration;
    @NotNull
    private final String nodeOptions;
    @NotNull
    private final String configurationFilePath;
    @NotNull
    private final String karmaOptions;
    @NotNull
    private final String workingDirectorySystemDependent;
    @NotNull
    private final EnvironmentVariablesData envData;
    @NotNull
    private final String myRunConfigurationExtensionsXml;
    @Nullable
    private final String angularProjectName;

    public KarmaServerSettings(@NotNull Executor executor, @NotNull NodeJsInterpreter nodeInterpreter, @NotNull NodePackage karmaPackage, @NotNull KarmaRunSettings settings, @NotNull KarmaRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)nodeInterpreter, (String)"nodeInterpreter");
        Intrinsics.checkNotNullParameter((Object)karmaPackage, (String)"karmaPackage");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        this.executor = executor;
        this.nodeInterpreter = nodeInterpreter;
        this.karmaPackage = karmaPackage;
        this.runConfiguration = runConfiguration;
        String string = settings.getNodeOptions();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeOptions(...)");
        this.nodeOptions = string;
        String string2 = settings.getConfigPathSystemDependent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getConfigPathSystemDependent(...)");
        this.configurationFilePath = string2;
        String string3 = settings.getKarmaOptions();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getKarmaOptions(...)");
        this.karmaOptions = string3;
        String string4 = settings.getWorkingDirectorySystemDependent();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getWorkingDirectorySystemDependent(...)");
        this.workingDirectorySystemDependent = string4;
        EnvironmentVariablesData environmentVariablesData = settings.getEnvData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getEnvData(...)");
        this.envData = environmentVariablesData;
        this.myRunConfigurationExtensionsXml = KarmaServerSettings.Companion.runConfigurationExtensionsToXml(this.runConfiguration);
        this.angularProjectName = KarmaServerSettings.Companion.detectAngularProjectName(settings);
    }

    @NotNull
    public final NodeJsInterpreter getNodeInterpreter() {
        return this.nodeInterpreter;
    }

    @NotNull
    public final NodePackage getKarmaPackage() {
        return this.karmaPackage;
    }

    @NotNull
    public final KarmaRunConfiguration getRunConfiguration() {
        return this.runConfiguration;
    }

    @NotNull
    public final String getNodeOptions() {
        return this.nodeOptions;
    }

    @NotNull
    public final String getConfigurationFilePath() {
        return this.configurationFilePath;
    }

    @NotNull
    public final String getKarmaOptions() {
        return this.karmaOptions;
    }

    @NotNull
    public final String getWorkingDirectorySystemDependent() {
        return this.workingDirectorySystemDependent;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.envData;
    }

    @Nullable
    public final String getAngularProjectName() {
        return this.angularProjectName;
    }

    public final boolean isWithCoverage() {
        return this.executor instanceof CoverageExecutor;
    }

    public final boolean isDebug() {
        return this.executor instanceof DefaultDebugExecutor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        KarmaServerSettings that = (KarmaServerSettings)other;
        return Intrinsics.areEqual((Object)this.executor.getId(), (Object)that.executor.getId()) && Intrinsics.areEqual((Object)this.nodeInterpreter, (Object)that.nodeInterpreter) && Intrinsics.areEqual((Object)this.nodeOptions, (Object)that.nodeOptions) && Intrinsics.areEqual((Object)this.karmaPackage, (Object)that.karmaPackage) && Intrinsics.areEqual((Object)this.configurationFilePath, (Object)that.configurationFilePath) && Intrinsics.areEqual((Object)this.karmaOptions, (Object)that.karmaOptions) && Intrinsics.areEqual((Object)this.workingDirectorySystemDependent, (Object)that.workingDirectorySystemDependent) && Intrinsics.areEqual((Object)this.envData, (Object)that.envData) && Intrinsics.areEqual((Object)this.myRunConfigurationExtensionsXml, (Object)that.myRunConfigurationExtensionsXml) && Intrinsics.areEqual((Object)this.angularProjectName, (Object)that.angularProjectName);
    }

    public int hashCode() {
        int result = this.executor.getId().hashCode();
        result = 31 * result + this.nodeInterpreter.hashCode();
        result = 31 * result + this.nodeOptions.hashCode();
        result = 31 * result + this.karmaPackage.hashCode();
        result = 31 * result + this.configurationFilePath.hashCode();
        result = 31 * result + this.karmaOptions.hashCode();
        result = 31 * result + this.workingDirectorySystemDependent.hashCode();
        result = 31 * result + this.envData.hashCode();
        result = 31 * result + this.myRunConfigurationExtensionsXml.hashCode();
        String string = this.angularProjectName;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u001e\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\b*\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/karma/execution/KarmaServerSettings$Companion;", "", "()V", "detectAngularProjectName", "", "settings", "Lcom/intellij/javascript/karma/execution/KarmaRunSettings;", "getContextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "s", "getDeepestDirectory", "dir1", "dir2", "runConfigurationExtensionsToXml", "runConfiguration", "Lcom/intellij/javascript/karma/execution/KarmaRunConfiguration;", "toVirtualFile", "intellij.karma"})
    public static final class Companion {
        private Companion() {
        }

        private final String runConfigurationExtensionsToXml(KarmaRunConfiguration runConfiguration) {
            Element element = new Element("extensionsRoot");
            NodeRunConfigurationExtensionsManager.Companion.getInstance().writeExternal((RunConfigurationBase)runConfiguration, element);
            String string = JDOMUtil.write((Element)element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"write(...)");
            return string;
        }

        private final String detectAngularProjectName(KarmaRunSettings settings) {
            if (ParametersListUtil.parse((String)settings.getKarmaOptions()).contains("--project")) {
                return null;
            }
            String string = StringKt.nullize((String)settings.getWorkingDirectorySystemDependent(), (boolean)true);
            if (string == null) {
                return null;
            }
            String workingDir = string;
            AngularCliConfig angularCliConfig = AngularCliConfig.findProjectConfig((File)new File(workingDir));
            if (angularCliConfig == null) {
                return null;
            }
            AngularCliConfig config = angularCliConfig;
            VirtualFile contextFile = this.getContextFile(settings);
            return config.getProjectContainingFileOrDefault(contextFile);
        }

        private final VirtualFile getContextFile(KarmaRunSettings s) {
            VirtualFile primaryFile;
            switch (WhenMappings.$EnumSwitchMapping$0[s.getScopeKind().ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    VirtualFile virtualFile = this.toVirtualFile(s.getTestFileSystemDependentPath());
                    break;
                }
                default: {
                    VirtualFile virtualFile = primaryFile = null;
                }
            }
            if (primaryFile != null) {
                return primaryFile;
            }
            VirtualFile configFileParentDir = this.toVirtualFile(PathUtil.getParentPath((String)s.getConfigPathSystemDependent()));
            VirtualFile workingDir = this.toVirtualFile(s.getWorkingDirectorySystemDependent());
            return this.getDeepestDirectory(configFileParentDir, workingDir);
        }

        private final VirtualFile getDeepestDirectory(VirtualFile dir1, VirtualFile dir2) {
            VirtualFile virtualFile;
            if (dir1 != null && dir2 != null) {
                if (VfsUtil.isAncestor((VirtualFile)dir1, (VirtualFile)dir2, (boolean)true)) {
                    return dir2;
                }
                if (VfsUtil.isAncestor((VirtualFile)dir2, (VirtualFile)dir1, (boolean)true)) {
                    return dir1;
                }
            }
            if ((virtualFile = dir1) == null) {
                virtualFile = dir2;
            }
            return virtualFile;
        }

        private final VirtualFile toVirtualFile(String $this$toVirtualFile) {
            VirtualFile virtualFile;
            String string = StringKt.nullize((String)$this$toVirtualFile, (boolean)true);
            if (string != null) {
                String it = string;
                boolean bl = false;
                virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[KarmaScopeKind.values().length];
                try {
                    nArray[KarmaScopeKind.TEST_FILE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KarmaScopeKind.SUITE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[KarmaScopeKind.TEST.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

