/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.debug;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebugTabLayouter;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.javascript.karma.KarmaConfig;
import com.intellij.javascript.karma.debug.DebuggableWebBrowser;
import com.intellij.javascript.karma.debug.KarmaDebugProgramRunner;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunProgramRunner;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.debugger.wip.BrowserChromeDebugProcess;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0007H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/karma/debug/KarmaDebugProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "ChromeRequiredException", "Handler", "intellij.karma"})
public final class KarmaDebugProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "KarmaJavaScriptTestRunnerDebug";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)"Debug", (Object)executorId) && profile instanceof KarmaRunConfiguration;
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Promise promise = KarmaRunProgramRunner.Companion.executeAsync(environment, state).thenAsync(arg_0 -> KarmaDebugProgramRunner.execute$lambda$0((Function1)new Function1<ExecutionResult, Promise<RunContentDescriptor>>(state, environment){
            final /* synthetic */ RunProfileState $state;
            final /* synthetic */ ExecutionEnvironment $environment;
            {
                this.$state = $state;
                this.$environment = $environment;
                super(1);
            }

            public final Promise<RunContentDescriptor> invoke(ExecutionResult executionResult) {
                KarmaConsoleView karmaConsoleView = KarmaConsoleView.get(executionResult, this.$state);
                if (karmaConsoleView == null) {
                    return Promises.resolvedPromise((Object)KarmaUtil.createDefaultDescriptor(executionResult, this.$environment));
                }
                KarmaConsoleView consoleView = karmaConsoleView;
                if (executionResult.getProcessHandler() instanceof NopProcessHandler) {
                    RunContentDescriptor runContentDescriptor;
                    RunContentDescriptor it = runContentDescriptor = KarmaUtil.createDefaultDescriptor(executionResult, this.$environment);
                    boolean bl = false;
                    consoleView.getKarmaServer().onPortBound(() -> execute.1.invoke$lambda$1$lambda$0(it));
                    return Promises.resolvedPromise((Object)runContentDescriptor);
                }
                Project project = this.$environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                DebuggableWebBrowser debuggableWebBrowser = Handler.INSTANCE.getChromeInfo(project);
                JavaScriptDebugEngine javaScriptDebugEngine = debuggableWebBrowser.getDebugEngine();
                Project project2 = this.$environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                WebBrowser webBrowser = debuggableWebBrowser.getWebBrowser();
                Intrinsics.checkNotNullExpressionValue((Object)webBrowser, (String)"getWebBrowser(...)");
                return javaScriptDebugEngine.prepareDebugger(project2, webBrowser).then(arg_0 -> execute.1.invoke$lambda$2((Function1)new Function1<Unit, RunContentDescriptor>(this.$environment, executionResult, consoleView, debuggableWebBrowser){
                    final /* synthetic */ ExecutionEnvironment $environment;
                    final /* synthetic */ ExecutionResult $executionResult;
                    final /* synthetic */ KarmaConsoleView $consoleView;
                    final /* synthetic */ DebuggableWebBrowser $debuggableWebBrowser;
                    {
                        this.$environment = $environment;
                        this.$executionResult = $executionResult;
                        this.$consoleView = $consoleView;
                        this.$debuggableWebBrowser = $debuggableWebBrowser;
                        super(1);
                    }

                    @Nullable
                    public final RunContentDescriptor invoke(Unit it) {
                        ExecutionResult executionResult = this.$executionResult;
                        Intrinsics.checkNotNullExpressionValue((Object)executionResult, (String)"$executionResult");
                        return Handler.INSTANCE.createDescriptor(this.$environment, executionResult, this.$consoleView, this.$debuggableWebBrowser);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$1$lambda$0(RunContentDescriptor $it) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                ExecutionUtil.restartIfActive((RunContentDescriptor)$it);
            }

            private static final RunContentDescriptor invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (RunContentDescriptor)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"thenAsync(...)");
        return promise;
    }

    private static final Promise execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Promise)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0001\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/karma/debug/KarmaDebugProgramRunner$ChromeRequiredException;", "Lcom/intellij/execution/ExecutionException;", "Ljavax/swing/event/HyperlinkListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "hyperlinkUpdate", "", "e", "Ljavax/swing/event/HyperlinkEvent;", "Companion", "intellij.karma"})
    private static final class ChromeRequiredException
    extends ExecutionException
    implements HyperlinkListener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Project project;

        public ChromeRequiredException(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(Companion.message());
            this.project = project;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                ShowSettingsUtil.getInstance().showSettingsDialog(this.project, BrowserSettings.class);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/javascript/karma/debug/KarmaDebugProgramRunner$ChromeRequiredException$Companion;", "", "()V", "message", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "intellij.karma"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String message() {
                Object[] objectArray = new Object[]{HtmlChunk.link((String)"", (String)new BrowserSettings().getDisplayName()).toString()};
                String string = KarmaBundle.message("debug.debugging_available_in_chrome_only.dialog.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/karma/debug/KarmaDebugProgramRunner$Handler;", "", "()V", "createDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "karmaServer", "Lcom/intellij/javascript/karma/server/KarmaServer;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "debuggableWebBrowser", "Lcom/intellij/javascript/karma/debug/DebuggableWebBrowser;", "url", "Lcom/intellij/util/Url;", "createDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "consoleView", "Lcom/intellij/javascript/karma/execution/KarmaConsoleView;", "getChromeInfo", "project", "Lcom/intellij/openapi/project/Project;", "getDebuggableFileFinder", "openConnectionIfRemoteDebugging", "", "server", "connection", "resumeTestRunning", "processHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "intellij.karma"})
    @SourceDebugExtension(value={"SMAP\nKarmaDebugProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KarmaDebugProgramRunner.kt\ncom/intellij/javascript/karma/debug/KarmaDebugProgramRunner$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,216:1\n13#2:217\n13#2:218\n*S KotlinDebug\n*F\n+ 1 KarmaDebugProgramRunner.kt\ncom/intellij/javascript/karma/debug/KarmaDebugProgramRunner$Handler\n*L\n187#1:217\n211#1:218\n*E\n"})
    private static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        @NotNull
        public final DebuggableWebBrowser getChromeInfo(@NotNull Project project) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            WebBrowser webBrowser = WebBrowserManager.getInstance().getFirstBrowserOrNull(BrowserFamily.CHROME);
            if (webBrowser == null) {
                throw new ChromeRequiredException(project);
            }
            WebBrowser browser = webBrowser;
            DebuggableWebBrowser debuggableWebBrowser = DebuggableWebBrowser.create(browser);
            if (debuggableWebBrowser == null) {
                throw new ExecutionException(KarmaBundle.message("debug.cannot_find_chrome.dialog.message", new Object[0]));
            }
            return debuggableWebBrowser;
        }

        @NotNull
        public final RunContentDescriptor createDescriptor(@NotNull ExecutionEnvironment environment, @NotNull ExecutionResult executionResult, @NotNull KarmaConsoleView consoleView, @NotNull DebuggableWebBrowser debuggableWebBrowser) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
            Intrinsics.checkNotNullParameter((Object)debuggableWebBrowser, (String)"debuggableWebBrowser");
            KarmaServer karmaServer = consoleView.getKarmaServer();
            Intrinsics.checkNotNullExpressionValue((Object)karmaServer, (String)"getKarmaServer(...)");
            KarmaServer karmaServer2 = karmaServer;
            String string = karmaServer2.formatUrl("/");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatUrl(...)");
            Url url = Urls.newFromEncoded((String)string);
            DebuggableFileFinder fileFinder = this.getDebuggableFileFinder(karmaServer2);
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)environment.getProject()).startSession(environment, new XDebugProcessStarter(karmaServer2, fileFinder, executionResult, debuggableWebBrowser, url, consoleView){
                final /* synthetic */ KarmaServer $karmaServer;
                final /* synthetic */ DebuggableFileFinder $fileFinder;
                final /* synthetic */ ExecutionResult $executionResult;
                final /* synthetic */ DebuggableWebBrowser $debuggableWebBrowser;
                final /* synthetic */ Url $url;
                final /* synthetic */ KarmaConsoleView $consoleView;
                {
                    this.$karmaServer = $karmaServer;
                    this.$fileFinder = $fileFinder;
                    this.$executionResult = $executionResult;
                    this.$debuggableWebBrowser = $debuggableWebBrowser;
                    this.$url = $url;
                    this.$consoleView = $consoleView;
                }

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session2) {
                    Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                    JavaScriptDebugProcess debugProcess = Handler.access$createDebugProcess(Handler.INSTANCE, session2, this.$karmaServer, this.$fileFinder, this.$executionResult, this.$debuggableWebBrowser, this.$url);
                    debugProcess.setScriptsCanBeReloaded(true);
                    debugProcess.addFirstLineBreakpointPattern("\\.browserify$");
                    debugProcess.setElementsInspectorEnabled(false);
                    debugProcess.setConsoleMessagesSupportEnabled(false);
                    JSDebugTabLayouter jSDebugTabLayouter = this.$consoleView.createDebugLayouter(debugProcess);
                    Intrinsics.checkNotNullExpressionValue((Object)jSDebugTabLayouter, (String)"createDebugLayouter(...)");
                    debugProcess.setLayouter((XDebugTabLayouter)jSDebugTabLayouter);
                    this.$karmaServer.onBrowsersReady(() -> createDescriptor.session.1.start$lambda$1(this.$karmaServer, debugProcess, this.$executionResult));
                    return (XDebugProcess)debugProcess;
                }

                private static final void start$lambda$1$lambda$0(ExecutionResult $executionResult) {
                    Intrinsics.checkNotNullParameter((Object)$executionResult, (String)"$executionResult");
                    ProcessHandler processHandler = $executionResult.getProcessHandler();
                    Intrinsics.checkNotNull((Object)processHandler, (String)"null cannot be cast to non-null type com.intellij.execution.process.OSProcessHandler");
                    Handler.access$resumeTestRunning(Handler.INSTANCE, (OSProcessHandler)processHandler);
                }

                private static final void start$lambda$1(KarmaServer $karmaServer, JavaScriptDebugProcess $debugProcess, ExecutionResult $executionResult) {
                    Intrinsics.checkNotNullParameter((Object)$karmaServer, (String)"$karmaServer");
                    Intrinsics.checkNotNullParameter((Object)$debugProcess, (String)"$debugProcess");
                    Intrinsics.checkNotNullParameter((Object)$executionResult, (String)"$executionResult");
                    Handler.access$openConnectionIfRemoteDebugging(Handler.INSTANCE, $karmaServer, $debugProcess.getConnection());
                    Runnable runnable = ConcurrencyUtil.once(() -> createDescriptor.session.1.start$lambda$1$lambda$0($executionResult));
                    Intrinsics.checkNotNullExpressionValue((Object)runnable, (String)"once(...)");
                    Runnable resumeTestRunning = runnable;
                    SingleAlarm alarm = new SingleAlarm(resumeTestRunning, 5000);
                    SingleAlarm.request$default((SingleAlarm)alarm, (boolean)false, (int)0, (int)3, null);
                    $debugProcess.getConnection().executeOnStart((Function1)new Function1<Vm, Unit>(alarm, resumeTestRunning){
                        final /* synthetic */ SingleAlarm $alarm;
                        final /* synthetic */ Runnable $resumeTestRunning;
                        {
                            this.$alarm = $alarm;
                            this.$resumeTestRunning = $resumeTestRunning;
                            super(1);
                        }

                        public final void invoke(@NotNull Vm vm) {
                            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                            if (Registry.is((String)"js.debugger.break.on.first.statement.karma")) {
                                vm.getBreakpointManager().setBreakOnFirstStatement();
                            }
                            this.$alarm.cancelAllRequests();
                            this.$resumeTestRunning.run();
                        }
                    });
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
            XDebugSession session2 = xDebugSession;
            RunContentDescriptor runContentDescriptor = KarmaUtil.withReusePolicy(session2.getRunContentDescriptor(), karmaServer2);
            Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"withReusePolicy(...)");
            return runContentDescriptor;
        }

        private final JavaScriptDebugProcess<VmConnection<?>> createDebugProcess(XDebugSession session2, KarmaServer karmaServer, DebuggableFileFinder fileFinder, ExecutionResult executionResult, DebuggableWebBrowser debuggableWebBrowser, Url url) {
            KarmaConfig karmaConfig = karmaServer.getKarmaConfig();
            if (karmaConfig != null && karmaConfig.getRemoteDebuggingPort() > 0) {
                return (JavaScriptDebugProcess)new BrowserChromeDebugProcess(session2, fileFinder, (VmConnection)new WipRemoteVmConnection(url, null), executionResult);
            }
            JavaScriptDebugEngine javaScriptDebugEngine = debuggableWebBrowser.getDebugEngine();
            Intrinsics.checkNotNullExpressionValue((Object)javaScriptDebugEngine, (String)"getDebugEngine(...)");
            JavaScriptDebugEngine debugEngine = javaScriptDebugEngine;
            WebBrowser webBrowser = debuggableWebBrowser.getWebBrowser();
            Intrinsics.checkNotNullExpressionValue((Object)webBrowser, (String)"getWebBrowser(...)");
            WebBrowser browser = webBrowser;
            boolean reloadPage = !karmaServer.areBrowsersReady();
            return debugEngine.createDebugProcess(session2, browser, fileFinder, url, executionResult, reloadPage);
        }

        private final void openConnectionIfRemoteDebugging(KarmaServer server, VmConnection<?> connection) {
            KarmaConfig config = server.getKarmaConfig();
            if (config != null && config.getRemoteDebuggingPort() > 0 && connection instanceof WipRemoteVmConnection) {
                RemoteVmConnection.open$default((RemoteVmConnection)((RemoteVmConnection)connection), (InetSocketAddress)new InetSocketAddress(config.getHostname(), config.getRemoteDebuggingPort()), null, (int)2, null);
            }
        }

        private final DebuggableFileFinder getDebuggableFileFinder(KarmaServer karmaServer) {
            VirtualFile basePath;
            HashBiMap hashBiMap = HashBiMap.create();
            Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
            BiMap mappings = (BiMap)hashBiMap;
            KarmaConfig karmaConfig = karmaServer.getKarmaConfig();
            if (karmaConfig != null && (basePath = LocalFileSystem.getInstance().findFileByPath(karmaConfig.getBasePath())) != null && basePath.isValid()) {
                ((Map)mappings).put(karmaServer.formatUrlWithoutUrlRoot("/base"), basePath);
            }
            VirtualFile[] virtualFileArray = ManagingFS.getInstance().getLocalRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getLocalRoots(...)");
            VirtualFile[] roots = virtualFileArray;
            if (SystemInfo.isWindows) {
                for (VirtualFile root : roots) {
                    String key;
                    Intrinsics.checkNotNullExpressionValue((Object)karmaServer.formatUrlWithoutUrlRoot("/absolute" + root.getName()), (String)"formatUrlWithoutUrlRoot(...)");
                    if (mappings.containsKey((Object)key)) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(KarmaDebugProgramRunner.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("Duplicate mapping for Karma debug: " + key);
                        continue;
                    }
                    ((Map)mappings).put(key, root);
                }
            } else if (roots.length == 1) {
                ((Map)mappings).put(karmaServer.formatUrlWithoutUrlRoot("/absolute"), roots[0]);
            }
            return (DebuggableFileFinder)new RemoteDebuggingFileFinder(mappings, null);
        }

        private final void resumeTestRunning(OSProcessHandler processHandler) {
            Process process = processHandler.getProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"getProcess(...)");
            Process process2 = process;
            if (process2.isAlive()) {
                try {
                    OutputStream processInput = process2.getOutputStream();
                    String string = "resume-test-running\n";
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    processInput.write(byArray);
                    processInput.flush();
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KarmaDebugProgramRunner.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("process.isAlive()=" + process2.isAlive(), (Throwable)e);
                }
            }
        }

        public static final /* synthetic */ JavaScriptDebugProcess access$createDebugProcess(Handler $this, XDebugSession session2, KarmaServer karmaServer, DebuggableFileFinder fileFinder, ExecutionResult executionResult, DebuggableWebBrowser debuggableWebBrowser, Url url) {
            return $this.createDebugProcess(session2, karmaServer, fileFinder, executionResult, debuggableWebBrowser, url);
        }

        public static final /* synthetic */ void access$resumeTestRunning(Handler $this, OSProcessHandler processHandler) {
            $this.resumeTestRunning(processHandler);
        }

        public static final /* synthetic */ void access$openConnectionIfRemoteDebugging(Handler $this, KarmaServer server, VmConnection connection) {
            $this.openConnectionIfRemoteDebugging(server, connection);
        }
    }
}

