/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageHelper;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.karma.KarmaBundle;
import com.intellij.javascript.karma.coverage.KarmaCoveragePeer;
import com.intellij.javascript.karma.coverage.KarmaCoverageProgramRunner;
import com.intellij.javascript.karma.coverage.KarmaCoverageResultPaths;
import com.intellij.javascript.karma.coverage.KarmaCoverageRunner;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunProgramRunner;
import com.intellij.javascript.karma.server.KarmaServer;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0007H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createConfigurationData", "settingsProvider", "Lcom/intellij/execution/configurations/ConfigurationInfoProvider;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "Handler", "intellij.karma"})
public final class KarmaCoverageProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        String string = KarmaCoverageProgramRunner.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)"Coverage", (Object)executorId) && profile instanceof KarmaRunConfiguration;
    }

    @NotNull
    public RunnerSettings createConfigurationData(@NotNull ConfigurationInfoProvider settingsProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsProvider, (String)"settingsProvider");
        return (RunnerSettings)new CoverageRunnerData();
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Promise promise = KarmaRunProgramRunner.Companion.executeAsync(environment, state).then(arg_0 -> KarmaCoverageProgramRunner.execute$lambda$0((Function1)new Function1<ExecutionResult, RunContentDescriptor>(environment, state){
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ RunProfileState $state;
            {
                this.$environment = $environment;
                this.$state = $state;
                super(1);
            }

            @Nullable
            public final RunContentDescriptor invoke(ExecutionResult executionResult) {
                RunContentDescriptor runContentDescriptor = KarmaUtil.createDefaultDescriptor(executionResult, this.$environment);
                Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"createDefaultDescriptor(...)");
                RunContentDescriptor descriptor = runContentDescriptor;
                KarmaConsoleView karmaConsoleView = KarmaConsoleView.get(executionResult, this.$state);
                if (karmaConsoleView == null) {
                    return descriptor;
                }
                KarmaConsoleView consoleView = karmaConsoleView;
                KarmaServer karmaServer = consoleView.getKarmaServer();
                Intrinsics.checkNotNullExpressionValue((Object)karmaServer, (String)"getKarmaServer(...)");
                KarmaServer server = karmaServer;
                if (executionResult.getProcessHandler() instanceof NopProcessHandler) {
                    server.onBrowsersReady(() -> execute.1.invoke$lambda$0(descriptor));
                } else {
                    ProcessHandler processHandler = executionResult.getProcessHandler();
                    Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                    Handler.INSTANCE.listenForCoverageFile(this.$environment, server, NodeTargetRun.Companion.getTargetRun(processHandler));
                }
                return descriptor;
            }

            private static final void invoke$lambda$0(RunContentDescriptor $descriptor) {
                Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
                ExecutionUtil.restartIfActive((RunContentDescriptor)$descriptor);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private static final RunContentDescriptor execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RunContentDescriptor)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ<\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$Handler;", "", "()V", "listenForCoverageFile", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "server", "Lcom/intellij/javascript/karma/server/KarmaServer;", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "processLcovInfoFile", "coverageResultPaths", "Lcom/intellij/javascript/karma/coverage/KarmaCoverageResultPaths;", "toCoverageFilePath", "", "karmaServer", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "intellij.karma"})
    @SourceDebugExtension(value={"SMAP\nKarmaCoverageProgramRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KarmaCoverageProgramRunner.kt\ncom/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$Handler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n13#2:133\n13#2:134\n*S KotlinDebug\n*F\n+ 1 KarmaCoverageProgramRunner.kt\ncom/intellij/javascript/karma/coverage/KarmaCoverageProgramRunner$Handler\n*L\n121#1:133\n65#1:134\n*E\n"})
    private static final class Handler {
        @NotNull
        public static final Handler INSTANCE = new Handler();

        private Handler() {
        }

        public final void listenForCoverageFile(@NotNull ExecutionEnvironment env, @NotNull KarmaServer server, @NotNull NodeTargetRun targetRun) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            RunProfile runProfile = env.getRunProfile();
            Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.execution.configurations.RunConfigurationBase<*>");
            RunConfigurationBase runConfiguration = (RunConfigurationBase)runProfile;
            CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate((RunConfigurationBase)runConfiguration);
            Intrinsics.checkNotNullExpressionValue((Object)coverageEnabledConfiguration, (String)"getOrCreate(...)");
            CoverageEnabledConfiguration coverageEnabledConfiguration2 = coverageEnabledConfiguration;
            CoverageHelper.resetCoverageSuit((RunConfigurationBase)runConfiguration);
            String coverageFilePath = coverageEnabledConfiguration2.getCoverageFilePath();
            if (coverageFilePath != null) {
                KarmaCoveragePeer karmaCoveragePeer = server.getCoveragePeer();
                Intrinsics.checkNotNull((Object)karmaCoveragePeer);
                karmaCoveragePeer.startCoverageSession(arg_0 -> Handler.listenForCoverageFile$lambda$3(env, coverageFilePath, server, runConfiguration, targetRun, arg_0));
            }
        }

        private final void processLcovInfoFile(KarmaCoverageResultPaths coverageResultPaths, String toCoverageFilePath, ExecutionEnvironment env, KarmaServer karmaServer, RunConfigurationBase<?> runConfiguration, NodeTargetRun targetRun) {
            block2: {
                try {
                    FileUtil.copy((File)coverageResultPaths.getLocalLcovFilePath().toFile(), (File)new File(toCoverageFilePath));
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KarmaCoverageProgramRunner.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Cannot copy " + coverageResultPaths.getLocalLcovFilePath() + " to " + toCoverageFilePath, (Throwable)e);
                    return;
                }
                RunnerSettings runnerSettings = env.getRunnerSettings();
                if (runnerSettings == null) break block2;
                RunnerSettings it = runnerSettings;
                boolean bl = false;
                KarmaCoverageRunner karmaCoverageRunner = KarmaCoverageRunner.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)karmaCoverageRunner), (String)"getInstance(...)");
                KarmaCoverageRunner coverageRunner = karmaCoverageRunner;
                coverageRunner.setTargetRun(targetRun);
                coverageRunner.setProjectRoot(coverageResultPaths.getLocalProjectRoot());
                CoverageDataManager.getInstance((Project)env.getProject()).processGatheredCoverage(runConfiguration, it);
            }
        }

        private static final void listenForCoverageFile$lambda$3$lambda$2$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void listenForCoverageFile$lambda$3$lambda$2$lambda$1(Project $project, RunConfigurationBase $runConfiguration, String $coverageFilePath, ExecutionEnvironment $env, KarmaServer $server, NodeTargetRun $targetRun) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$runConfiguration, (String)"$runConfiguration");
            Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
            Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
            Intrinsics.checkNotNullParameter((Object)$targetRun, (String)"$targetRun");
            Object[] objectArray = new Object[]{"lcov.info"};
            int response = Messages.showYesNoDialog((Project)$project, (String)KarmaBundle.message("coverage.cannot_find_lcov.dialog.message", new Object[0]), (String)KarmaBundle.message("coverage.cannot_find_lcov.dialog.title", new Object[0]), (String)KarmaBundle.message("coverage.cannot_find_lcov.select_lcov.button", objectArray), (String)KarmaBundle.message("coverage.cannot_find_lcov.cancel.button", new Object[0]), (Icon)Messages.getWarningIcon());
            if (response == 0) {
                FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileDescriptor(), (Project)$project, null, null, arg_0 -> Handler.listenForCoverageFile$lambda$3$lambda$2$lambda$1$lambda$0((Function1)new Function1<VirtualFile, Unit>($project, $runConfiguration, $coverageFilePath, $env, $server, $targetRun){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ RunConfigurationBase<?> $runConfiguration;
                    final /* synthetic */ String $coverageFilePath;
                    final /* synthetic */ ExecutionEnvironment $env;
                    final /* synthetic */ KarmaServer $server;
                    final /* synthetic */ NodeTargetRun $targetRun;
                    {
                        this.$project = $project;
                        this.$runConfiguration = $runConfiguration;
                        this.$coverageFilePath = $coverageFilePath;
                        this.$env = $env;
                        this.$server = $server;
                        this.$targetRun = $targetRun;
                        super(1);
                    }

                    public final void invoke(VirtualFile it) {
                        block0: {
                            Object object = it;
                            if (object == null || (object = object.toNioPath()) == null) break block0;
                            Object object2 = object;
                            Project project = this.$project;
                            RunConfigurationBase<?> runConfigurationBase = this.$runConfiguration;
                            String string = this.$coverageFilePath;
                            ExecutionEnvironment executionEnvironment = this.$env;
                            KarmaServer karmaServer = this.$server;
                            NodeTargetRun nodeTargetRun = this.$targetRun;
                            Object it2 = object2;
                            boolean bl = false;
                            ApplicationManager.getApplication().executeOnPooledThread(() -> listenForCoverageFile.1.1.1.1.invoke$lambda$2$lambda$1(project, (Path)it2, runConfigurationBase, string, executionEnvironment, karmaServer, nodeTargetRun));
                        }
                    }

                    private static final void invoke$lambda$2$lambda$1$lambda$0(Project $project, Path $it, RunConfigurationBase $runConfiguration, String $coverageFilePath, ExecutionEnvironment $env, KarmaServer $server, NodeTargetRun $targetRun) {
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                        Intrinsics.checkNotNullParameter((Object)$runConfiguration, (String)"$runConfiguration");
                        Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
                        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
                        Intrinsics.checkNotNullParameter((Object)$targetRun, (String)"$targetRun");
                        if (!$project.isDisposed()) {
                            Path path = Path.of(((KarmaRunConfiguration)$runConfiguration).getRunSettings().getWorkingDirectorySystemDependent(), new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                            KarmaCoverageResultPaths paths = new KarmaCoverageResultPaths($it, path);
                            Handler.access$processLcovInfoFile(Handler.INSTANCE, paths, $coverageFilePath, $env, $server, $runConfiguration, $targetRun);
                        }
                    }

                    private static final void invoke$lambda$2$lambda$1(Project $project, Path $it, RunConfigurationBase $runConfiguration, String $coverageFilePath, ExecutionEnvironment $env, KarmaServer $server, NodeTargetRun $targetRun) {
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                        Intrinsics.checkNotNullParameter((Object)$runConfiguration, (String)"$runConfiguration");
                        Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
                        Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
                        Intrinsics.checkNotNullParameter((Object)$targetRun, (String)"$targetRun");
                        ReadAction.run(() -> listenForCoverageFile.1.1.1.1.invoke$lambda$2$lambda$1$lambda$0($project, $it, $runConfiguration, $coverageFilePath, $env, $server, $targetRun));
                    }
                }, arg_0));
            }
        }

        private static final void listenForCoverageFile$lambda$3$lambda$2(ExecutionEnvironment $env, KarmaCoverageResultPaths $coverageResultPaths, String $coverageFilePath, KarmaServer $server, RunConfigurationBase $runConfiguration, NodeTargetRun $targetRun) {
            Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
            Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
            Intrinsics.checkNotNullParameter((Object)$runConfiguration, (String)"$runConfiguration");
            Intrinsics.checkNotNullParameter((Object)$targetRun, (String)"$targetRun");
            Project project = $env.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            if (!project2.isDisposed()) {
                if ($coverageResultPaths != null) {
                    INSTANCE.processLcovInfoFile($coverageResultPaths, $coverageFilePath, $env, $server, $runConfiguration, $targetRun);
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> Handler.listenForCoverageFile$lambda$3$lambda$2$lambda$1(project2, $runConfiguration, $coverageFilePath, $env, $server, $targetRun), ModalityState.defaultModalityState());
            }
        }

        private static final void listenForCoverageFile$lambda$3(ExecutionEnvironment $env, String $coverageFilePath, KarmaServer $server, RunConfigurationBase $runConfiguration, NodeTargetRun $targetRun, KarmaCoverageResultPaths coverageResultPaths) {
            Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
            Intrinsics.checkNotNullParameter((Object)$server, (String)"$server");
            Intrinsics.checkNotNullParameter((Object)$runConfiguration, (String)"$runConfiguration");
            Intrinsics.checkNotNullParameter((Object)$targetRun, (String)"$targetRun");
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KarmaCoverageProgramRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            KarmaCoverageResultPaths karmaCoverageResultPaths = coverageResultPaths;
            logger.info("Processing karma coverage file: " + (karmaCoverageResultPaths != null ? karmaCoverageResultPaths.getLocalLcovFilePath() : null));
            ReadAction.run(() -> Handler.listenForCoverageFile$lambda$3$lambda$2($env, coverageResultPaths, $coverageFilePath, $server, $runConfiguration, $targetRun));
        }

        public static final /* synthetic */ void access$processLcovInfoFile(Handler $this, KarmaCoverageResultPaths coverageResultPaths, String toCoverageFilePath, ExecutionEnvironment env, KarmaServer karmaServer, RunConfigurationBase runConfiguration, NodeTargetRun targetRun) {
            $this.processLcovInfoFile(coverageResultPaths, toCoverageFilePath, env, karmaServer, runConfiguration, targetRun);
        }
    }
}

