/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.testRunner;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.nodejs.testRunner.NodeJsTestFileStructure;
import com.intellij.javascript.testFramework.nodejs.testRunner.NodeJsTestFileStructureBuilder;
import com.intellij.javascript.testing.runConfiguration.JsTestRunConfigurationProducer;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerLanguageSetting;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunConfiguration;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunConfigurationType;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunSettings;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTsKt;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTypeScriptLoader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000201B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\b\u0018\u00010\u0005R\u00020\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0018\u00010\u0005R\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\b\u0018\u00010\u0005R\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0016H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\"H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020'H\u0002J&\u0010-\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00070/H\u0014\u00a8\u00062"}, d2={"Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationProducer;", "Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationProducer;", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfiguration;", "()V", "buildContextSettings", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationProducer$ExtendedSettings;", "element", "Lcom/intellij/psi/PsiElement;", "templateRunSettings", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;", "buildDirectorySettings", "psiDirectory", "Lcom/intellij/psi/PsiDirectory;", "context", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationProducer$Context;", "buildSuiteOrTestSettings", "buildTestFileSettings", "findContextSuiteOrTestPath", "Lcom/intellij/javascript/testFramework/JsTestElementPath;", "fixWorkingDir", "settings", "conteFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getContainingJsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "getTestFileStructure", "Lcom/intellij/javascript/testFramework/nodejs/testRunner/NodeJsTestFileStructure;", "guessWorkingDir", "contextFile", "isConfigurationFromCompatibleContext", "", "configuration", "Lcom/intellij/execution/actions/ConfigurationContext;", "isTestRunnerAvailableFor", "resolveLanguage", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerLanguageSetting;", "isTypeScript", "resolveTypeScriptLoader", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerTypeScriptLoader;", "psiElementOrDir", "language", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Context", "ExtendedSettings", "intellij.nodeJS"})
public final class NodeJsTestRunnerRunConfigurationProducer
extends JsTestRunConfigurationProducer<NodeJsTestRunnerRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return (ConfigurationFactory)NodeJsTestRunnerRunConfigurationType.Companion.getInstance();
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull NodeJsTestRunnerRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement element = context.getPsiLocation();
        if (element == null || !this.isTestRunnerAvailableFor(element, context)) {
            return false;
        }
        ExtendedSettings extendedSettings = this.buildContextSettings(element, configuration.getSettings());
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        configuration.setSettings(extendedSettings2.getSettings());
        sourceElement.set((Object)extendedSettings2.getEnclosingElement());
        configuration.setGeneratedName();
        return true;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull NodeJsTestRunnerRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement element = psiElement;
        RunConfiguration runConfiguration = this.cloneTemplateConfiguration(context).getConfiguration();
        NodeJsTestRunnerRunConfiguration nodeJsTestRunnerRunConfiguration = runConfiguration instanceof NodeJsTestRunnerRunConfiguration ? (NodeJsTestRunnerRunConfiguration)runConfiguration : null;
        if (nodeJsTestRunnerRunConfiguration == null) {
            return false;
        }
        NodeJsTestRunnerRunConfiguration templateConfiguration = nodeJsTestRunnerRunConfiguration;
        ExtendedSettings extendedSettings = this.buildContextSettings(element, templateConfiguration.getSettings());
        if (extendedSettings == null) {
            return false;
        }
        ExtendedSettings extendedSettings2 = extendedSettings;
        NodeJsTestRunnerRunSettings thisRunSettings = extendedSettings2.getSettings();
        NodeJsTestRunnerRunSettings thatRunSettings = configuration.getSettings();
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)thisRunSettings.getWorkingDir()), (Object)FileUtil.toSystemIndependentName((String)thatRunSettings.getWorkingDir())) && Intrinsics.areEqual((Object)thisRunSettings.getScope(), (Object)thatRunSettings.getScope());
    }

    private final ExtendedSettings buildContextSettings(PsiElement element, NodeJsTestRunnerRunSettings templateRunSettings) {
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile == null) {
            return null;
        }
        Context context = new Context(element, element.getContainingFile(), virtualFile, templateRunSettings);
        if (element instanceof PsiDirectory) {
            return this.buildDirectorySettings((PsiDirectory)element, context);
        }
        ExtendedSettings extendedSettings = this.buildSuiteOrTestSettings(context);
        if (extendedSettings != null) {
            ExtendedSettings it = extendedSettings;
            boolean bl = false;
            return it;
        }
        return this.buildTestFileSettings(context);
    }

    public boolean isTestRunnerAvailableFor(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof PsiDirectory && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) != null) {
            return JsTestFileByTestNameIndex.hasNodeJsTestRunnerTestsUnderDirectory((Project)((PsiDirectory)element).getProject(), (VirtualFile)virtualFile);
        }
        JSFile jSFile = this.getContainingJsFile(element);
        if (jSFile == null) {
            return false;
        }
        JSFile jsFile = jSFile;
        return jsFile.getTestFileType() == JSTestFileType.NODE_JS_TEST_RUNNER;
    }

    private final ExtendedSettings buildDirectorySettings(PsiDirectory psiDirectory, Context context) {
        VirtualFile file = context.getFile();
        Project project = psiDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (JsTestFileByTestNameIndex.hasNodeJsTestRunnerTestsUnderDirectory((Project)project2, (VirtualFile)file)) {
            boolean isTypeScript = JsTestFileByTestNameIndex.hasNodeJsTestRunnerTsTestsUnderDirectory((Project)project2, (VirtualFile)file);
            NodeJsTestRunnerLanguageSetting language = this.resolveLanguage(isTypeScript);
            return new ExtendedSettings(context.getTemplateRunSettings().builder().language(language).typeScriptLoader(this.resolveTypeScriptLoader((PsiElement)psiDirectory, language)).scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)new Function1<JsTestRunScope.Builder, Unit>(context, psiDirectory){
                final /* synthetic */ Context $context;
                final /* synthetic */ PsiDirectory $psiDirectory;
                {
                    this.$context = $context;
                    this.$psiDirectory = $psiDirectory;
                    super(1);
                }

                public final void invoke(@NotNull JsTestRunScope.Builder it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    VirtualFile virtualFile = this.$context.getFile();
                    Project project = this.$psiDirectory.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    if (Intrinsics.areEqual((Object)virtualFile, (Object)ProjectUtil.guessProjectDir((Project)project))) {
                        it.kind(JsTestRunScopeKind.ALL);
                    } else {
                        JsTestRunScope.Builder builder = it.kind(JsTestRunScopeKind.DIRECTORY);
                        String string = this.$context.getFile().getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        builder.testDirectoryPath(string);
                    }
                }
            })).build(), file, (PsiElement)psiDirectory);
        }
        return null;
    }

    private final ExtendedSettings buildSuiteOrTestSettings(Context context) {
        JsTestElementPath jsTestElementPath = this.findContextSuiteOrTestPath(context.getElement());
        if (jsTestElementPath == null) {
            return null;
        }
        JsTestElementPath testPath = jsTestElementPath;
        NodeJsTestFileStructure nodeJsTestFileStructure = this.getTestFileStructure(context.getElement());
        boolean isTypeScript = nodeJsTestFileStructure != null ? nodeJsTestFileStructure.isTypeScript() : false;
        NodeJsTestRunnerLanguageSetting language = this.resolveLanguage(isTypeScript);
        NodeJsTestRunnerRunSettings nodeJsTestRunnerRunSettings = context.getTemplateRunSettings().builder().language(language).typeScriptLoader(this.resolveTypeScriptLoader(context.getElement(), language)).scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)new Function1<JsTestRunScope.Builder, Unit>(context, testPath){
            final /* synthetic */ Context $context;
            final /* synthetic */ JsTestElementPath $testPath;
            {
                this.$context = $context;
                this.$testPath = $testPath;
                super(1);
            }

            public final void invoke(@NotNull JsTestRunScope.Builder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$context.getFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                it.testFilePath(string);
                String testName = this.$testPath.getTestName();
                if (testName == null) {
                    JsTestRunScope.Builder builder = it.kind(JsTestRunScopeKind.SUITE);
                    List list = this.$testPath.getSuiteNames();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuiteNames(...)");
                    builder.testNames(list);
                } else {
                    JsTestRunScope.Builder builder = it.kind(JsTestRunScopeKind.TEST);
                    List list = this.$testPath.getSuiteNames();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuiteNames(...)");
                    builder.testNames(CollectionsKt.plus((Collection)list, (Object)testName));
                }
            }
        })).build();
        VirtualFile virtualFile = context.getFile();
        PsiElement psiElement = testPath.getTestElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getTestElement(...)");
        return new ExtendedSettings(nodeJsTestRunnerRunSettings, virtualFile, psiElement);
    }

    private final ExtendedSettings buildTestFileSettings(Context context) {
        NodeJsTestFileStructure nodeJsTestFileStructure = this.getTestFileStructure((PsiElement)context.getPsiFile());
        if (nodeJsTestFileStructure != null) {
            NodeJsTestFileStructure structure = nodeJsTestFileStructure;
            boolean bl = false;
            NodeJsTestRunnerLanguageSetting language = this.resolveLanguage(structure.isTypeScript());
            NodeJsTestRunnerRunSettings nodeJsTestRunnerRunSettings = context.getTemplateRunSettings().builder().language(language).typeScriptLoader(this.resolveTypeScriptLoader(context.getElement(), language)).scope((Function1<? super JsTestRunScope.Builder, Unit>)((Function1)new Function1<JsTestRunScope.Builder, Unit>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull JsTestRunScope.Builder it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    JsTestRunScope.Builder builder = it.kind(JsTestRunScopeKind.TEST_FILE);
                    String string = this.$context.getFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    builder.testFilePath(string);
                }
            })).build();
            VirtualFile virtualFile = context.getFile();
            JSFile jSFile = structure.getJsFile();
            Intrinsics.checkNotNullExpressionValue((Object)jSFile, (String)"getJsFile(...)");
            return new ExtendedSettings(nodeJsTestRunnerRunSettings, virtualFile, (PsiElement)jSFile);
        }
        return null;
    }

    private final NodeJsTestRunnerLanguageSetting resolveLanguage(boolean isTypeScript) {
        return isTypeScript ? NodeJsTestRunnerLanguageSetting.TYPE_SCRIPT : NodeJsTestRunnerLanguageSetting.JAVA_SCRIPT;
    }

    private final NodeJsTestRunnerTypeScriptLoader resolveTypeScriptLoader(PsiElement psiElementOrDir, NodeJsTestRunnerLanguageSetting language) {
        if (language == NodeJsTestRunnerLanguageSetting.TYPE_SCRIPT) {
            Project project = psiElementOrDir.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            VirtualFile localContext = psiElementOrDir instanceof PsiDirectory ? ((PsiDirectory)psiElementOrDir).getVirtualFile() : psiElementOrDir.getContainingFile().getVirtualFile();
            List<NodePackage> tsNodePackages = NodeJsTestRunnerTsKt.findNodejsLoaderPackagesForContext(project2, NodeJsTestRunnerTsKt.getTS_NODE_PACKAGE_DESCRIPTOR(), localContext);
            if (!((Collection)tsNodePackages).isEmpty()) {
                return NodeJsTestRunnerTypeScriptLoader.TS_NODE;
            }
            List<NodePackage> tsxPackages = NodeJsTestRunnerTsKt.findNodejsLoaderPackagesForContext(project2, NodeJsTestRunnerTsKt.getTSX_PACKAGE_DESCRIPTOR(), localContext);
            if (!((Collection)tsxPackages).isEmpty()) {
                return NodeJsTestRunnerTypeScriptLoader.TSX;
            }
        }
        return NodeJsTestRunnerTypeScriptLoader.MANUAL_SETUP_IN_NODE_OPTION;
    }

    private final JsTestElementPath findContextSuiteOrTestPath(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        TextRange textRange = element.getTextRange();
        if (textRange == null) {
            return null;
        }
        TextRange textRange2 = textRange;
        NodeJsTestFileStructure nodeJsTestFileStructure = this.getTestFileStructure(element);
        if (nodeJsTestFileStructure == null) {
            return null;
        }
        NodeJsTestFileStructure nodeJsTestStructure = nodeJsTestFileStructure;
        return nodeJsTestStructure.findTestElementPath(textRange2);
    }

    private final JSFile getContainingJsFile(PsiElement element) {
        PsiElement psiElement = element;
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        return psiFile instanceof JSFile ? (JSFile)psiFile : null;
    }

    private final NodeJsTestFileStructure getTestFileStructure(PsiElement element) {
        JSFile jSFile = this.getContainingJsFile(element);
        if (jSFile == null) {
            return null;
        }
        JSFile jsFile = jSFile;
        return (NodeJsTestFileStructure)NodeJsTestFileStructureBuilder.Companion.getInstance().fetchCachedTestFileStructure(jsFile);
    }

    private final VirtualFile guessWorkingDir(Project project, VirtualFile contextFile) {
        VirtualFile workingDir;
        VirtualFile nearestPackageJson;
        String[] stringArray = new String[]{"package.json"};
        VirtualFile virtualFile = nearestPackageJson = JSProjectUtil.findFileUpToContentRoot((Project)project, (VirtualFile)contextFile, (String[])stringArray);
        Object object = workingDir = virtualFile != null ? virtualFile.getParent() : null;
        if (workingDir == null) {
            workingDir = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(contextFile);
        }
        if (workingDir == null) {
            workingDir = contextFile.getParent();
        }
        return workingDir;
    }

    private final NodeJsTestRunnerRunSettings fixWorkingDir(NodeJsTestRunnerRunSettings settings, VirtualFile conteFileOrDir, Project project) {
        VirtualFile virtualFile;
        if (StringsKt.isBlank((CharSequence)settings.getWorkingDir()) && (virtualFile = this.guessWorkingDir(project, conteFileOrDir)) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            NodeJsTestRunnerRunSettings.Builder builder = settings.builder();
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return builder.workingDir(string).build();
        }
        return settings;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationProducer$Context;", "", "element", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "templateRunSettings", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getTemplateRunSettings", "()Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;", "intellij.nodeJS"})
    private static final class Context {
        @NotNull
        private final PsiElement element;
        @Nullable
        private final PsiFile psiFile;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final NodeJsTestRunnerRunSettings templateRunSettings;

        public Context(@NotNull PsiElement element, @Nullable PsiFile psiFile, @NotNull VirtualFile file, @NotNull NodeJsTestRunnerRunSettings templateRunSettings) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)templateRunSettings, (String)"templateRunSettings");
            this.element = element;
            this.psiFile = psiFile;
            this.file = file;
            this.templateRunSettings = templateRunSettings;
        }

        @NotNull
        public final PsiElement getElement() {
            return this.element;
        }

        @Nullable
        public final PsiFile getPsiFile() {
            return this.psiFile;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final NodeJsTestRunnerRunSettings getTemplateRunSettings() {
            return this.templateRunSettings;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationProducer$ExtendedSettings;", "", "initialSettings", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "enclosingElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationProducer;Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/psi/PsiElement;)V", "getEnclosingElement", "()Lcom/intellij/psi/PsiElement;", "settings", "getSettings", "()Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunSettings;", "intellij.nodeJS"})
    private final class ExtendedSettings {
        @NotNull
        private final PsiElement enclosingElement;
        @NotNull
        private final NodeJsTestRunnerRunSettings settings;

        public ExtendedSettings(@NotNull NodeJsTestRunnerRunSettings initialSettings, @NotNull VirtualFile contextFileOrDir, PsiElement enclosingElement) {
            Intrinsics.checkNotNullParameter((Object)initialSettings, (String)"initialSettings");
            Intrinsics.checkNotNullParameter((Object)contextFileOrDir, (String)"contextFileOrDir");
            Intrinsics.checkNotNullParameter((Object)enclosingElement, (String)"enclosingElement");
            this.enclosingElement = enclosingElement;
            Project project = this.enclosingElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.settings = NodeJsTestRunnerRunConfigurationProducer.this.fixWorkingDir(initialSettings, contextFileOrDir, project);
        }

        @NotNull
        public final PsiElement getEnclosingElement() {
            return this.enclosingElement;
        }

        @NotNull
        public final NodeJsTestRunnerRunSettings getSettings() {
            return this.settings;
        }
    }
}

