/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.testRunner;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.testing.runScope.JsTestRunScopeComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerLanguageSetting;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerLanguageSettingModel;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunConfiguration;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunConfigurationEditorKt;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerRunSettings;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTypeScriptLoader;
import com.jetbrains.nodejs.testRunner.NodeJsTestRunnerTypeScriptLoaderModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "interpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "languageModel", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerLanguageSettingModel;", "nodeOptionsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "Lorg/jetbrains/annotations/NotNull;", "panel", "Ljavax/swing/JPanel;", "scopeComponent", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeComponent;", "typeScriptLoaderModel", "Lcom/jetbrains/nodejs/testRunner/NodeJsTestRunnerTypeScriptLoaderModel;", "workingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "applyEditorTo", "", "runConfiguration", "createEditor", "Ljavax/swing/JComponent;", "createWorkingDirComponent", "resetEditorFrom", "intellij.nodeJS"})
public final class NodeJsTestRunnerRunConfigurationEditor
extends SettingsEditor<NodeJsTestRunnerRunConfiguration> {
    @NotNull
    private final NodeJsInterpreterField interpreterField;
    @NotNull
    private final RawCommandLineEditor nodeOptionsEditor;
    @NotNull
    private final TextFieldWithBrowseButton workingDirComponent;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;
    @NotNull
    private final NodeJsTestRunnerLanguageSettingModel languageModel;
    @NotNull
    private final NodeJsTestRunnerTypeScriptLoaderModel typeScriptLoaderModel;
    @NotNull
    private final JsTestRunScopeComponent scopeComponent;
    @NotNull
    private final JPanel panel;

    public NodeJsTestRunnerRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.interpreterField = new NodeJsInterpreterField(project);
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor().withMonospaced(false);
        Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor, (String)"withMonospaced(...)");
        this.nodeOptionsEditor = rawCommandLineEditor;
        this.workingDirComponent = this.createWorkingDirComponent(project);
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.languageModel = new NodeJsTestRunnerLanguageSettingModel();
        this.typeScriptLoaderModel = new NodeJsTestRunnerTypeScriptLoaderModel();
        String string = JavaScriptBundle.message((String)"rc.environmentVariables.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        final String envVariablesLabelText = string;
        int envVariablesLabelWidth = new JLabel((String)UIUtil.removeMnemonic((String)envVariablesLabelText)).getPreferredSize().width;
        this.scopeComponent = new JsTestRunScopeComponent(project, envVariablesLabelWidth, true);
        this.panel = (JPanel)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(){

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                String string = NodeJsInterpreterField.getLabelTextForComponent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabelTextForComponent(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)interpreterField).align(Align.FILL);
                    }
                });
                String string2 = NodeJSBundle.message("rc.nodejs.test.runner.language_setting", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                $this$panel.row(string2, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)((Object)languageModel)), null, (int)2, null);
                    }
                });
                String string3 = NodeJSBundle.message("rc.nodejs.test.runner.type_script_loader", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                $this$panel.row(string3, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)((Object)typeScriptLoaderModel)), null, (int)2, null);
                    }
                }).visibleIf((ObservableProperty)NodeJsTestRunnerRunConfigurationEditorKt.selectedItemMatches$default((ComboBoxModel)((Object)languageModel), null, 4.INSTANCE, 1, null));
                String string4 = JavaScriptBundle.message((String)"rc.nodeOptions.label", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                $this$panel.row(string4, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)nodeOptionsEditor).align(Align.FILL);
                    }
                });
                String string5 = JavaScriptBundle.message((String)"rc.workingDirectory.label", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                $this$panel.row(string5, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)workingDirComponent).align(Align.FILL);
                    }
                });
                $this$panel.row(envVariablesLabelText, (Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)envVarsComponent).align(Align.FILL);
                    }
                });
                Panel.separator$default((Panel)$this$panel, null, (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(){

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell(scopeComponent.getComponent()).align(Align.FILL);
                    }
                }), (int)1, null);
            }
        }));
    }

    protected void resetEditorFrom(@NotNull NodeJsTestRunnerRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        NodeJsTestRunnerRunSettings settings = runConfiguration.getSettings();
        this.interpreterField.setInterpreterRef(settings.getInterpreterRef());
        this.nodeOptionsEditor.setText(settings.getNodeOptions());
        this.workingDirComponent.setText(FileUtil.toSystemDependentName((String)settings.getWorkingDir()));
        this.envVarsComponent.setData(settings.getEnvData());
        this.scopeComponent.resetEditorFrom(settings.getScope());
        this.languageModel.setSelectedItem((Object)settings.getLanguage());
        this.typeScriptLoaderModel.setSelectedItem((Object)settings.getTypeScriptLoader());
    }

    protected void applyEditorTo(@NotNull NodeJsTestRunnerRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)runConfiguration), (String)"runConfiguration");
        NodeJsTestRunnerRunSettings.Builder builder = new NodeJsTestRunnerRunSettings.Builder(null, null, null, null, null, null, null, 127, null);
        NodeJsInterpreterRef nodeJsInterpreterRef = this.interpreterField.getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        builder.setInterpreterRef(nodeJsInterpreterRef);
        String string = this.nodeOptionsEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        builder.setNodeOptions(string);
        String string2 = PathShortener.getAbsolutePath((JTextField)this.workingDirComponent.getTextField());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        builder.setWorkingDir(string2);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        builder.setEnvData(environmentVariablesData);
        builder.setScope(this.scopeComponent.getScope());
        NodeJsTestRunnerLanguageSetting nodeJsTestRunnerLanguageSetting = (NodeJsTestRunnerLanguageSetting)((Object)this.languageModel.getSelected());
        if (nodeJsTestRunnerLanguageSetting == null) {
            nodeJsTestRunnerLanguageSetting = NodeJsTestRunnerLanguageSetting.Companion.getDEFAULT();
        }
        builder.setLanguage(nodeJsTestRunnerLanguageSetting);
        NodeJsTestRunnerTypeScriptLoader nodeJsTestRunnerTypeScriptLoader = (NodeJsTestRunnerTypeScriptLoader)((Object)this.typeScriptLoaderModel.getSelected());
        if (nodeJsTestRunnerTypeScriptLoader == null) {
            nodeJsTestRunnerTypeScriptLoader = NodeJsTestRunnerTypeScriptLoader.Companion.getDEFAULT();
        }
        builder.setTypeScriptLoader(nodeJsTestRunnerTypeScriptLoader);
        runConfiguration.setSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.panel;
    }

    private final TextFieldWithBrowseButton createWorkingDirComponent(Project project) {
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        PathShortener.enablePathShortening((JTextField)textFieldWithBrowseButton.getTextField(), null);
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)JavaScriptBundle.message((String)"rc.workingDirectory.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return textFieldWithBrowseButton;
    }
}

