/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.view.ProfilingView;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.view.actions.GoToSourceAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.MarkUnmarkAction;
import com.jetbrains.nodejs.run.profile.heap.view.actions.V8NavigateToMainTreeAction;
import com.jetbrains.nodejs.run.profile.heap.view.components.DataProviderPanel;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8HeapTreeTable;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTableWithRetainers;
import com.jetbrains.nodejs.run.profile.heap.view.components.V8MainTreeNavigator;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapBiggestObjectTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class V8HeapBiggestObjectsView
implements ProfilingView<V8HeapTreeTable> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8CachingReader myReader;
    @NotNull
    private final V8MainTreeNavigator myContainmentNavigator;
    private final V8MainTableWithRetainers<V8HeapBiggestObjectTreeTableModel> myMainTableWithRetainers;

    public V8HeapBiggestObjectsView(@NotNull Project project, @NotNull V8CachingReader reader, @NotNull V8MainTreeNavigator containmentNavigator, @NotNull Disposable disposable) {
        if (project == null) {
            V8HeapBiggestObjectsView.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            V8HeapBiggestObjectsView.$$$reportNull$$$0(1);
        }
        if (containmentNavigator == null) {
            V8HeapBiggestObjectsView.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            V8HeapBiggestObjectsView.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myReader = reader;
        this.myContainmentNavigator = containmentNavigator;
        this.myMainTableWithRetainers = new V8MainTableWithRetainers<V8HeapBiggestObjectTreeTableModel>(project, new V8HeapBiggestObjectTreeTableModel(project, this.myReader), this.myReader, this.myReader.getResourses(), disposable);
        this.myMainTableWithRetainers.setUseTreeSelectionForRetainers(false);
        this.myMainTableWithRetainers.setMainTreeNavigator(this.myContainmentNavigator);
    }

    @Override
    public JComponent getMainComponent() {
        DataProviderPanel panel = DataProviderPanel.wrap((JComponent)this.myMainTableWithRetainers.getMainSplitter());
        panel.register(V8NavigateToMainTreeAction.MAIN_TREE_NAVIGATOR.getName(), () -> this.myContainmentNavigator);
        panel.register(V8NavigateToMainTreeAction.TREE_PATH.getName(), () -> {
            TreePath path;
            if (this.myMainTableWithRetainers.getTable().isFocusOwner() && (path = this.myMainTableWithRetainers.getTable().getTree().getSelectionPath()) != null && path.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry && this.myMainTableWithRetainers.getRetainersTreeModel() != null && this.myMainTableWithRetainers.getRetainersTreeModel().getMain() != null && this.myMainTableWithRetainers.getRetainersTreeModel().getMain().equals(((V8HeapContainmentTreeTableModel.NamedEntry)path.getLastPathComponent()).getEntry())) {
                List<V8HeapContainmentTreeTableModel.NamedEntry> list = this.myMainTableWithRetainers.getRetainersTreeModel().getPathForSelectionInMainTree("Chain from root:");
                return list == null ? null : new TreePath(ArrayUtil.toObjectArray(list));
            }
            return null;
        });
        panel.register(MarkUnmarkAction.SELECTED_NODE.getName(), () -> {
            TreePath value = this.myMainTableWithRetainers.getTable().getTree().getSelectionPath();
            if (value != null && value.getLastPathComponent() instanceof V8HeapContainmentTreeTableModel.NamedEntry) {
                return ((V8HeapContainmentTreeTableModel.NamedEntry)value.getLastPathComponent()).getEntry();
            }
            return null;
        });
        panel.register(MarkUnmarkAction.REVALIDATION.getName(), new Supplier<Object>(){
            private final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    V8HeapBiggestObjectsView.this.myMainTableWithRetainers.getTable().revalidate();
                    V8HeapBiggestObjectsView.this.myMainTableWithRetainers.getTable().repaint();
                }
            };

            @Override
            public Object get() {
                return this.runnable;
            }
        });
        return panel;
    }

    @Override
    public String getName() {
        return NodeJSBundle.message("profile.cpu.biggest.objects.name", new Object[0]);
    }

    @Override
    public void addActions(DefaultActionGroup group) {
        group.add((AnAction)new MarkUnmarkAction(this.myProject, this.myReader));
        group.add((AnAction)new V8NavigateToMainTreeAction());
        group.add((AnAction)new GoToSourceAction(this.myReader, this.myMainTableWithRetainers.getTable()));
        V8Utils.installHeapPopupMenu(this.myProject, this.myMainTableWithRetainers.getTable(), this.myReader, this.myContainmentNavigator);
    }

    @Override
    public String getError() {
        return null;
    }

    @Override
    @Nullable
    public V8HeapTreeTable getTreeTable() {
        return this.myMainTableWithRetainers.getTable();
    }

    @Override
    public void defaultExpand() {
        TreeUtil.expandAll((JTree)this.myMainTableWithRetainers.getTable().getTree());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "containmentNavigator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/view/components/V8HeapBiggestObjectsView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

