/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLineFileDescriptor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8StackTableModel;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.TableWithFixedWidth;
import java.io.IOException;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackTraceTable
extends TableWithFixedWidth
implements DataProvider {
    private final Project myProject;

    public StackTraceTable(Project project, V8StackTableModel model) throws IOException {
        super(model);
        this.myProject = project;
        this.setSelectionMode(0);
    }

    @Nullable
    public V8CpuLogCall getCall() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return ((V8StackTableModel)this.getModel()).getCall(row);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            StackTraceTable.$$$reportNull$$$0(0);
        }
        if (PlatformCoreDataKeys.BGT_DATA_PROVIDER.is(dataId)) {
            V8CpuLogCall call = this.getCall();
            if (call == null) {
                return null;
            }
            return slowId -> StackTraceTable.getSlowData(slowId, call, this.myProject);
        }
        if (V8Utils.NAVIGATION_POSITION.is(dataId)) {
            V8CpuLogCall call = this.getCall();
            V8ProfileLineFileDescriptor descriptor = call == null ? null : call.getDescriptor();
            return descriptor == null ? null : Pair.create((Object)descriptor.getRow(), (Object)descriptor.getCol());
        }
        if (V8Utils.IS_NAVIGATABLE.is(dataId)) {
            V8CpuLogCall call = this.getCall();
            return call == null ? null : Boolean.valueOf(call.getDescriptor() != null);
        }
        if (V8Utils.SELECTED_CALL.is(dataId)) {
            return this.getCall();
        }
        return null;
    }

    @Nullable
    private static Object getSlowData(@NotNull String dataId, @NotNull V8CpuLogCall call, @NotNull Project project) {
        if (dataId == null) {
            StackTraceTable.$$$reportNull$$$0(1);
        }
        if (call == null) {
            StackTraceTable.$$$reportNull$$$0(2);
        }
        if (project == null) {
            StackTraceTable.$$$reportNull$$$0(3);
        }
        if (V8Utils.NAVIGATABLE_ONLY_FOR_ACTION.is(dataId)) {
            return call.getNavigatables(project);
        }
        return null;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return ((V8StackTableModel)this.getModel()).getCellRenderer(row, column);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ui/StackTraceTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSlowData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

