/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import org.jetbrains.annotations.NotNull;

public class NodeunitSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final EnvironmentVariablesData myEnvData;
    private final NodePackage myNodeunitPackage;
    private final String myWorkingDirectory;
    private final NodeunitTestType myTestType;
    private final String myDirectory;
    private final String myJsFile;
    private final String myTestName;

    public NodeunitSettings(@NotNull Builder builder) {
        if (builder == null) {
            NodeunitSettings.$$$reportNull$$$0(0);
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myEnvData = builder.myEnvData;
        this.myNodeunitPackage = builder.myNodeunitPackage;
        this.myWorkingDirectory = FileUtil.toSystemIndependentName((String)builder.myWorkingDirectory);
        this.myTestType = builder.myTestType;
        this.myDirectory = FileUtil.toSystemIndependentName((String)builder.myDirectory);
        this.myJsFile = FileUtil.toSystemIndependentName((String)builder.myJsFile);
        this.myTestName = builder.myTestName;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            NodeunitSettings.$$$reportNull$$$0(1);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            NodeunitSettings.$$$reportNull$$$0(2);
        }
        return environmentVariablesData;
    }

    @NotNull
    public NodePackage getNodeunitPackage() {
        NodePackage nodePackage = this.myNodeunitPackage;
        if (nodePackage == null) {
            NodeunitSettings.$$$reportNull$$$0(3);
        }
        return nodePackage;
    }

    @NotNull
    @NlsSafe
    public String getWorkingDirectory() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            NodeunitSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public NodeunitTestType getTestType() {
        NodeunitTestType nodeunitTestType = this.myTestType;
        if (nodeunitTestType == null) {
            NodeunitSettings.$$$reportNull$$$0(5);
        }
        return nodeunitTestType;
    }

    @NotNull
    @NlsSafe
    public String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            NodeunitSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getJsFile() {
        String string = this.myJsFile;
        if (string == null) {
            NodeunitSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getTestName() {
        String string = this.myTestName;
        if (string == null) {
            NodeunitSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Builder builder() {
        return new Builder(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeunitPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private EnvironmentVariablesData myEnvData;
        private NodePackage myNodeunitPackage;
        private String myWorkingDirectory;
        private NodeunitTestType myTestType;
        private String myDirectory;
        private String myJsFile;
        private String myTestName;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNodeunitPackage = new NodePackage("");
            this.myWorkingDirectory = "";
            this.myTestType = NodeunitTestType.JS_FILE;
            this.myDirectory = "";
            this.myJsFile = "";
            this.myTestName = "";
        }

        public Builder(@NotNull NodeunitSettings settings) {
            if (settings == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNodeunitPackage = new NodePackage("");
            this.myWorkingDirectory = "";
            this.myTestType = NodeunitTestType.JS_FILE;
            this.myDirectory = "";
            this.myJsFile = "";
            this.myTestName = "";
            this.myInterpreterRef = settings.getInterpreterRef();
            this.myEnvData = settings.getEnvData();
            this.myNodeunitPackage = settings.getNodeunitPackage();
            this.myWorkingDirectory = settings.getWorkingDirectory();
            this.myTestType = settings.getTestType();
            this.myDirectory = settings.getDirectory();
            this.myJsFile = settings.getJsFile();
            this.myTestName = settings.getTestName();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef2) {
            if (interpreterRef2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setNodeunitPackage(@NotNull NodePackage nodeunitPackage) {
            if (nodeunitPackage == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myNodeunitPackage = nodeunitPackage;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setTestType(@NotNull NodeunitTestType testType) {
            if (testType == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myTestType = testType;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder setWorkingDirectory(@NotNull String workingDirectory) {
            if (workingDirectory == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myWorkingDirectory = workingDirectory;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder setDirectory(@NotNull @NlsSafe String directory) {
            if (directory == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myDirectory = directory;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder setJsFilePath(@NotNull @NlsSafe String jsFile) {
            if (jsFile == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myJsFile = jsFile;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public Builder setTest(@NotNull @NlsSafe String testName) {
            if (testName == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myTestName = testName;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder;
        }

        @NotNull
        public NodeunitSettings build() {
            return new NodeunitSettings(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6, 8, 10, 12, 14, 16 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envData";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeunitPackage";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testType";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingDirectory";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jsFile";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnvData";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeunitPackage";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTestType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setWorkingDirectory";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDirectory";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setJsFilePath";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvData";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setNodeunitPackage";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setTestType";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setWorkingDirectory";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setDirectory";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setJsFilePath";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setTest";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6, 8, 10, 12, 14, 16 -> new IllegalStateException(string);
            };
        }
    }
}

