/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.io.OutputStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventSerializer;", "", "()V", "toJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "event", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "toString", "", "request", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "", "session", "writer", "Ljava/io/OutputStreamWriter;", "intellij.platform.statistics.uploader"})
public final class LogEventSerializer {
    @NotNull
    public static final LogEventSerializer INSTANCE = new LogEventSerializer();

    private LogEventSerializer() {
    }

    public final void toString(@NotNull LogEventRecordRequest session, @NotNull OutputStreamWriter writer) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write(this.toString(session));
    }

    @NotNull
    public final String toString(@NotNull LogEventRecordRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode obj = mapper.createObjectNode();
        obj.put("recorder", request.getRecorder());
        obj.put("product", request.getProduct());
        obj.put("device", request.getDevice());
        if (request.getInternal()) {
            obj.put("internal", true);
        }
        ArrayNode records = mapper.createArrayNode();
        for (LogEventRecord record : request.getRecords()) {
            ArrayNode events = mapper.createArrayNode();
            for (LogEvent event : record.getEvents()) {
                events.add((JsonNode)this.toJson(event));
            }
            ObjectNode recordObj = mapper.createObjectNode();
            recordObj.putArray("events").addAll(events);
            records.add((JsonNode)recordObj);
        }
        obj.putArray("records").addAll(records);
        String string = obj.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final ObjectNode toJson(LogEvent event) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode obj = mapper.createObjectNode();
        obj.put("recorder_version", event.getRecorderVersion());
        obj.put("session", event.getSession());
        obj.put("build", event.getBuild());
        obj.put("bucket", event.getBucket());
        obj.put("time", event.getTime());
        ObjectNode group = mapper.createObjectNode();
        group.put("id", event.getGroup().getId());
        group.put("version", event.getGroup().getVersion());
        ObjectNode action = mapper.createObjectNode();
        if (event.getEvent().getState()) {
            action.put("state", event.getEvent().getState());
        } else {
            action.put("count", event.getEvent().getCount());
        }
        action.set("data", mapper.valueToTree((Object)event.getEvent().getData()));
        action.put("id", event.getEvent().getId());
        obj.set("group", (JsonNode)group);
        obj.set("event", (JsonNode)action);
        Intrinsics.checkNotNull((Object)obj);
        return obj;
    }

    @NotNull
    public final String toString(@NotNull LogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = this.toJson(event).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

