/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.xml;

import com.intellij.application.options.CodeStyle;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.lang.Language;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.TokenType;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTextExtractor
extends TextExtractor {
    private static final TextContentBuilder builder = TextContentBuilder.FromPsi.removingIndents(" \t").removingLineSuffixes(" \t");
    private final Set<Class<? extends Language>> myEnabledDialects;
    private static final Set<String> NON_TEXT_TAGS = Set.of("code", "pre");

    protected XmlTextExtractor(Class<? extends Language> ... enabledDialects) {
        this.myEnabledDialects = Set.of(enabledDialects);
    }

    protected Function<XmlTag, TagKind> tagClassifier(@NotNull PsiElement context) {
        if (context == null) {
            XmlTextExtractor.$$$reportNull$$$0(0);
        }
        return __ -> TagKind.Unknown;
    }

    @Override
    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        TextContent content;
        IElementType type;
        if (element == null) {
            XmlTextExtractor.$$$reportNull$$$0(1);
        }
        if (allowedDomains == null) {
            XmlTextExtractor.$$$reportNull$$$0(2);
        }
        if (XmlTextExtractor.isText(element) && this.hasSuitableDialect(element)) {
            Function<XmlTag, TagKind> classifier = this.tagClassifier(element);
            PsiElement container = (PsiElement)SyntaxTraverser.psiApi().parents((Object)element).find(e -> e instanceof XmlDocument || e instanceof XmlTag && classifier.apply((XmlTag)e) != TagKind.Inline);
            if (container != null) {
                Map contentsInside = (Map)CachedValuesManager.getCachedValue((PsiElement)container, () -> CachedValueProvider.Result.create(this.calcContents(container), (Object[])new Object[]{container}));
                return (TextContent)contentsInside.get(element);
            }
        }
        if ((type = PsiUtilCore.getElementType((PsiElement)element)) == XmlTokenType.XML_COMMENT_CHARACTERS && allowedDomains.contains((Object)TextContent.TextDomain.COMMENTS) && this.hasSuitableDialect(element)) {
            return builder.build(element, TextContent.TextDomain.COMMENTS);
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && allowedDomains.contains((Object)TextContent.TextDomain.LITERALS) && this.hasSuitableDialect(element) && (content = builder.build(element, TextContent.TextDomain.LITERALS)) != null && XmlTextExtractor.seemsNatural(content)) {
            return content;
        }
        return null;
    }

    @NotNull
    private Map<PsiElement, TextContent> calcContents(final PsiElement container) {
        if (container instanceof XmlTag && XmlTextExtractor.isNonText((XmlTag)container)) {
            Map<PsiElement, TextContent> map = Collections.emptyMap();
            if (map == null) {
                XmlTextExtractor.$$$reportNull$$$0(3);
            }
            return map;
        }
        final Function<XmlTag, TagKind> classifier = this.tagClassifier(container);
        final boolean unknownContainer = container instanceof XmlTag && classifier.apply((XmlTag)container) == TagKind.Unknown;
        final NotNullLazyValue fullContent = NotNullLazyValue.lazy(() -> TextContent.psiFragment(TextContent.TextDomain.PLAIN_TEXT, container));
        var visitor = new PsiRecursiveElementWalkingVisitor(){
            final Map<PsiElement, TextContent> result = new HashMap<PsiElement, TextContent>();
            final List<PsiElement> group = new ArrayList<PsiElement>();
            final Set<Integer> markupIndices = new HashSet<Integer>();
            final Set<XmlTag> inlineTags = new HashSet<XmlTag>();
            boolean unknownBefore = unknownContainer;

            public void visitElement(@NotNull PsiElement each) {
                if (each == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (each instanceof XmlTag) {
                    XmlTag tag = (XmlTag)each;
                    TagKind kind = (TagKind)((Object)classifier.apply(tag));
                    if (kind != TagKind.Inline) {
                        boolean unknown = kind == TagKind.Unknown;
                        this.flushGroup(unknown);
                        this.unknownBefore = unknown;
                        return;
                    }
                    this.inlineTags.add(tag);
                    this.markupIndices.add(this.group.size());
                }
                if (each instanceof OuterLanguageElement || each instanceof XmlEntityRef) {
                    this.flushGroup(true);
                    this.unknownBefore = true;
                }
                if (XmlTextExtractor.isText(each)) {
                    this.group.add(each);
                }
                super.visitElement(each);
            }

            protected void elementFinished(PsiElement element) {
                super.elementFinished(element);
                if (this.inlineTags.contains(element)) {
                    this.markupIndices.add(this.group.size());
                }
            }

            private void flushGroup(boolean unknownAfter) {
                int containerStart = container.getTextRange().getStartOffset();
                ArrayList<TextContent> components = new ArrayList<TextContent>(this.group.size());
                for (int i = 0; i < this.group.size(); ++i) {
                    PsiElement e = this.group.get(i);
                    TextContent component2 = XmlTextExtractor.extractRange((TextContent)fullContent.getValue(), e.getTextRange().shiftLeft(containerStart));
                    if (this.markupIndices.contains(i)) {
                        component2 = component2.excludeRanges(List.of(new TextContent.Exclusion(0, 0, TextContent.ExclusionKind.markup)));
                    }
                    if (this.markupIndices.contains(i + 1)) {
                        component2 = component2.excludeRanges(List.of(new TextContent.Exclusion(component2.length(), component2.length(), TextContent.ExclusionKind.markup)));
                    }
                    components.add(component2);
                }
                TextContent content = TextContent.join(components);
                if (content != null) {
                    if (this.unknownBefore) {
                        content = content.markUnknown(TextRange.from((int)0, (int)0));
                    }
                    if (unknownAfter) {
                        content = content.markUnknown(TextRange.from((int)content.length(), (int)0));
                    }
                    if ((content = HtmlUtilsKt.nbspToSpace(content.removeIndents(Set.of(Character.valueOf(' '), Character.valueOf('\t'))))) != null) {
                        for (PsiElement e : this.group) {
                            this.result.put(e, content);
                        }
                    }
                }
                this.group.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/grazie/ide/language/xml/XmlTextExtractor$1", "visitElement"));
            }
        };
        container.acceptChildren((PsiElementVisitor)visitor);
        visitor.flushGroup(unknownContainer);
        Map<PsiElement, TextContent> map = visitor.result;
        if (map == null) {
            XmlTextExtractor.$$$reportNull$$$0(4);
        }
        return map;
    }

    private static boolean seemsNatural(TextContent content) {
        return content.toString().contains(" ");
    }

    private static TextContent extractRange(TextContent full, TextRange range) {
        return full.excludeRange(new TextRange(range.getEndOffset(), full.length())).excludeRange(new TextRange(0, range.getStartOffset()));
    }

    private static boolean isText(PsiElement leaf) {
        PsiElement parent = leaf.getParent();
        if (!(parent instanceof XmlText || PsiUtilCore.getElementType((PsiElement)parent) == XmlElementType.XML_CDATA && parent.getParent() instanceof XmlText || parent instanceof XmlDocument)) {
            return false;
        }
        IElementType type = PsiUtilCore.getElementType((PsiElement)leaf);
        return type == XmlTokenType.XML_WHITE_SPACE || type == TokenType.WHITE_SPACE || type == XmlTokenType.XML_CHAR_ENTITY_REF || type == XmlTokenType.XML_DATA_CHARACTERS;
    }

    private boolean hasSuitableDialect(@NotNull PsiElement element) {
        if (element == null) {
            XmlTextExtractor.$$$reportNull$$$0(5);
        }
        return this.myEnabledDialects.contains(element.getContainingFile().getLanguage().getClass());
    }

    private static boolean isNonText(XmlTag tag) {
        return tag instanceof HtmlTag && NON_TEXT_TAGS.contains(tag.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/language/xml/XmlTextExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/language/xml/XmlTextExtractor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tagClassifier";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContent";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasSuitableDialect";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4 -> new IllegalStateException(string2);
        };
    }

    protected static enum TagKind {
        Block,
        Inline,
        Unknown;

    }

    public static class Html
    extends XmlTextExtractor {
        private static final Set<String> DEFINITELY_BLOCK_TAGS = Set.of("body", "p", "br", "td", "li", "title", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "table");

        public Html() {
            super(HTMLLanguage.class);
        }

        @Override
        protected Function<XmlTag, TagKind> tagClassifier(@NotNull PsiElement context) {
            if (context == null) {
                Html.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"grazie.html.concatenate.inline.tag.contents")) {
                return super.tagClassifier(context);
            }
            HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context.getContainingFile(), HtmlCodeStyleSettings.class);
            HashSet inlineTags = ContainerUtil.newHashSet((Object[])settings.HTML_INLINE_ELEMENTS.split(","));
            return tag -> {
                String name = tag.getName();
                if (NON_TEXT_TAGS.contains(name)) {
                    return TagKind.Unknown;
                }
                if (DEFINITELY_BLOCK_TAGS.contains(name)) {
                    return TagKind.Block;
                }
                if (inlineTags.contains(name)) {
                    return TagKind.Inline;
                }
                return TagKind.Unknown;
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/grazie/ide/language/xml/XmlTextExtractor$Html", "tagClassifier"));
        }
    }

    public static class Xml
    extends XmlTextExtractor {
        public Xml() {
            super(XMLLanguage.class, XHTMLLanguage.class, DTDLanguage.class);
        }
    }
}

