/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.run.configurations.debugger;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rider.cpp.RiderCppBundle;
import com.jetbrains.rider.cpp.run.configurations.debugger.RiderCppCoreDumpConfigurationParameters;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.controls.ControlBase;
import com.jetbrains.rider.run.configurations.controls.EditableList;
import com.jetbrains.rider.run.configurations.controls.PathSelectorWithMacroSupport;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0018\u001a\u00020\u0019\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\rJ\b\u0010\u001f\u001a\u00020\u0019H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/cpp/run/configurations/debugger/RiderCppCoreDumpConfigurationViewModel;", "Lcom/jetbrains/rider/run/configurations/controls/RunConfigurationViewModelBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "controls", "", "Lcom/jetbrains/rider/run/configurations/controls/ControlBase;", "getControls", "()Ljava/util/List;", "coreDumpSelector", "Lcom/jetbrains/rider/run/configurations/controls/PathSelectorWithMacroSupport;", "editableParameters", "Lcom/jetbrains/rider/cpp/run/configurations/debugger/RiderCppCoreDumpConfigurationParameters;", "getEditableParameters", "()Lcom/jetbrains/rider/cpp/run/configurations/debugger/RiderCppCoreDumpConfigurationParameters;", "execSearchPaths", "Lcom/jetbrains/rider/run/configurations/controls/EditableList;", "executableSelector", "isInEditorInitializationState", "", "()Z", "setInEditorInitializationState", "(Z)V", "adviceEditorChanged", "", "T", "valueProperty", "Lcom/jetbrains/rd/util/reactive/ISource;", "reset", "configurationParameters", "updateEditableConfiguration", "intellij.rider.plugins.cpp"})
public final class RiderCppCoreDumpConfigurationViewModel
extends RunConfigurationViewModelBase {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final PathSelectorWithMacroSupport coreDumpSelector;
    @NotNull
    private final PathSelectorWithMacroSupport executableSelector;
    @NotNull
    private final EditableList execSearchPaths;
    @NotNull
    private final RiderCppCoreDumpConfigurationParameters editableParameters;
    private boolean isInEditorInitializationState;
    @NotNull
    private final List<ControlBase> controls;

    public RiderCppCoreDumpConfigurationViewModel(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.coreDumpSelector = new PathSelectorWithMacroSupport(RiderCppBundle.Companion.message("cpp.run.configuration.core.dump.path", new Object[0]), "Core_dump_path", FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), this.lifetime);
        this.executableSelector = new PathSelectorWithMacroSupport(RiderRunBundle.Companion.message("label.exe.path.with.colon", new Object[0]), "Executable_path", FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), this.lifetime);
        this.execSearchPaths = new EditableList(RiderCppBundle.Companion.message("cpp.run.configuration.core.binaries.search.paths", new Object[0]), "Binaries_search_paths");
        this.editableParameters = RiderCppCoreDumpConfigurationParameters.Companion.createEmpty();
        Object[] objectArray = new ControlBase[]{this.coreDumpSelector, this.executableSelector, this.execSearchPaths};
        this.controls = CollectionsKt.listOf((Object[])objectArray);
        this.adviceEditorChanged((ISource)this.coreDumpSelector.getPath());
        this.adviceEditorChanged((ISource)this.executableSelector.getPath());
        this.adviceEditorChanged((ISource)this.execSearchPaths.getValues());
    }

    @NotNull
    public final RiderCppCoreDumpConfigurationParameters getEditableParameters() {
        return this.editableParameters;
    }

    public final boolean isInEditorInitializationState() {
        return this.isInEditorInitializationState;
    }

    public final void setInEditorInitializationState(boolean bl) {
        this.isInEditorInitializationState = bl;
    }

    @NotNull
    public List<ControlBase> getControls() {
        return this.controls;
    }

    private final void updateEditableConfiguration() {
        if (this.isInEditorInitializationState) {
            return;
        }
        if (!((Boolean)this.coreDumpSelector.getMixedValue().getValue()).booleanValue()) {
            this.editableParameters.setCoreDumpPath((String)this.coreDumpSelector.getPath().getValue());
        }
        if (!((Boolean)this.executableSelector.getMixedValue().getValue()).booleanValue()) {
            this.editableParameters.setExecutablePath((String)this.executableSelector.getPath().getValue());
        }
        this.editableParameters.setExecSearchPaths((List)this.execSearchPaths.getValues().getValue());
    }

    private final <T> void adviceEditorChanged(ISource<? extends T> valueProperty) {
        valueProperty.advise(this.lifetime, new Function1<T, Unit>(this){
            final /* synthetic */ RiderCppCoreDumpConfigurationViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(T it) {
                RiderCppCoreDumpConfigurationViewModel.access$updateEditableConfiguration(this.this$0);
            }
        });
    }

    public final void reset(@NotNull RiderCppCoreDumpConfigurationParameters configurationParameters) {
        Intrinsics.checkNotNullParameter((Object)configurationParameters, (String)"configurationParameters");
        this.editableParameters.reset(configurationParameters);
        this.isInEditorInitializationState = true;
        this.coreDumpSelector.getPath().set((Object)this.editableParameters.getCoreDumpPath());
        this.coreDumpSelector.getMixedValue().set((Object)false);
        this.executableSelector.getPath().set((Object)this.editableParameters.getExecutablePath());
        this.executableSelector.getMixedValue().set((Object)false);
        this.execSearchPaths.getValues().set(this.editableParameters.getExecSearchPaths());
        this.isInEditorInitializationState = false;
        this.updateEditableConfiguration();
    }

    public static final /* synthetic */ void access$updateEditableConfiguration(RiderCppCoreDumpConfigurationViewModel $this) {
        $this.updateEditableConfiguration();
    }
}

