/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.run.configurations;

import com.jetbrains.rider.run.configurations.ProjectPropertiesMacroUtils;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nJ*\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nJ\"\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/cpp/run/configurations/CppProjectExecutorFactoryEx;", "", "()V", "TARGET_PATH", "", "TARGET_PATH_MACRO", "calculateActualTargetPath", "projectFilePath", "exePath", "evaluatedMacros", "", "calculateActualWorkingDirectoryPath", "calculateDefaultTargetPath", "intellij.rider.plugins.cpp"})
public final class CppProjectExecutorFactoryEx {
    @NotNull
    public static final CppProjectExecutorFactoryEx INSTANCE = new CppProjectExecutorFactoryEx();
    @NotNull
    private static final String TARGET_PATH = "TargetPath";
    @NotNull
    private static final String TARGET_PATH_MACRO = "$(TargetPath)";

    private CppProjectExecutorFactoryEx() {
    }

    @NotNull
    public final String calculateDefaultTargetPath(@NotNull String projectFilePath, @NotNull Map<String, String> evaluatedMacros) {
        String string;
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter(evaluatedMacros, (String)"evaluatedMacros");
        String path = ((Object)StringsKt.trim((CharSequence)ProjectPropertiesMacroUtils.Companion.processMacros(TARGET_PATH_MACRO, evaluatedMacros))).toString();
        File projectDir = new File(projectFilePath).getParentFile();
        if (projectDir == null) {
            string = path;
        } else {
            String string2 = FilesKt.resolve((File)projectDir, (String)path).getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        }
        return string;
    }

    @NotNull
    public final String calculateActualTargetPath(@NotNull String projectFilePath, @NotNull String exePath, @NotNull Map<String, String> evaluatedMacros) {
        String string;
        File projectDir;
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        Intrinsics.checkNotNullParameter(evaluatedMacros, (String)"evaluatedMacros");
        String path = ProjectPropertiesMacroUtils.Companion.processMacros(exePath, evaluatedMacros);
        path = ((Object)StringsKt.trim((CharSequence)path)).toString();
        if (((CharSequence)path).length() == 0) {
            path = ProjectPropertiesMacroUtils.Companion.processMacros(TARGET_PATH_MACRO, evaluatedMacros);
            path = ((Object)StringsKt.trim((CharSequence)path)).toString();
        }
        if ((projectDir = new File(projectFilePath).getParentFile()) == null) {
            string = path;
        } else {
            String string2 = FilesKt.resolve((File)projectDir, (String)path).getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        }
        return string;
    }

    @NotNull
    public final String calculateActualWorkingDirectoryPath(@NotNull String projectFilePath, @NotNull String exePath, @NotNull Map<String, String> evaluatedMacros) {
        String string;
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        Intrinsics.checkNotNullParameter(evaluatedMacros, (String)"evaluatedMacros");
        String path = ProjectPropertiesMacroUtils.Companion.processMacros(exePath, evaluatedMacros);
        path = ((Object)StringsKt.trim((CharSequence)path)).toString();
        File projectDir = new File(projectFilePath).getParentFile();
        if (projectDir == null) {
            string = path;
        } else {
            String string2 = FilesKt.resolve((File)projectDir, (String)path).getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        }
        return string;
    }
}

