/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.run.configurations;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfiguration;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfigurationType;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.run.configurations.ConfigurationContextExKt;
import com.jetbrains.rider.run.configurations.RiderProjectConfigurationProducerBase;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationProducer;", "Lcom/jetbrains/rider/run/configurations/RiderProjectConfigurationProducerBase;", "Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfiguration;", "()V", "isConfigurationFromContext", "", "configurationConfiguration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "trySetupConfigurationFromRunnableProject", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "configuration", "selectedProjectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "intellij.rider.plugins.cpp"})
public final class CppProjectConfigurationProducer
extends RiderProjectConfigurationProducerBase<CppProjectConfiguration> {
    public CppProjectConfigurationProducer() {
        super(CppProjectConfigurationType.class);
    }

    public boolean isConfigurationFromContext(@NotNull CppProjectConfiguration configurationConfiguration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configurationConfiguration), (String)"configurationConfiguration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectModelEntity projectModelEntity = ConfigurationContextExKt.getSelectedProject((ConfigurationContext)context);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity item = projectModelEntity;
        File file = ProjectModelEntityExtensionsKt.getFile((ProjectModelEntity)item);
        String string = file != null ? file.getPath() : null;
        if (string == null) {
            string = "";
        }
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)string), (Object)configurationConfiguration.getParameters().getDefaultProjectFilePath());
    }

    protected boolean trySetupConfigurationFromRunnableProject(@NotNull RunnableProject runnableProject, @NotNull CppProjectConfiguration configuration2, @NotNull ProjectModelEntity selectedProjectEntity) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)selectedProjectEntity, (String)"selectedProjectEntity");
        if (!CppProjectConfigurationType.Companion.isTypeApplicable(runnableProject.getKind()) || !StringsKt.endsWith((String)runnableProject.getProjectFilePath(), (String)".vcxproj", (boolean)true)) {
            return false;
        }
        configuration2.setName(runnableProject.getFullName());
        Project project = configuration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CppProjectConfigurationType.Companion.setupFromProject(project, configuration2, runnableProject);
        return true;
    }
}

