/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.run.configurations;

import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfiguration;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfigurationParameters;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfigurationViewModel;
import com.jetbrains.rider.cpp.run.configurations.CppRunnableProjectKinds;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.projectView.SolutionConfigurationManager;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.AnchoredPanel;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0014J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "editorLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "viewModel", "Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationViewModel;)V", "applyEditorTo", "", "configuration", "createEditor", "Ljavax/swing/JComponent;", "disposeEditor", "resetEditorFrom", "intellij.rider.plugins.cpp"})
public final class CppProjectConfigurationEditor
extends SettingsEditor<CppProjectConfiguration> {
    @NotNull
    private final Project project;
    public CppProjectConfigurationViewModel viewModel;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final SequentialLifetimes editorLifetime;

    public CppProjectConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lifetimeDefinition = Lifetime.Companion.getEternal().createNested();
        this.editorLifetime = new SequentialLifetimes(this.lifetimeDefinition.getLifetime());
    }

    @NotNull
    public final CppProjectConfigurationViewModel getViewModel() {
        CppProjectConfigurationViewModel cppProjectConfigurationViewModel = this.viewModel;
        if (cppProjectConfigurationViewModel != null) {
            return cppProjectConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull CppProjectConfigurationViewModel cppProjectConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)cppProjectConfigurationViewModel), (String)"<set-?>");
        this.viewModel = cppProjectConfigurationViewModel;
    }

    protected void disposeEditor() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        super.disposeEditor();
    }

    protected void resetEditorFrom(@NotNull CppProjectConfiguration configuration2) {
        CppProjectConfigurationParameters cppProjectConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        String defaultProjectFilePath = configuration2.getParameters().getDefaultProjectFilePath();
        CppProjectConfigurationParameters $this$resetEditorFrom_u24lambda_u240 = cppProjectConfigurationParameters = new CppProjectConfigurationParameters(this.project, defaultProjectFilePath, CppRunnableProjectKinds.INSTANCE.getNMake());
        boolean bl = false;
        $this$resetEditorFrom_u24lambda_u240.getParametersMap().reset(configuration2.getParameters().getParametersMap());
        CppProjectConfigurationParameters clone = cppProjectConfigurationParameters;
        this.getViewModel().reset(clone);
    }

    protected void applyEditorTo(@NotNull CppProjectConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        RunnableProject selectedProject = (RunnableProject)this.getViewModel().getProjectSelector().getProject().getValueOrNull();
        if (selectedProject != null) {
            configuration2.getParameters().getParametersMap().reset(this.getViewModel().getEditableConfiguration());
        }
    }

    @NotNull
    public JComponent createEditor() {
        LifetimeDefinition lifetime = this.editorLifetime.next();
        SolutionConfigurationManager configurationManager = SolutionConfigurationManager.Companion.tryGetInstance(this.project);
        Lifetime lifetime2 = (Lifetime)lifetime;
        RunnableProjectsModel runnableProjectsModel = ProjectExKt.getRunnableProjectsModelIfAvailable((Project)this.project);
        SolutionConfigurationManager solutionConfigurationManager = configurationManager;
        Object object = solutionConfigurationManager != null ? solutionConfigurationManager.getActiveConfigurationAndPlatform() : null;
        SolutionConfigurationManager solutionConfigurationManager2 = configurationManager;
        List list = solutionConfigurationManager2 != null ? solutionConfigurationManager2.getSolutionConfigurationsAndPlatforms() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.setViewModel(new CppProjectConfigurationViewModel(this.project, lifetime2, runnableProjectsModel, (RdConfigurationAndPlatform)object, list, CppRunnableProjectKinds.INSTANCE.getNMake()));
        AnchoredPanel editor2 = new ControlViewBuilder((Lifetime)lifetime, this.project, "CppProject").build((RunConfigurationViewModelBase)this.getViewModel());
        int minWidth = editor2.getMinimumSize().width;
        JPanel gap = new JPanel();
        gap.setMinimumSize(new Dimension(minWidth, 0));
        gap.setPreferredSize(new Dimension(0, 0));
        editor2.add((Component)gap);
        IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null).allowPumpProtocolForComponent((Component)editor2, LifetimeDisposableExKt.createNestedDisposable((Lifetime)((Lifetime)lifetime), (String)"CppProjectConfigurationEditor"));
        return (JComponent)editor2;
    }
}

