/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.livePP.msg;

import com.jetbrains.rider.cpp.livePP.LivePPException;
import com.jetbrains.rider.cpp.livePP.msg.MessageType;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.ULong;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/cpp/livePP/msg/Message;", "", "messageType", "Lcom/jetbrains/rider/cpp/livePP/msg/MessageType;", "(Lcom/jetbrains/rider/cpp/livePP/msg/MessageType;)V", "getMessageType", "()Lcom/jetbrains/rider/cpp/livePP/msg/MessageType;", "receive", "", "reader", "Ljava/io/InputStream;", "send", "writer", "Ljava/io/OutputStream;", "Companion", "intellij.rider.plugins.cpp"})
public abstract class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageType messageType;

    public Message(@NotNull MessageType messageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)messageType), (String)"messageType");
        this.messageType = messageType;
    }

    @NotNull
    public final MessageType getMessageType() {
        return this.messageType;
    }

    public void send(@NotNull OutputStream writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Companion.sendInt16(writer, this.messageType.toInt16());
    }

    public void receive(@NotNull InputStream reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
    }

    @JvmStatic
    public static final void sendBool(@NotNull OutputStream writer, boolean bool) {
        Companion.sendBool(writer, bool);
    }

    @JvmStatic
    public static final void sendInt16(@NotNull OutputStream writer, short int16) {
        Companion.sendInt16(writer, int16);
    }

    @JvmStatic
    public static final void sendInt32(@NotNull OutputStream writer, int int32) {
        Companion.sendInt32(writer, int32);
    }

    @JvmStatic
    public static final void sendInt64(@NotNull OutputStream writer, long int64) {
        Companion.sendInt64(writer, int64);
    }

    @JvmStatic
    public static final void sendUInt64-2TYgG_w(@NotNull OutputStream writer, long uint64) {
        Companion.sendUInt64-2TYgG_w(writer, uint64);
    }

    @JvmStatic
    public static final void sendArrayInt32(@NotNull OutputStream writer, @NotNull Integer[] array) {
        Companion.sendArrayInt32(writer, array);
    }

    @JvmStatic
    public static final void sendString(@NotNull OutputStream writer, @NotNull String string) {
        Companion.sendString(writer, string);
    }

    @JvmStatic
    public static final boolean receiveBool(@NotNull InputStream reader) {
        return Companion.receiveBool(reader);
    }

    @JvmStatic
    public static final byte receiveUInt8-Wa3L5BU(@NotNull InputStream reader) {
        return Companion.receiveUInt8-Wa3L5BU(reader);
    }

    @JvmStatic
    public static final short receiveInt16(@NotNull InputStream reader) {
        return Companion.receiveInt16(reader);
    }

    @JvmStatic
    public static final int receiveInt32(@NotNull InputStream reader) {
        return Companion.receiveInt32(reader);
    }

    @JvmStatic
    public static final long receiveInt64(@NotNull InputStream reader) {
        return Companion.receiveInt64(reader);
    }

    @JvmStatic
    public static final long receiveUInt64-I7RO_PI(@NotNull InputStream reader) {
        return Companion.receiveUInt64-I7RO_PI(reader);
    }

    @JvmStatic
    @NotNull
    public static final UByte[] receiveArrayUInt8(@NotNull InputStream reader) {
        return Companion.receiveArrayUInt8(reader);
    }

    @JvmStatic
    @NotNull
    public static final ULong[] receiveArrayUInt64(@NotNull InputStream reader) {
        return Companion.receiveArrayUInt64(reader);
    }

    @JvmStatic
    @NotNull
    public static final String receiveString(@NotNull InputStream reader) {
        return Companion.receiveString(reader);
    }

    @JvmStatic
    @NotNull
    public static final byte[] receiveNBytes(@NotNull InputStream reader, int n) {
        return Companion.receiveNBytes(reader, n);
    }

    @JvmStatic
    private static final int bitCastToInt(short $this$bitCastToInt) {
        return Message.Companion.bitCastToInt($this$bitCastToInt);
    }

    @JvmStatic
    private static final long bitCastToLong(int $this$bitCastToLong) {
        return Message.Companion.bitCastToLong($this$bitCastToLong);
    }

    @JvmStatic
    private static final long bitCastToULong-I7RO_PI(int $this$bitCastToULong_u2dI7RO_PI) {
        return Message.Companion.bitCastToULong-I7RO_PI($this$bitCastToULong_u2dI7RO_PI);
    }

    @JvmStatic
    private static final int bitCastToInt(long $this$bitCastToInt) {
        return Message.Companion.bitCastToInt($this$bitCastToInt);
    }

    @JvmStatic
    private static final int bitCastToInt-VKZWuLQ(long $this$bitCastToInt_u2dVKZWuLQ) {
        return Message.Companion.bitCastToInt-VKZWuLQ($this$bitCastToInt_u2dVKZWuLQ);
    }

    @JvmStatic
    private static final short bitCastToShort(int $this$bitCastToShort) {
        return Message.Companion.bitCastToShort($this$bitCastToShort);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001d\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004H\u0007\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\rH\u0007J\u0018\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u000fH\u0007J\u0018\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0011H\u0007J\u0018\u0010+\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010,\u001a\u00020\u0013H\u0007J\u0018\u0010-\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0018H\u0007J\"\u0010/\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00100\u001a\u00020\u0005H\u0007\u00f8\u0001\u0001\u00a2\u0006\u0004\b1\u00102J\f\u00103\u001a\u00020\u0011*\u00020\u0013H\u0003J\f\u00103\u001a\u00020\u0011*\u00020\u000fH\u0003J\u0016\u00103\u001a\u00020\u0011*\u00020\u0005H\u0003\u00f8\u0001\u0001\u00a2\u0006\u0004\b4\u00105J\f\u00106\u001a\u00020\u0013*\u00020\u0011H\u0003J\f\u00107\u001a\u00020\u000f*\u00020\u0011H\u0003J\u0019\u00108\u001a\u00020\u0005*\u00020\u0011H\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b9\u0010:\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006;"}, d2={"Lcom/jetbrains/rider/cpp/livePP/msg/Message$Companion;", "", "()V", "receiveArrayUInt64", "", "Lkotlin/ULong;", "reader", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)[Lkotlin/ULong;", "receiveArrayUInt8", "Lkotlin/UByte;", "(Ljava/io/InputStream;)[Lkotlin/UByte;", "receiveBool", "", "receiveInt16", "", "receiveInt32", "", "receiveInt64", "", "receiveNBytes", "", "n", "receiveString", "", "receiveUInt64", "receiveUInt64-I7RO_PI", "(Ljava/io/InputStream;)J", "receiveUInt8", "receiveUInt8-Wa3L5BU", "(Ljava/io/InputStream;)B", "sendArrayInt32", "", "writer", "Ljava/io/OutputStream;", "array", "(Ljava/io/OutputStream;[Ljava/lang/Integer;)V", "sendBool", "bool", "sendInt16", "int16", "sendInt32", "int32", "sendInt64", "int64", "sendString", "string", "sendUInt64", "uint64", "sendUInt64-2TYgG_w", "(Ljava/io/OutputStream;J)V", "bitCastToInt", "bitCastToInt-VKZWuLQ", "(J)I", "bitCastToLong", "bitCastToShort", "bitCastToULong", "bitCastToULong-I7RO_PI", "(I)J", "intellij.rider.plugins.cpp"})
    @SourceDebugExtension(value={"SMAP\nMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Message.kt\ncom/jetbrains/rider/cpp/livePP/msg/Message$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,180:1\n13309#2,2:181\n*S KotlinDebug\n*F\n+ 1 Message.kt\ncom/jetbrains/rider/cpp/livePP/msg/Message$Companion\n*L\n58#1:181,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void sendBool(@NotNull OutputStream writer, boolean bool) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            int value = bool ? 1 : 0;
            writer.write(value);
        }

        @JvmStatic
        public final void sendInt16(@NotNull OutputStream writer, short int16) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            int value = this.bitCastToInt(int16);
            int byte1 = value >>> 0 & 0xFF;
            int byte2 = value >>> 8 & 0xFF;
            writer.write(byte1);
            writer.write(byte2);
        }

        @JvmStatic
        public final void sendInt32(@NotNull OutputStream writer, int int32) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            int short1 = int32 >>> 0 & 0xFFFF;
            int short2 = int32 >>> 16 & 0xFFFF;
            this.sendInt16(writer, this.bitCastToShort(short1));
            this.sendInt16(writer, this.bitCastToShort(short2));
        }

        @JvmStatic
        public final void sendInt64(@NotNull OutputStream writer, long int64) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            long int1 = int64 >>> 0 & 0xFFFFFFFFL;
            long int2 = int64 >>> 32 & 0xFFFFFFFFL;
            this.sendInt32(writer, this.bitCastToInt(int1));
            this.sendInt32(writer, this.bitCastToInt(int2));
        }

        @JvmStatic
        public final void sendUInt64-2TYgG_w(@NotNull OutputStream writer, long uint64) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            long int1 = ULong.constructor-impl((long)(ULong.constructor-impl((long)(uint64 >>> 0)) & 0xFFFFFFFFL));
            long int2 = ULong.constructor-impl((long)(ULong.constructor-impl((long)(uint64 >>> 32)) & 0xFFFFFFFFL));
            this.sendInt32(writer, this.bitCastToInt-VKZWuLQ(int1));
            this.sendInt32(writer, this.bitCastToInt-VKZWuLQ(int2));
        }

        @JvmStatic
        public final void sendArrayInt32(@NotNull OutputStream writer, @NotNull Integer[] array) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.sendInt16(writer, (short)array.length);
            Integer[] $this$forEach$iv = array;
            boolean $i$f$forEach = false;
            for (Integer element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                Companion.sendInt32(writer, it);
            }
        }

        @JvmStatic
        public final void sendString(@NotNull OutputStream writer, @NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byteArray = byArray;
            this.sendInt16(writer, (short)byteArray.length);
            writer.write(byteArray);
        }

        @JvmStatic
        public final boolean receiveBool(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int bool = reader.read();
            if (bool == -1) {
                throw new LivePPException("No data available");
            }
            return bool != 0;
        }

        @JvmStatic
        public final byte receiveUInt8-Wa3L5BU(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int n = reader.read();
            if (n == -1) {
                throw new LivePPException("No data available");
            }
            return UByte.constructor-impl((byte)((byte)n));
        }

        @JvmStatic
        public final short receiveInt16(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int byte1 = reader.read();
            int byte2 = reader.read();
            if (byte1 == -1 || byte2 == -1) {
                throw new LivePPException("No data available");
            }
            return this.bitCastToShort(byte2 << 8 | byte1 << 0);
        }

        @JvmStatic
        public final int receiveInt32(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int short1 = this.bitCastToInt(this.receiveInt16(reader));
            int short2 = this.bitCastToInt(this.receiveInt16(reader));
            return short2 << 16 | short1 << 0;
        }

        @JvmStatic
        public final long receiveInt64(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            long int1 = this.bitCastToLong(this.receiveInt32(reader));
            long int2 = this.bitCastToLong(this.receiveInt32(reader));
            return int2 << 32 | int1 << 0;
        }

        @JvmStatic
        public final long receiveUInt64-I7RO_PI(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            long int1 = this.bitCastToULong-I7RO_PI(this.receiveInt32(reader));
            long int2 = this.bitCastToULong-I7RO_PI(this.receiveInt32(reader));
            return ULong.constructor-impl((long)(ULong.constructor-impl((long)(int2 << 32)) | ULong.constructor-impl((long)(int1 << 0))));
        }

        @JvmStatic
        @NotNull
        public final UByte[] receiveArrayUInt8(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int len = this.receiveInt16(reader);
            int n = 0;
            UByte[] uByteArray = new UByte[len];
            while (n < len) {
                int n2 = n++;
                uByteArray[n2] = UByte.box-impl((byte)Companion.receiveUInt8-Wa3L5BU(reader));
            }
            return uByteArray;
        }

        @JvmStatic
        @NotNull
        public final ULong[] receiveArrayUInt64(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            int len = this.receiveInt16(reader);
            int n = 0;
            ULong[] uLongArray = new ULong[len];
            while (n < len) {
                int n2 = n++;
                uLongArray[n2] = ULong.box-impl((long)Companion.receiveUInt64-I7RO_PI(reader));
            }
            return uLongArray;
        }

        @JvmStatic
        @NotNull
        public final String receiveString(@NotNull InputStream reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            short len = this.receiveInt16(reader);
            byte[] content = this.receiveNBytes(reader, len);
            return new String(content, Charsets.UTF_8);
        }

        @JvmStatic
        @NotNull
        public final byte[] receiveNBytes(@NotNull InputStream reader, int n) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            byte[] bytes = new byte[n];
            int result = reader.readNBytes(bytes, 0, n);
            if (result != n) {
                throw new LivePPException("Received only " + result + " bytes while expected " + n + " bytes");
            }
            return bytes;
        }

        @JvmStatic
        private final int bitCastToInt(short $this$bitCastToInt) {
            return $this$bitCastToInt & 0xFFFF;
        }

        @JvmStatic
        private final long bitCastToLong(int $this$bitCastToLong) {
            return (long)$this$bitCastToLong & 0xFFFFFFFFL;
        }

        @JvmStatic
        private final long bitCastToULong-I7RO_PI(int $this$bitCastToULong_u2dI7RO_PI) {
            return ULong.constructor-impl((long)this.bitCastToLong($this$bitCastToULong_u2dI7RO_PI));
        }

        @JvmStatic
        private final int bitCastToInt(long $this$bitCastToInt) {
            return (int)$this$bitCastToInt;
        }

        @JvmStatic
        private final int bitCastToInt-VKZWuLQ(long $this$bitCastToInt_u2dVKZWuLQ) {
            return (int)$this$bitCastToInt_u2dVKZWuLQ;
        }

        @JvmStatic
        private final short bitCastToShort(int $this$bitCastToShort) {
            return (short)$this$bitCastToShort;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

