/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.livePP;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.cpp.livePP.ClientHandler;
import com.jetbrains.rider.cpp.livePP.PortRegistrar;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/cpp/livePP/Server;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "()V", "clients", "", "", "Lcom/jetbrains/rider/cpp/livePP/ClientHandler;", "mutex", "Ljava/lang/Object;", "nextClientId", "portRegistrar", "Lcom/jetbrains/rider/cpp/livePP/PortRegistrar;", "server", "Ljava/net/ServerSocket;", "serverPort", "dispose", "", "initialize", "Companion", "Initializer", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/cpp/livePP/Server\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n13#2:128\n*S KotlinDebug\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/cpp/livePP/Server\n*L\n18#1:128\n*E\n"})
public final class Server
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PortRegistrar portRegistrar = new PortRegistrar(this.getServiceLifetime());
    @NotNull
    private final Object mutex = new Object();
    @NotNull
    private final Map<Integer, ClientHandler> clients = new LinkedHashMap();
    @Nullable
    private ServerSocket server;
    private int serverPort = -1;
    private int nextClientId;
    private static final int MAX_NUMBER_OF_ATTEMPTS = 10;
    @NotNull
    private static final Logger LOG;

    private final void initialize() {
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"LivePP.Server", (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ Server this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void invoke() {
                try {
                    Object object;
                    Object object2 = Server.access$getMutex$p(this.this$0);
                    Object object3 = this.this$0;
                    Object object4 = object2;
                    synchronized (object4) {
                        boolean bl = false;
                        int suggestedPort = Server.access$getPortRegistrar$p(object3).getServerPort();
                        for (int i = 1; i < 11; ++suggestedPort, ++i) {
                            try {
                                Server.access$setServer$p(object3, new ServerSocket(suggestedPort, 0, InetAddress.getLoopbackAddress()));
                                ServerSocket serverSocket = Server.access$getServer$p(object3);
                                Intrinsics.checkNotNull((Object)serverSocket);
                                Server.access$setServerPort$p(object3, serverSocket.getLocalPort());
                                Server.access$getLOG$cp().assertTrue(suggestedPort == Server.access$getServerPort$p(object3));
                                Server.access$getLOG$cp().info("Server is running on port " + Server.access$getServerPort$p(object3));
                                break;
                            }
                            catch (BindException e) {
                                Server.access$getLOG$cp().info("Failed to open socket on " + suggestedPort + " port " + e.getMessage());
                                continue;
                            }
                        }
                        if (Server.access$getServerPort$p(object3) == -1) {
                            Server.access$getLOG$cp().error("Failed to open a port in 10 attempts");
                            return;
                        }
                        try {
                            Server.access$getPortRegistrar$p(object3).registerPort(Server.access$getServerPort$p(object3));
                        }
                        catch (Exception e) {
                            Server.access$getLOG$cp().error("Failed to write port number to the file", (Throwable)e);
                            ServerSocket serverSocket = Server.access$getServer$p(object3);
                            Intrinsics.checkNotNull((Object)serverSocket);
                            serverSocket.close();
                            Server.access$setServerPort$p(object3, -1);
                            return;
                        }
                        object = Unit.INSTANCE;
                    }
                    while (true) {
                        ServerSocket serverSocket = Server.access$getServer$p(this.this$0);
                        Intrinsics.checkNotNull((Object)serverSocket);
                        Socket clientSocket = serverSocket.accept();
                        object3 = Server.access$getMutex$p(this.this$0);
                        object4 = this.this$0;
                        object = object3;
                        synchronized (object) {
                            boolean bl = false;
                            int e = Server.access$getNextClientId$p((Server)((Object)object4));
                            Server.access$setNextClientId$p((Server)((Object)object4), e + 1);
                            int clientId = e;
                            Server.access$getLOG$cp().info("Client connected: " + clientSocket.getPort() + ". Client number: " + clientId);
                            Intrinsics.checkNotNull((Object)clientSocket);
                            ClientHandler client = new ClientHandler(clientSocket, clientId);
                            Integer n = clientId;
                            Server.access$getClients$p((Server)((Object)object4)).put(n, client);
                            SourceExKt.adviseEternal((ISource)((ISource)client.getOnClose()), (Function1)((Function1)new Function1<ClientHandler, Unit>((Server)((Object)object4)){
                                final /* synthetic */ Server this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final void invoke(@NotNull ClientHandler it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    Object object = Server.access$getMutex$p(this.this$0);
                                    Server server = this.this$0;
                                    Object object2 = object;
                                    synchronized (object2) {
                                        boolean bl = false;
                                        Server.access$getClients$p(server).remove(it.getId());
                                        Unit unit = Unit.INSTANCE;
                                    }
                                }
                            }));
                            Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)("LivePP.Client." + clientId), (int)0, (Function0)((Function0)new Function0<Unit>(client){
                                final /* synthetic */ ClientHandler $client;
                                {
                                    this.$client = $client;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$client.start();
                                }
                            }), (int)21, null);
                        }
                    }
                }
                catch (SocketException e) {
                    Server.access$getLOG$cp().info("LivePP-Server-SocketException: " + e.getMessage());
                    return;
                }
                catch (Exception e) {
                    Server.access$getLOG$cp().error((Throwable)e);
                }
            }
        }), (int)21, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            LOG.info("Disposing server and socket " + (this.server == null ? "is null" : "is not null"));
            for (ClientHandler client : CollectionsKt.toList((Iterable)this.clients.values())) {
                client.close();
            }
            try {
                if (this.serverPort != -1) {
                    this.portRegistrar.unregisterPort(this.serverPort);
                    this.serverPort = -1;
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            try {
                ServerSocket serverSocket = this.server;
                if (serverSocket != null) {
                    serverSocket.close();
                }
                this.server = null;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ Object access$getMutex$p(Server $this) {
        return $this.mutex;
    }

    public static final /* synthetic */ ServerSocket access$getServer$p(Server $this) {
        return $this.server;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ PortRegistrar access$getPortRegistrar$p(Server $this) {
        return $this.portRegistrar;
    }

    public static final /* synthetic */ void access$setServer$p(Server $this, ServerSocket serverSocket) {
        $this.server = serverSocket;
    }

    public static final /* synthetic */ void access$setServerPort$p(Server $this, int n) {
        $this.serverPort = n;
    }

    public static final /* synthetic */ int access$getServerPort$p(Server $this) {
        return $this.serverPort;
    }

    public static final /* synthetic */ int access$getNextClientId$p(Server $this) {
        return $this.nextClientId;
    }

    public static final /* synthetic */ void access$setNextClientId$p(Server $this, int n) {
        $this.nextClientId = n;
    }

    public static final /* synthetic */ Map access$getClients$p(Server $this) {
        return $this.clients;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Server.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/cpp/livePP/Server$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAX_NUMBER_OF_ATTEMPTS", "", "intellij.rider.plugins.cpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/cpp/livePP/Server$Initializer;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.plugins.cpp"})
    @SourceDebugExtension(value={"SMAP\nServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/cpp/livePP/Server$Initializer\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,127:1\n40#2,3:128\n*S KotlinDebug\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/cpp/livePP/Server$Initializer\n*L\n122#1:128,3\n*E\n"})
    public static final class Initializer
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (Registry.is((String)"rider.cpp.enable.message.protocol", (boolean)true) && SystemInfo.isWindows) {
                boolean $i$f$service = false;
                Class<Server> serviceClass$iv = Server.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                ((Server)((Object)object)).initialize();
            }
            return Unit.INSTANCE;
        }
    }
}

