/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.livePP;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0004J\b\u0010\u0012\u001a\u00020\bH\u0014J\b\u0010\u0013\u001a\u00020\bH\u0004J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0014J\u0006\u0010\u0016\u001a\u00020\u0011J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0019\u001a\u00020\bH\u0004J\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011J\u000e\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/cpp/livePP/PortRegistrar;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "createLockFile", "", "file", "Ljava/nio/file/Path;", "shouldWait", "doCleanup", "", "fileContent", "", "Lcom/jetbrains/rider/cpp/livePP/PortRegistrar$FileEntry;", "getLockFilePath", "getMyProcessId", "", "getPortsDirectory", "getPortsFilePath", "getRiderPids", "", "getServerPort", "readAndParseFile", "", "portsFile", "registerPort", "port", "unregisterPort", "Companion", "FileEntry", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nPortRegistrar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortRegistrar.kt\ncom/jetbrains/rider/cpp/livePP/PortRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,141:1\n1549#2:142\n1620#2,3:143\n1549#2:146\n1620#2,3:147\n1549#2:150\n1620#2,3:151\n1208#2,2:157\n1238#2,4:159\n3792#3:154\n4307#3,2:155\n526#4:163\n511#4,6:164\n125#5:170\n152#5,3:171\n13#6:174\n*S KotlinDebug\n*F\n+ 1 PortRegistrar.kt\ncom/jetbrains/rider/cpp/livePP/PortRegistrar\n*L\n29#1:142\n29#1:143,3\n45#1:146\n45#1:147,3\n61#1:150\n61#1:151,3\n120#1:157,2\n120#1:159,4\n116#1:154\n116#1:155,2\n122#1:163\n122#1:164,6\n122#1:170\n122#1:171,3\n13#1:174\n*E\n"})
public class PortRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private static final Logger LOG;

    public PortRegistrar(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
    }

    public final int getServerPort() {
        return this.getMyProcessId() % 15000 + 50000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void registerPort(int port) {
        Path lockFile = this.getLockFilePath();
        boolean createLockResult = this.createLockFile(lockFile, true);
        LOG.assertTrue(createLockResult);
        try {
            void $this$mapTo$iv$iv;
            Path portsFile = this.getPortsFilePath();
            List fileContent = CollectionsKt.toMutableList((Collection)this.readAndParseFile(portsFile));
            this.doCleanup(fileContent);
            fileContent.add(new FileEntry(port, this.getMyProcessId()));
            Path path = lockFile;
            OpenOption[] $this$map$iv = (OpenOption[])fileContent;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FileEntry fileEntry = (FileEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toStr());
            }
            Iterable iterable = (List)destination$iv$iv;
            objectArray = new OpenOption[]{};
            CopyOption[] copyOptionArray = Charsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, (Charset)copyOptionArray, Arrays.copyOf(objectArray, objectArray.length)), (String)"write(...)");
            path = lockFile;
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            objectArray = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, portsFile, (CopyOption[])Arrays.copyOf(objectArray, objectArray.length)), (String)"move(...)");
        }
        finally {
            Files.deleteIfExists(lockFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void unregisterPort(int port) {
        Path lockFile = this.getLockFilePath();
        boolean createLockResult = this.createLockFile(lockFile, false);
        if (createLockResult) {
            try {
                void $this$mapTo$iv$iv;
                Path portsFile = this.getPortsFilePath();
                List fileContent = CollectionsKt.toMutableList((Collection)this.readAndParseFile(portsFile));
                fileContent.removeIf(arg_0 -> PortRegistrar.unregisterPort$lambda$1((Function1)new Function1<FileEntry, Boolean>(port){
                    final /* synthetic */ int $port;
                    {
                        this.$port = $port;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull FileEntry it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.getPort() == this.$port;
                    }
                }, arg_0));
                Path path = lockFile;
                OpenOption[] $this$map$iv = (OpenOption[])fileContent;
                boolean $i$f$map = false;
                Object[] objectArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FileEntry fileEntry = (FileEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.toStr());
                }
                Iterable iterable = (List)destination$iv$iv;
                objectArray = new OpenOption[]{};
                CopyOption[] copyOptionArray = Charsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)Files.write(path, (Iterable<? extends CharSequence>)iterable, (Charset)copyOptionArray, Arrays.copyOf(objectArray, objectArray.length)), (String)"write(...)");
                path = lockFile;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                objectArray = copyOptionArray;
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path, portsFile, (CopyOption[])Arrays.copyOf(objectArray, objectArray.length)), (String)"move(...)");
            }
            finally {
                Files.deleteIfExists(lockFile);
            }
        }
    }

    private final void doCleanup(List<FileEntry> fileContent) {
        Set<Integer> riderPids = this.getRiderPids();
        fileContent.removeIf(arg_0 -> PortRegistrar.doCleanup$lambda$3((Function1)new Function1<FileEntry, Boolean>(riderPids){
            final /* synthetic */ Set<Integer> $riderPids;
            {
                this.$riderPids = $riderPids;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FileEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !this.$riderPids.contains(it.getPid());
            }
        }, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<FileEntry> readAndParseFile(@NotNull Path portsFile) {
        Intrinsics.checkNotNullParameter((Object)portsFile, (String)"portsFile");
        try {
            void $this$mapTo$iv$iv;
            Path path = portsFile;
            List<String> list = Files.readAllLines(path, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileEntry.Companion.parse((String)it));
            }
            return (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to parse file: will ignore its content. " + e.getMessage());
            return CollectionsKt.emptyList();
        }
    }

    private final boolean createLockFile(Path file, boolean shouldWait) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            return true;
        }
        if (!shouldWait) {
            return false;
        }
        ThreadingAssertions.assertBackgroundThread();
        for (int i = 1; i < 7; ++i) {
            Thread.sleep(50L);
            RLifetimeKt.throwIfNotAlive((Lifetime)this.lifetime);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
            return true;
        }
        LOG.warn("Lock file still exists after 300ms. That should not happen. Deleting it.");
        Files.deleteIfExists(file);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        return true;
    }

    @NotNull
    protected final Path getPortsFilePath() {
        Path path = this.getPortsDirectory().resolve("ports.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    protected final Path getLockFilePath() {
        Path path = this.getPortsDirectory().resolve("ports.lock");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    protected final int getMyProcessId() {
        return OSProcessUtil.getCurrentProcessId();
    }

    @NotNull
    protected Path getPortsDirectory() {
        Path path;
        String homeDirectory = System.getProperty("user.home");
        if (SystemInfo.isWindows) {
            Path path2 = Paths.get(homeDirectory + "/AppData/Local/JetBrains/Rider/LivePP/", new String[0]);
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        } else if (SystemInfo.isMac) {
            Path path3 = Paths.get(homeDirectory + "/Library/Application Support/JetBrains/Rider/LivePP/", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        } else if (SystemInfo.isLinux) {
            Path path4 = Paths.get(homeDirectory + "/.config/JetBrains/Rider/LivePP/", new String[0]);
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        } else {
            throw new NotImplementedError(null, 1, null);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<Integer> getRiderPids() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Object $this$filterTo$iv$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        ProcessInfo it2;
        void $this$filterTo$iv$iv2;
        ProcessInfo[] processInfoArray = OSProcessUtil.getProcessList();
        Intrinsics.checkNotNullExpressionValue((Object)processInfoArray, (String)"getProcessList(...)");
        Object $this$filter$iv = processInfoArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (ProcessInfo)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getExecutableName(), (Object)"rider64.exe")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it2 = (ProcessInfo)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            it2 = (ProcessInfo)element$iv$iv;
            Integer n = it2.getPid();
            boolean bl2 = false;
            Integer n2 = it2.getParentPid();
            object.put(n, n2);
        }
        Map riderPidToPpid = destination$iv$iv2;
        $this$filter$iv = riderPidToPpid;
        $i$f$filter = false;
        Object capacity$iv22 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!riderPidToPpid.containsKey(it.getValue()))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((Number)it.getKey()).intValue());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final boolean unregisterPort$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean doCleanup$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PortRegistrar.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/cpp/livePP/PortRegistrar$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.cpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/cpp/livePP/PortRegistrar$FileEntry;", "", "port", "", "pid", "(II)V", "getPid", "()I", "getPort", "toStr", "", "Companion", "intellij.rider.plugins.cpp"})
    protected static final class FileEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int port;
        private final int pid;

        public FileEntry(int port, int pid) {
            this.port = port;
            this.pid = pid;
        }

        public final int getPort() {
            return this.port;
        }

        public final int getPid() {
            return this.pid;
        }

        @NotNull
        public final String toStr() {
            return this.port + " " + this.pid;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/cpp/livePP/PortRegistrar$FileEntry$Companion;", "", "()V", "parse", "Lcom/jetbrains/rider/cpp/livePP/PortRegistrar$FileEntry;", "str", "", "intellij.rider.plugins.cpp"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FileEntry parse(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                char[] cArray = new char[]{' '};
                List parts = StringsKt.split$default((CharSequence)str, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                if (parts.size() != 2) {
                    throw new IllegalArgumentException("Invalid file format: '" + str + "'");
                }
                return new FileEntry(Integer.parseInt((String)parts.get(0)), Integer.parseInt((String)parts.get(1)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

