/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.unreal;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.IdFilter;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.UnrealModel;
import com.jetbrains.rd.ide.model.UnrealModel_PregeneratedKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/cpp/debugger/unreal/RiderCppUE4LLDBConfigurator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "getUE4LLDBFormatterFilePaths", "", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.cpp"})
public final class RiderCppUE4LLDBConfigurator
implements CidrDebugProcessConfigurator {
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        LLDBDriverConfiguration lLDBDriverConfiguration = debuggerDriverConfiguration instanceof LLDBDriverConfiguration ? (LLDBDriverConfiguration)debuggerDriverConfiguration : null;
        if (lLDBDriverConfiguration == null) {
            return;
        }
        LLDBDriverConfiguration driverConfiguration = lLDBDriverConfiguration;
        Project project = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        UnrealModel unrealModel = UnrealModel_PregeneratedKt.getUnrealModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
        if (BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)unrealModel.isUnrealSolution()))) {
            if (driverConfiguration.getHostMachine().getOSType() == OSType.WIN) {
                process.postCommand(RiderCppUE4LLDBConfigurator::configure$lambda$0);
            } else {
                Project project2 = process.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                List<String> formatterFilePaths = this.getUE4LLDBFormatterFilePaths(project2);
                process.postCommand(arg_0 -> RiderCppUE4LLDBConfigurator.configure$lambda$1(formatterFilePaths, arg_0));
            }
        }
    }

    private final List<String> getUE4LLDBFormatterFilePaths(Project project) {
        List result = new ArrayList();
        Object[] objectArray = new String[]{"UE4DataFormatters.py", "UEDataFormatters.py", "UE4DataFormatters_2ByteChars.py", "UEDataFormatters_2ByteChars.py"};
        Set formatterNames = SetsKt.mutableSetOf((Object[])objectArray);
        FilenameIndex.processFilesByNames((Set)formatterNames, (boolean)false, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project), (IdFilter)new IdFilter(){

            public boolean containsFileId(int id) {
                return true;
            }
        }, arg_0 -> RiderCppUE4LLDBConfigurator.getUE4LLDBFormatterFilePaths$lambda$2((Function1)new Function1<VirtualFile, Boolean>((List<String>)result){
            final /* synthetic */ List<String> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(VirtualFile file) {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this.$result.add(string);
                return true;
            }
        }, arg_0));
        return result;
    }

    private static final void configure$lambda$0(DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.executeInterpreterCommand("command script import jb_unreal_blueprint_mixedstack");
    }

    private static final void configure$lambda$1(List $formatterFilePaths, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)$formatterFilePaths, (String)"$formatterFilePaths");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        driver.executeInterpreterCommand("settings set target.inline-breakpoint-strategy always");
        for (String path : $formatterFilePaths) {
            driver.executeInterpreterCommand("command script import \"" + path + "\"");
        }
    }

    private static final boolean getUE4LLDBFormatterFilePaths$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

