/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.modulesView;

import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.rd.util.collections.SynchronizedList;
import com.jetbrains.rd.util.reactive.ViewableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\"\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\"\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"&\u0010\u0000\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\t0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"myModuleListKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLModule;", "", "myModuleLoadingOrderCounterKey", "Ljava/util/concurrent/atomic/AtomicInteger;", "myModuleSetKey", "", "", "myProcessSyncObjectKey", "", "createOrGetModuleList", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "getModules", "getModulesMap", "getOrderingCounter", "getProcessSyncObject", "intellij.rider.plugins.cpp"})
public final class ProcessUtilsFuncsKt {
    @NotNull
    private static final Key<ViewableList<Pair<LLModule, Integer>>> myModuleListKey = new Key("riderDebuggingModuleList");
    @NotNull
    private static final Key<Map<String, Integer>> myModuleSetKey = new Key("riderDebuggingModuleSetWithCounter");
    @NotNull
    private static final Key<AtomicInteger> myModuleLoadingOrderCounterKey = new Key("riderDebuggingModuleLoadingOrderCounter");
    @NotNull
    private static final Key<Object> myProcessSyncObjectKey = new Key("riderDebuggingProcessSyncObject");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ViewableList<Pair<LLModule, Integer>> createOrGetModuleList(@NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        ViewableList existingModuleList = (ViewableList)debugProcess.getUserData(myModuleListKey);
        if (existingModuleList != null) {
            return existingModuleList;
        }
        Object object = ProcessUtilsFuncsKt.getProcessSyncObject(debugProcess);
        synchronized (object) {
            ViewableList moduleList;
            block5: {
                boolean bl = false;
                ViewableList viewableList = moduleList = (ViewableList)debugProcess.getUserData(myModuleListKey);
                if (viewableList == null) break block5;
                ViewableList viewableList2 = viewableList;
                return viewableList2;
            }
            moduleList = new ViewableList((List)new SynchronizedList());
            debugProcess.putUserData(myModuleListKey, (Object)moduleList);
            debugProcess.putUserData(myModuleLoadingOrderCounterKey, (Object)new AtomicInteger(1));
            debugProcess.putUserData(myModuleSetKey, (Object)MapsKt.toMutableMap((Map)MapsKt.emptyMap()));
            ViewableList viewableList = moduleList;
            return viewableList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Object getProcessSyncObject(@NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Object savedSyncObject = debugProcess.getUserData(myProcessSyncObjectKey);
        if (savedSyncObject != null) {
            return savedSyncObject;
        }
        CidrDebugProcess cidrDebugProcess = debugProcess;
        synchronized (cidrDebugProcess) {
            block5: {
                Object syncObject;
                boolean bl = false;
                Object object = syncObject = debugProcess.getUserData(myProcessSyncObjectKey);
                if (object == null) break block5;
                Object object2 = object;
                return object2;
            }
            Object newObject = new Object();
            debugProcess.putUserData(myProcessSyncObjectKey, newObject);
            Object object = newObject;
            return object;
        }
    }

    @NotNull
    public static final ViewableList<Pair<LLModule, Integer>> getModules(@NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        return ProcessUtilsFuncsKt.createOrGetModuleList(debugProcess);
    }

    @NotNull
    public static final Map<String, Integer> getModulesMap(@NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Map map = (Map)debugProcess.getUserData(myModuleSetKey);
        if (map == null) {
            throw new IllegalStateException("Module map is not initialized".toString());
        }
        return map;
    }

    @NotNull
    public static final AtomicInteger getOrderingCounter(@NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        AtomicInteger atomicInteger = (AtomicInteger)debugProcess.getUserData(myModuleLoadingOrderCounterKey);
        if (atomicInteger == null) {
            throw new IllegalStateException("Module loading order counter is not initialized".toString());
        }
        return atomicInteger;
    }
}

