/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileProvider;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider;", "Lcom/jetbrains/cidr/execution/debugger/formatters/natvis/NatvisFileProvider;", "()V", "getVisualStudioRootDirectory", "Ljava/io/File;", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "populate", "", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "fileList", "", "", "Companion", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nRiderCppNatvisFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppNatvisFileProvider.kt\ncom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1549#2:97\n1620#2,3:98\n1549#2:101\n1620#2,3:102\n*S KotlinDebug\n*F\n+ 1 RiderCppNatvisFileProvider.kt\ncom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider\n*L\n29#1:97\n29#1:98,3\n31#1:101\n31#1:102,3\n*E\n"})
public final class RiderCppNatvisFileProvider
implements NatvisFileProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = CidrDebuggerLog.LOG;

    public void populate(@NotNull CidrDebugProcess debugProcess, @NotNull List<String> fileList) {
        File it;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Object object;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter(fileList, (String)"fileList");
        logger.debug("NatvisFileProvider: Looking for visual studio debugger package natvis files");
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        File vsRootDir = this.getVisualStudioRootDirectory(SolutionHostExtensionsKt.getSolution((Project)project));
        if (vsRootDir == null) {
            logger.warn("NatvisFileProvider: Visual studio root directory was not found: check the path to the selected msbuild");
            return;
        }
        logger.debug("NatvisFileProvider: Detected visual studio root directory: '" + vsRootDir + "'");
        File vsVisualizersDir = Companion.getVSDebuggerVisualizersDir(vsRootDir);
        if (vsVisualizersDir == null) {
            logger.warn("NatvisFileProvider: Folder with visual studio natvis files was not found");
            return;
        }
        List<File> foundNatvisFiles = Companion.getNatvisFiles(vsVisualizersDir);
        if (foundNatvisFiles.isEmpty()) {
            logger.debug("NatvisFileProvider: Natvis files not found");
        } else {
            Collection<String> collection;
            Iterable iterable = foundNatvisFiles;
            int n = foundNatvisFiles.size();
            object = logger;
            $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                File file = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            object.debug("NatvisFileProvider: Found natvis " + n + " files: '" + (List)collection + "'");
        }
        $this$map$iv = foundNatvisFiles;
        object = fileList;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAbsolutePath());
        }
        object.addAll((List)destination$iv$iv);
    }

    private final File getVisualStudioRootDirectory(Solution solution) {
        String string = (String)solution.getActiveMsBuildPath().getValue();
        if (string == null) {
            return null;
        }
        String msBuildPath = string;
        File msBuildPathFile = new File(msBuildPath);
        if (!msBuildPathFile.exists()) {
            return null;
        }
        Object[] objectArray = new String[]{"Preview", "Community", "Professional", "Enterprise", "Build Tools"};
        Object[] vsTypes = objectArray;
        String string2 = msBuildPathFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (Intrinsics.areEqual((Object)string3, (Object)"msbuild.exe")) {
            File msBuildBin;
            String string4;
            Object object = msBuildPathFile.getParentFile();
            if (object != null && (object = ((File)object).getName()) != null) {
                String string5 = ((String)object).toLowerCase(Locale.ROOT);
                string4 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            } else {
                string4 = null;
            }
            if (Intrinsics.areEqual(string4, (Object)"bin")) {
                v6 = msBuildPathFile.getParentFile();
            } else {
                String string6;
                Object object2 = msBuildPathFile.getParentFile();
                if (object2 != null && (object2 = ((File)object2).getParentFile()) != null && (object2 = ((File)object2).getName()) != null) {
                    String string7 = ((String)object2).toLowerCase(Locale.ROOT);
                    string6 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                } else {
                    string6 = null;
                }
                if (Intrinsics.areEqual(string6, (Object)"bin")) {
                    File file = msBuildPathFile.getParentFile();
                    v6 = file != null ? file.getParentFile() : null;
                } else {
                    v6 = msBuildBin = null;
                }
            }
            if (msBuildBin != null) {
                File vsRoot;
                File file = msBuildBin.getParentFile();
                File file2 = file != null && (file = file.getParentFile()) != null ? file.getParentFile() : (vsRoot = null);
                if (vsRoot != null) {
                    if (!ArraysKt.contains((Object[])vsTypes, (Object)vsRoot.getName())) {
                        logger.warn("NatvisFileProvider: '" + vsRoot + "' is detected as suspicious visual studio root directory");
                    }
                    return vsRoot;
                }
            }
        }
        logger.warn("NatvisFileProvider: '" + msBuildPathFile + "' is not a msbuild bundled with visual studio. Couldn't find vs debugger package with bundled natvis files");
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "getNatvisFiles", "", "Ljava/io/File;", "visualizersDir", "getVSDebuggerVisualizersDir", "vsRootDir", "intellij.rider.plugins.cpp"})
    @SourceDebugExtension(value={"SMAP\nRiderCppNatvisFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCppNatvisFileProvider.kt\ncom/jetbrains/rider/cpp/debugger/RiderCppNatvisFileProvider$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<File> getNatvisFiles(@NotNull File visualizersDir) {
            List list;
            Intrinsics.checkNotNullParameter((Object)visualizersDir, (String)"visualizersDir");
            Object[] objectArray = visualizersDir.listFiles(Companion::getNatvisFiles$lambda$0);
            return objectArray != null && (list = ArraysKt.toList((Object[])objectArray)) != null ? list : CollectionsKt.emptyList();
        }

        @Nullable
        public final File getVSDebuggerVisualizersDir(@NotNull File vsRootDir) {
            File file;
            Intrinsics.checkNotNullParameter((Object)vsRootDir, (String)"vsRootDir");
            File packageDir = FilesKt.resolve((File)vsRootDir, (String)"Common7/Packages/Debugger/Visualizers");
            logger.debug("NatvisFileProvider: Looking for folder with packaged natvis: '" + packageDir + "'");
            File it = file = packageDir;
            boolean bl = false;
            return it.exists() ? file : null;
        }

        private static final boolean getNatvisFiles$lambda$0(File file) {
            Intrinsics.checkNotNull((Object)file);
            return Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"natvis");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

