/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.rider.cpp.debugger.RiderCppLLDBEvaluationContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppLLDBDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration;", "()V", "configureMSVCStepping", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "createDriver", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "createEvaluationContext", "Lcom/jetbrains/cidr/execution/debugger/backend/EvaluationContext;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "expirable", "Lcom/intellij/openapi/util/Expirable;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "cacheHolder", "Lcom/intellij/openapi/util/UserDataHolderEx;", "isContinueAfterAttachNeeded", "", "intellij.rider.plugins.cpp"})
public final class RiderCppLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) throws ExecutionException {
        LLDBDriver lLDBDriver;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        LLDBDriver lLDBDriver2 = super.createDriver(handler, architectureType);
        Intrinsics.checkNotNullExpressionValue((Object)lLDBDriver2, (String)"createDriver(...)");
        LLDBDriver it = lLDBDriver = lLDBDriver2;
        boolean bl = false;
        if (SystemInfo.isWindows) {
            this.configureMSVCStepping(it);
        }
        return lLDBDriver;
    }

    @NotNull
    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)cacheHolder, (String)"cacheHolder");
        return (EvaluationContext)new RiderCppLLDBEvaluationContext(driver, expirable, thread, frame, cacheHolder);
    }

    private final void configureMSVCStepping(LLDBDriver driver) {
        driver.setAutorunScriptName("jb_lldb_init");
        driver.setStepIntoClassName("jb_lldb_stepping.StepIn");
        driver.setStepIntoByInstructionClassName("jb_lldb_stepping.StepThroughInstruction");
        driver.setStepOverClassName("jb_lldb_stepping.StepOver");
        driver.setStepOverByInstructionClassName("jb_lldb_stepping.StepOverInstruction");
        driver.setStepOutClassName(null);
    }

    public boolean isContinueAfterAttachNeeded() {
        return !AdvancedSettings.Companion.getBoolean("rider.keep.process.suspended.after.attach");
    }
}

