/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProvider;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.indenter.TextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.RiderTextContent;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.session.CsTreeUtilsKt;
import com.jetbrains.rider.rdclient.languages.RiderBreakingWorkflowChangeInterceptor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpTypedHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "charTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.rider.languages"})
public final class CSharpTypedHandlerDelegate
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (c == ';' && file.getLanguage() == CSharpLanguage.INSTANCE && !editor2.isViewer() && document2.isWritable()) {
            String string = " \t";
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            CaretModel caretModel2 = caretModel;
            int n = CharArrayUtil.shiftForward((CharSequence)document2.getCharsSequence(), (int)caretModel2.getCurrentCaret().getOffset(), (String)string);
            if (n < document2.getTextLength() && document2.getCharsSequence().charAt(n) != '\n') {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            long l = document2.getLineNumber(caretModel2.getCurrentCaret().getOffset());
            RiderTextContent riderTextContent = new RiderTextContent(document2);
            int n2 = (int)riderTextContent.lineStartOffset(l);
            CharSequence charSequence = CsTreeUtilsKt.indentOfLine(TextContent.line$default(riderTextContent, l, false, 2, null));
            document2.replaceString(n2, n2 + charSequence.length(), (CharSequence)"");
            String string2 = new CSharpLineIndentProvider().getLineIndent(project, editor2, CSharpLanguage.INSTANCE, caretModel2.getCurrentCaret().getOffset());
            if (string2 == null) {
                document2.insertString(n2, charSequence);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            RiderBreakingWorkflowChangeInterceptor.Companion.guardChange(editor2, (Function0<Unit>)((Function0)new Function0<Unit>(document2, n2, string2){
                final /* synthetic */ Document $document;
                final /* synthetic */ int $lineStartOffset;
                final /* synthetic */ String $indent;
                {
                    this.$document = $document;
                    this.$lineStartOffset = $lineStartOffset;
                    this.$indent = $indent;
                    super(0);
                }

                public final void invoke() {
                    this.$document.insertString(this.$lineStartOffset, (CharSequence)this.$indent);
                }
            }));
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

