/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.csharp.assists;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterInStringLiteralHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpEnterInStringLiteralHandlerKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpLineIndentProviderKt;
import com.jetbrains.rider.languages.fileTypes.csharp.assists.CSharpQuoteHandlerKt;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.lexer.CSharpTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014JF\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016JL\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/csharp/assists/CSharpEnterInStringLiteralHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterInStringLiteralHandler;", "()V", "isInsideLiteral", "", "quoteHandler", "Lcom/intellij/codeInsight/editorActions/JavaLikeQuoteHandler;", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvanceRef", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "splitString", "psiAtOffset", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "caretOffset", "intellij.rider.languages"})
public final class CSharpEnterInStringLiteralHandler
extends EnterInStringLiteralHandler {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvanceRef, (String)"caretAdvanceRef");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!CSharpLineIndentProviderKt.isPatchEngineEnabled()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (language != CSharpLanguage.INSTANCE) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Integer n = (Integer)caretOffsetRef.get();
        JavaLikeQuoteHandler javaLikeQuoteHandler = this.getJavaLikeQuoteHandler(editor2, (PsiElement)file);
        Intrinsics.checkNotNull((Object)n);
        if (!this.isInStringLiteral(editor2, javaLikeQuoteHandler, n)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor2.getDocument());
        PsiElement psiElement = file.findElementAt(n.intValue());
        if (psiElement != null && psiElement.getTextOffset() < n) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            if (CSharpTokenType.VERBATIM_STRINGS.contains(PsiUtilCore.getElementType((PsiElement)psiElement))) {
                document2.insertString(n.intValue(), (CharSequence)"\n");
                editor2.getCaretModel().getCurrentCaret().moveToOffset(editor2.getCaretModel().getCurrentCaret().getOffset() + 1);
                return EnterHandlerDelegate.Result.Stop;
            }
            if (javaLikeQuoteHandler != null && CSharpEnterInStringLiteralHandlerKt.access$getMyInterpolatedConcatenableStrings$p().contains(PsiUtilCore.getElementType((PsiElement)psiElement))) {
                return this.splitString(file, caretOffsetRef, caretAdvanceRef, psiElement, document2, n, javaLikeQuoteHandler);
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected boolean isInsideLiteral(@NotNull JavaLikeQuoteHandler quoteHandler, @NotNull HighlighterIterator iterator2) {
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        IElementType iElementType = iterator2.getTokenType();
        return CSharpQuoteHandlerKt.getBASIC_TEXT_LITERALS().contains(iElementType) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)CSharpTokenType.INTERPOLATION_LBRACE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)CSharpTokenType.INTERPOLATION_RBRACE));
    }

    @NotNull
    protected EnterHandlerDelegate.Result splitString(@NotNull PsiFile file, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull PsiElement psiAtOffset, @NotNull Document document, int caretOffset, @NotNull JavaLikeQuoteHandler quoteHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvanceRef, (String)"caretAdvanceRef");
        Intrinsics.checkNotNullParameter((Object)psiAtOffset, (String)"psiAtOffset");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)quoteHandler, (String)"quoteHandler");
        ASTNode aSTNode = psiAtOffset.getNode();
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence charSequence = string;
        TextRange textRange = aSTNode.getTextRange();
        char c = aSTNode.getText().charAt(0);
        StringLiteralLexer stringLiteralLexer = new StringLiteralLexer(c, aSTNode.getElementType());
        stringLiteralLexer.start(charSequence, textRange.getStartOffset(), textRange.getEndOffset());
        int n = EnterInStringLiteralHandler.skipStringLiteralEscapes((int)caretOffset, (StringLiteralLexer)stringLiteralLexer);
        n = EnterInStringLiteralHandler.wrapWithParensIfNeeded((PsiElement)psiAtOffset, (Document)document, (int)n, (JavaLikeQuoteHandler)quoteHandler);
        String string2 = "\" +";
        document.insertString(n, (CharSequence)(string2 + " $\""));
        n += string2.length() + 1;
        int n2 = 2;
        if (CodeStyle.getLanguageSettings((PsiFile)file).BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
            --n;
            n2 = 3;
        }
        caretOffsetRef.set((Object)n);
        caretAdvanceRef.set((Object)n2);
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }
}

