/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.languages.fileTypes.clr.psi.escaping;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.rider.languages.fileTypes.clr.psi.ClrLanguageStringLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u001c\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0010H\u0014J,\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0010H\u0002J,\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0010H\u0002J$\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010!\u001a\u00020\nH\u0002J4\u0010\"\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010#\u001a\u00020\u0012H\u0002J,\u0010$\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0010H\u0002J,\u0010%\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\n\u0010\u0018\u001a\u00060\u000fj\u0002`\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/languages/fileTypes/clr/psi/escaping/ClrLanguageRegularStringLiteralEscaper;", "T", "Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageStringLiteralExpression;", "Lcom/intellij/psi/LiteralTextEscaper;", "host", "isInterpolated", "", "recoverOnError", "(Lcom/jetbrains/rider/languages/fileTypes/clr/psi/ClrLanguageStringLiteralExpression;ZZ)V", "offsets", "", "decode", "rangeInsideHost", "Lcom/intellij/openapi/util/TextRange;", "outChars", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getOffsetInHost", "", "offsetInDecoded", "isOneLine", "parseEscapedChar", "c", "", "out", "N", "isAfterEscapedBackslash", "chars", "", "index", "w", "s", "j", "sourceOffsets", "j", "symbolLen", "v", "j", "intellij.rider.languages"})
public class ClrLanguageRegularStringLiteralEscaper<T extends ClrLanguageStringLiteralExpression>
extends LiteralTextEscaper<T> {
    private final boolean isInterpolated;
    private final boolean recoverOnError;
    private int[] offsets;

    public ClrLanguageRegularStringLiteralEscaper(@NotNull T host, boolean isInterpolated, boolean recoverOnError) {
        Intrinsics.checkNotNullParameter(host, (String)"host");
        super((PsiLanguageInjectionHost)host);
        this.isInterpolated = isInterpolated;
        this.recoverOnError = recoverOnError;
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        Intrinsics.checkNotNullParameter((Object)outChars, (String)"outChars");
        String string = rangeInsideHost.substring(((ClrLanguageStringLiteralExpression)this.myHost).getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = string;
        int[] nArray = this.offsets = new int[string2.length() + 1];
        if (this.offsets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            nArray = null;
        }
        return this.j(string2, outChars, nArray);
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
        int[] nArray = this.offsets;
        if (this.offsets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            nArray = null;
        }
        if (offsetInDecoded >= nArray.length) {
            return -1;
        }
        int[] nArray2 = this.offsets;
        if (this.offsets == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
            nArray2 = null;
        }
        int n = nArray2[offsetInDecoded];
        return Math.min(n, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    public boolean isOneLine() {
        return true;
    }

    private final boolean j(String string, StringBuilder stringBuilder, int[] nArray) {
        int n = 0;
        int n2 = stringBuilder.length();
        while (n < string.length()) {
            char c = string.charAt(n++);
            nArray[stringBuilder.length() - n2] = n - 1;
            nArray[stringBuilder.length() + 1 - n2] = n;
            if (c == '{' || c == '}') {
                stringBuilder.append(c);
                if (!this.isInterpolated || n >= string.length() || string.charAt(n) != c) continue;
                nArray[stringBuilder.length() - n2] = ++n;
                continue;
            }
            if (c != '\\') {
                stringBuilder.append(c);
                continue;
            }
            int n3 = this.N(false, string, n, stringBuilder);
            if (n3 != -1) {
                nArray[stringBuilder.length() - n2] = n3;
                n = n3;
                continue;
            }
            if (this.recoverOnError) {
                stringBuilder.append(c);
                continue;
            }
            return false;
        }
        return true;
    }

    private final int N(boolean bl, String string, int n, StringBuilder stringBuilder) {
        char c;
        int n2 = n;
        if (n2 == string.length()) {
            return -1;
        }
        if (this.parseEscapedChar(c = string.charAt(n2++), stringBuilder)) {
            return n2;
        }
        char c2 = c;
        if (c2 == '\\') {
            if (bl && n2 < string.length()) {
                char c3 = string.charAt(n2);
                if (c3 == 'u') {
                    n2 = this.v(true, string, n2 + 1, stringBuilder);
                } else if (c3 == 'U') {
                    n2 = this.j(true, string, n2 + 1, stringBuilder);
                } else if (c3 == 'x') {
                    n2 = this.w(true, string, n2 + 1, stringBuilder);
                } else {
                    stringBuilder.append('\\');
                }
            } else {
                stringBuilder.append('\\');
            }
        } else if (c2 == 'u') {
            if (bl) {
                return -1;
            }
            n2 = this.v(false, string, n2, stringBuilder);
        } else if (c2 == 'U') {
            if (bl) {
                return -1;
            }
            n2 = this.j(false, string, n2, stringBuilder);
        } else if (c2 == 'x') {
            if (bl) {
                return -1;
            }
            n2 = this.w(false, string, n2, stringBuilder);
        } else {
            return -1;
        }
        return n2;
    }

    private final int v(boolean bl, String string, int n, StringBuilder stringBuilder) {
        return this.j(bl, string, n, stringBuilder, 4);
    }

    private final int j(boolean bl, String string, int n, StringBuilder stringBuilder) {
        return this.j(bl, string, n, stringBuilder, 8);
    }

    private final int w(boolean bl, String string, int n, StringBuilder stringBuilder) {
        int n2 = 0;
        int n3 = n;
        int n4 = Math.min(n + 4, string.length());
        if (n3 <= n4) {
            while (true) {
                char c;
                if (!('0' <= (c = string.charAt(n3)) ? c < ':' : false)) {
                    if (!('a' <= c ? c < 'g' : false)) {
                        boolean bl2 = 'A' <= c ? c < 'G' : false;
                        if (!bl2) break;
                    }
                }
                ++n2;
                if (n3 == n4) break;
                ++n3;
            }
        }
        if (n2 < 1) {
            return -1;
        }
        return this.j(bl, string, n, stringBuilder, n2);
    }

    private final int j(boolean bl, String string, int n, StringBuilder stringBuilder, int n2) {
        int n3;
        int n4 = string.length();
        if (n + n2 > n4) {
            return -1;
        }
        try {
            n3 = string.charAt(n);
            if (n3 == 43 || n3 == 45) {
                return -1;
            }
            String string2 = string.substring(n, n + n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            int n5 = Integer.parseInt(string2, CharsKt.checkRadix((int)16));
            char c = (char)n5;
            if (c == '\\') {
                if (!bl) {
                    int n6;
                    int n7 = this.N(true, string, n + n2, stringBuilder);
                    if (n7 == -1 && this.recoverOnError) {
                        stringBuilder.append('\\');
                        n6 = n + n2;
                    } else {
                        n6 = n7;
                    }
                    return n6;
                }
                stringBuilder.append('\\');
                return n + n2;
            }
            if (bl) {
                return this.parseEscapedChar(c, stringBuilder) ? n + n2 : -1;
            }
            stringBuilder.append(c);
            n3 = n + n2;
        }
        catch (NumberFormatException numberFormatException) {
            n3 = -1;
        }
        return n3;
    }

    protected boolean parseEscapedChar(char c, @NotNull StringBuilder out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        char c2 = c;
        if (c2 == '\'') {
            out.append('\'');
            return true;
        }
        if (c2 == '\"') {
            out.append('\"');
            return true;
        }
        if (c2 == 'r') {
            out.append('\r');
            return true;
        }
        if (c2 == 'n') {
            out.append('\n');
            return true;
        }
        if (c2 == 't') {
            out.append('\t');
            return true;
        }
        if (c2 == '0') {
            out.append('\u0000');
            return true;
        }
        if (c2 == 'a') {
            out.append('\u0007');
            return true;
        }
        if (c2 == 'b') {
            out.append('\b');
            return true;
        }
        if (c2 == 'f') {
            out.append('\f');
            return true;
        }
        if (c2 == 'v') {
            out.append('\u000b');
            return true;
        }
        return c2 == '\n';
    }
}

