/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.vfs;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RdFileIdInMem;
import com.jetbrains.rd.ide.model.RdFileIdNew;
import com.jetbrains.rd.ide.model.RdFileIdOld;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/vfs/FrontendVirtualFileManager;", "", "()V", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileId", "Lcom/jetbrains/rd/ide/model/RdFileId;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendVirtualFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendVirtualFileManager.kt\ncom/jetbrains/rdclient/vfs/FrontendVirtualFileManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,40:1\n13#2:41\n*S KotlinDebug\n*F\n+ 1 FrontendVirtualFileManager.kt\ncom/jetbrains/rdclient/vfs/FrontendVirtualFileManager\n*L\n17#1:41\n*E\n"})
public class FrontendVirtualFileManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Nullable
    public VirtualFile getVirtualFile(@NotNull RdFileId fileId) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        RdFileId rdFileId = fileId;
        if (rdFileId instanceof RdFileIdNew) {
            virtualFile = VirtualFileManager.getInstance().findFileById(((RdFileIdNew)fileId).getFrontendId());
            if (virtualFile == null) {
                return null;
            }
        } else if (rdFileId instanceof RdFileIdOld) {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(((RdFileIdOld)fileId).getProtocol());
            if (virtualFileSystem == null) {
                LOG.error("file system is not found for " + fileId);
                return null;
            }
            virtualFile = virtualFileSystem.findFileByPath(((RdFileIdOld)fileId).getPath());
            if (virtualFile == null) {
                return null;
            }
        } else {
            if (rdFileId instanceof RdFileIdInMem) {
                throw new IllegalStateException(("In memory files unsupported by " + ApplicationInfo.getInstance().getFullApplicationName()).toString());
            }
            virtualFile = null;
        }
        return virtualFile;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendVirtualFileManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdclient/vfs/FrontendVirtualFileManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/vfs/FrontendVirtualFileManager;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendVirtualFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendVirtualFileManager.kt\ncom/jetbrains/rdclient/vfs/FrontendVirtualFileManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,40:1\n40#2,3:41\n*S KotlinDebug\n*F\n+ 1 FrontendVirtualFileManager.kt\ncom/jetbrains/rdclient/vfs/FrontendVirtualFileManager$Companion\n*L\n15#1:41,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrontendVirtualFileManager getInstance() {
            boolean bl = false;
            Class<FrontendVirtualFileManager> clazz = FrontendVirtualFileManager.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (FrontendVirtualFileManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

