/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.ui.diff;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.ui.diff.ChangedBlock;
import com.jetbrains.rdclient.ui.diff.FrontendDiffMarkModelSupportKt;
import com.jetbrains.rdclient.ui.diff.SideBySideChangeModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001$B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\tH\u0002J(\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u001d\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e0\u001c2\u0006\u0010!\u001a\u00020\u0005H\u0002J\b\u0010\"\u001a\u00020\tH\u0002J\b\u0010#\u001a\u00020\tH\u0002R*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006%"}, d2={"Lcom/jetbrains/rdclient/ui/diff/SideBySideBlocksModel;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor1", "Lcom/intellij/openapi/editor/ex/EditorEx;", "editor2", "onBlocksChanges", "Lkotlin/Function0;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Lkotlin/jvm/functions/Function0;)V", "<set-?>", "", "Lcom/jetbrains/rdclient/ui/diff/ChangedBlock;", "changedBlocks", "getChangedBlocks", "()Ljava/util/List;", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isUpdateScheduled", "", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getOnBlocksChanges", "()Lkotlin/jvm/functions/Function0;", "N", "j", "", "", "Lkotlin/Pair;", "Lcom/jetbrains/rdclient/ui/diff/SideBySideChangeModel;", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "editor", "j", "w", "BlocksMarkupModelListener", "intellij.rd.client"})
public final class SideBySideBlocksModel {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorEx editor1;
    @NotNull
    private final EditorEx editor2;
    @NotNull
    private final Function0<Unit> onBlocksChanges;
    private boolean isUpdateScheduled;
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private List<ChangedBlock> changedBlocks;

    public SideBySideBlocksModel(@NotNull Lifetime lifetime, @NotNull EditorEx editor1, @NotNull EditorEx editor2, @NotNull Function0<Unit> onBlocksChanges) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor1, (String)"editor1");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor2");
        Intrinsics.checkNotNullParameter(onBlocksChanges, (String)"onBlocksChanges");
        this.lifetime = lifetime;
        this.editor1 = editor1;
        this.editor2 = editor2;
        this.onBlocksChanges = onBlocksChanges;
        this.highlighters = new ArrayList();
        this.changedBlocks = CollectionsKt.emptyList();
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null);
        BlocksMarkupModelListener blocksMarkupModelListener = new BlocksMarkupModelListener();
        this.editor1.getMarkupModel().addMarkupModelListener(disposable, (MarkupModelListener)blocksMarkupModelListener);
        this.editor2.getMarkupModel().addMarkupModelListener(disposable, (MarkupModelListener)blocksMarkupModelListener);
        this.w();
        this.lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.N();
            }
        });
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Function0<Unit> getOnBlocksChanges() {
        return this.onBlocksChanges;
    }

    @NotNull
    public final List<ChangedBlock> getChangedBlocks() {
        return this.changedBlocks;
    }

    private final void w() {
        if (this.isUpdateScheduled) {
            return;
        }
        this.isUpdateScheduled = true;
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ SideBySideBlocksModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                SideBySideBlocksModel.access$setUpdateScheduled$p(this.this$0, false);
                SideBySideBlocksModel.access$rebuildBlocks(this.this$0);
            }
        }), (int)1, null);
    }

    private final void N() {
        for (RangeHighlighter rangeHighlighter : this.highlighters) {
            rangeHighlighter.dispose();
        }
        this.highlighters.clear();
        this.changedBlocks = CollectionsKt.emptyList();
    }

    private final void j() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime) || this.editor1.isDisposed() || this.editor2.isDisposed()) {
            return;
        }
        this.N();
        Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>> map = this.j(this.editor1);
        Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>> map2 = this.j(this.editor2);
        List list2 = new ArrayList();
        Iterator iterator2 = CollectionsKt.sorted((Iterable)CollectionsKt.union((Iterable)map.keySet(), (Iterable)map2.keySet())).iterator();
        while (iterator2.hasNext()) {
            Pair<SideBySideChangeModel, RangeHighlighterEx> pair;
            Pair<SideBySideChangeModel, RangeHighlighterEx> pair2;
            long l = ((Number)iterator2.next()).longValue();
            if (map.get(l) == null) continue;
            SideBySideChangeModel sideBySideChangeModel = (SideBySideChangeModel)pair2.component1();
            RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)pair2.component2();
            if (map2.get(l) == null) continue;
            SideBySideChangeModel sideBySideChangeModel2 = (SideBySideChangeModel)pair.component1();
            RangeHighlighterEx rangeHighlighterEx2 = (RangeHighlighterEx)pair.component2();
            ((Collection)list2).add(new ChangedBlock(rangeHighlighterEx, rangeHighlighterEx2, sideBySideChangeModel, sideBySideChangeModel2));
        }
        this.changedBlocks = list2;
        this.onBlocksChanges.invoke();
    }

    private final Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>> j(EditorEx editorEx) {
        DocumentEx documentEx = editorEx.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx documentEx2 = documentEx;
        Map map = new LinkedHashMap();
        editorEx.getMarkupModel().processRangeHighlightersOverlappingWith(0, documentEx2.getTextLength(), arg_0 -> SideBySideBlocksModel.j((Function1)new Function1<RangeHighlighterEx, Boolean>((Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>>)map){
            final /* synthetic */ Map<Long, Pair<SideBySideChangeModel, RangeHighlighterEx>> $blockMap;
            {
                this.$blockMap = $blockMap;
                super(1);
            }

            @NotNull
            public final Boolean invoke(RangeHighlighterEx it) {
                Intrinsics.checkNotNull((Object)it);
                SideBySideChangeModel sideBySideChangeModel = FrontendDiffMarkModelSupportKt.getSideBySideChangeModel((RangeHighlighter)it);
                if (sideBySideChangeModel != null) {
                    this.$blockMap.put(sideBySideChangeModel.getChangeId(), (Pair<SideBySideChangeModel, RangeHighlighterEx>)new Pair((Object)sideBySideChangeModel, (Object)it));
                }
                return true;
            }
        }, arg_0));
        return map;
    }

    private static final boolean j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        return (Boolean)function1.invoke(object);
    }

    public static final /* synthetic */ void access$setUpdateScheduled$p(SideBySideBlocksModel $this, boolean bl) {
        $this.isUpdateScheduled = bl;
    }

    public static final /* synthetic */ void access$rebuildBlocks(SideBySideBlocksModel $this) {
        $this.j();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/ui/diff/SideBySideBlocksModel$BlocksMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "(Lcom/jetbrains/rdclient/ui/diff/SideBySideBlocksModel;)V", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterRemoved", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "j", "intellij.rd.client"})
    private final class BlocksMarkupModelListener
    implements MarkupModelListener {
        public void afterAdded(@NotNull RangeHighlighterEx highlighter2) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            this.j(highlighter2);
        }

        public void afterRemoved(@NotNull RangeHighlighterEx highlighter2) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            this.j(highlighter2);
        }

        public void attributesChanged(@NotNull RangeHighlighterEx highlighter2, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            this.j(highlighter2);
        }

        private final void j(RangeHighlighterEx rangeHighlighterEx) {
            if (FrontendDiffMarkModelSupportKt.getSideBySideChangeModel((RangeHighlighter)rangeHighlighterEx) != null) {
                SideBySideBlocksModel.this.w();
            }
        }
    }
}

