/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.ui.diff;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.DiffInnerMarkHighlighterModel;
import com.jetbrains.rd.ide.model.DiffLineMarkHighlighterModel;
import com.jetbrains.rd.ide.model.DiffMarkHighlighterModel;
import com.jetbrains.rd.ide.model.DiffSideBySideChangeMarkHighlighterModel;
import com.jetbrains.rd.ide.model.DiffUnifiedChangeMarkHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import com.jetbrains.rdclient.ui.diff.DiffInnerModel;
import com.jetbrains.rdclient.ui.diff.DiffLineModel;
import com.jetbrains.rdclient.ui.diff.FrontendDiffMarkModelSupportKt;
import com.jetbrains.rdclient.ui.diff.SideBySideChangeModel;
import com.jetbrains.rdclient.ui.diff.UnifiedChangeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rdclient/ui/diff/DiffMarkModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Document;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProject", "()Lcom/intellij/openapi/project/Project;", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "compare", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initialize", "", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
final class DiffMarkModelHandler
implements IProtocolHighlighterModelHandler {
    @Nullable
    private final Project project;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Document document;

    public DiffMarkModelHandler(@Nullable Project project, @NotNull Lifetime lifetime, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.lifetime = lifetime;
        this.document = document;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return model2 instanceof DiffMarkHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        HighlighterModel highlighterModel = model2;
        if (highlighterModel instanceof DiffSideBySideChangeMarkHighlighterModel) {
            FrontendDiffMarkModelSupportKt.setSideBySideChangeModel(highlighter2, new SideBySideChangeModel(((DiffSideBySideChangeMarkHighlighterModel)model2).getChangeId(), ((DiffSideBySideChangeMarkHighlighterModel)model2).getType(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isSkipped(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isExcluded(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isEmptyRange(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isEOF()));
        } else if (highlighterModel instanceof DiffUnifiedChangeMarkHighlighterModel) {
            FrontendDiffMarkModelSupportKt.setUnifiedChangeModel(highlighter2, new UnifiedChangeModel(((DiffUnifiedChangeMarkHighlighterModel)model2).getChangeId(), ((DiffUnifiedChangeMarkHighlighterModel)model2).isEmptyRange(), ((DiffUnifiedChangeMarkHighlighterModel)model2).isEOF()));
        } else if (highlighterModel instanceof DiffLineMarkHighlighterModel) {
            FrontendDiffMarkModelSupportKt.setDiffLineModel(highlighter2, new DiffLineModel(((DiffLineMarkHighlighterModel)model2).getType(), ((DiffLineMarkHighlighterModel)model2).getEditorMode(), ((DiffLineMarkHighlighterModel)model2).getGutterMode(), ((DiffLineMarkHighlighterModel)model2).isEmptyRange(), ((DiffLineMarkHighlighterModel)model2).isEOF()));
        } else if (highlighterModel instanceof DiffInnerMarkHighlighterModel) {
            FrontendDiffMarkModelSupportKt.setDiffInnerModel(highlighter2, new DiffInnerModel(((DiffInnerMarkHighlighterModel)model2).getType()));
        } else {
            throw new IllegalStateException(("Unknown diff model: " + model2).toString());
        }
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model2, highlighter2);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        HighlighterModel highlighterModel = model2;
        if (highlighterModel instanceof DiffSideBySideChangeMarkHighlighterModel) {
            DiffSideBySideChangeMarkHighlighterModel diffSideBySideChangeMarkHighlighterModel = (DiffSideBySideChangeMarkHighlighterModel)model2;
            boolean bl = false;
            return new DiffSideBySideChangeMarkHighlighterModel(diffSideBySideChangeMarkHighlighterModel.getChangeId(), ((DiffSideBySideChangeMarkHighlighterModel)model2).getType(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isSkipped(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isExcluded(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isEmptyRange(), ((DiffSideBySideChangeMarkHighlighterModel)model2).isEOF(), diffSideBySideChangeMarkHighlighterModel.getLayer(), diffSideBySideChangeMarkHighlighterModel.isExactRange(), diffSideBySideChangeMarkHighlighterModel.getDocumentVersion(), diffSideBySideChangeMarkHighlighterModel.isGreedyToLeft(), diffSideBySideChangeMarkHighlighterModel.isGreedyToRight(), diffSideBySideChangeMarkHighlighterModel.isThinErrorStripeMark(), diffSideBySideChangeMarkHighlighterModel.getTextToHighlight(), diffSideBySideChangeMarkHighlighterModel.getTextAttributesKey(), diffSideBySideChangeMarkHighlighterModel.getId(), diffSideBySideChangeMarkHighlighterModel.getProperties(), startOffset, endOffset);
        }
        if (highlighterModel instanceof DiffUnifiedChangeMarkHighlighterModel) {
            DiffUnifiedChangeMarkHighlighterModel diffUnifiedChangeMarkHighlighterModel = (DiffUnifiedChangeMarkHighlighterModel)model2;
            boolean bl = false;
            return new DiffUnifiedChangeMarkHighlighterModel(diffUnifiedChangeMarkHighlighterModel.getChangeId(), ((DiffUnifiedChangeMarkHighlighterModel)model2).isEmptyRange(), ((DiffUnifiedChangeMarkHighlighterModel)model2).isEOF(), diffUnifiedChangeMarkHighlighterModel.getLayer(), diffUnifiedChangeMarkHighlighterModel.isExactRange(), diffUnifiedChangeMarkHighlighterModel.getDocumentVersion(), diffUnifiedChangeMarkHighlighterModel.isGreedyToLeft(), diffUnifiedChangeMarkHighlighterModel.isGreedyToRight(), diffUnifiedChangeMarkHighlighterModel.isThinErrorStripeMark(), diffUnifiedChangeMarkHighlighterModel.getTextToHighlight(), diffUnifiedChangeMarkHighlighterModel.getTextAttributesKey(), diffUnifiedChangeMarkHighlighterModel.getId(), diffUnifiedChangeMarkHighlighterModel.getProperties(), startOffset, endOffset);
        }
        if (highlighterModel instanceof DiffLineMarkHighlighterModel) {
            DiffLineMarkHighlighterModel diffLineMarkHighlighterModel = (DiffLineMarkHighlighterModel)model2;
            boolean bl = false;
            return new DiffLineMarkHighlighterModel(diffLineMarkHighlighterModel.getType(), diffLineMarkHighlighterModel.getEditorMode(), diffLineMarkHighlighterModel.getGutterMode(), diffLineMarkHighlighterModel.isEmptyRange(), diffLineMarkHighlighterModel.isEOF(), diffLineMarkHighlighterModel.getLayer(), diffLineMarkHighlighterModel.isExactRange(), diffLineMarkHighlighterModel.getDocumentVersion(), diffLineMarkHighlighterModel.isGreedyToLeft(), diffLineMarkHighlighterModel.isGreedyToRight(), diffLineMarkHighlighterModel.isThinErrorStripeMark(), diffLineMarkHighlighterModel.getTextToHighlight(), diffLineMarkHighlighterModel.getTextAttributesKey(), diffLineMarkHighlighterModel.getId(), diffLineMarkHighlighterModel.getProperties(), startOffset, endOffset);
        }
        if (highlighterModel instanceof DiffInnerMarkHighlighterModel) {
            DiffInnerMarkHighlighterModel diffInnerMarkHighlighterModel = (DiffInnerMarkHighlighterModel)model2;
            boolean bl = false;
            return new DiffInnerMarkHighlighterModel(diffInnerMarkHighlighterModel.getType(), diffInnerMarkHighlighterModel.getLayer(), diffInnerMarkHighlighterModel.isExactRange(), diffInnerMarkHighlighterModel.getDocumentVersion(), diffInnerMarkHighlighterModel.isGreedyToLeft(), diffInnerMarkHighlighterModel.isGreedyToRight(), diffInnerMarkHighlighterModel.isThinErrorStripeMark(), diffInnerMarkHighlighterModel.getTextToHighlight(), diffInnerMarkHighlighterModel.getTextAttributesKey(), diffInnerMarkHighlighterModel.getId(), diffInnerMarkHighlighterModel.getProperties(), startOffset, endOffset);
        }
        throw new IllegalStateException(("Unknown diff model: " + model2).toString());
    }
}

