/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.ui;

import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.RichAttributedStringModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rdclient.daemon.util.StringUtilKt;
import com.jetbrains.rdclient.highlighting.FrontendHighlighterAttributeCustomizer;
import com.jetbrains.rdclient.ui.RichTextHtmlUtils;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\n\u0010\r\u001a\u00020\u0004*\u00020\u000eJ\u000f\u0010\u000f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0010*\u00020\u000eJ\u000f\u0010\u000f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0010*\u00020\u0004J\f\u0010\u0011\u001a\u00020\u0004*\u00020\u0004H\u0002J\u0014\u0010\u0012\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\u0013\u001a\u00020\u0004*\u00020\u000eH\u0007J\n\u0010\u0014\u001a\u00020\u0004*\u00020\u000eJ\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0004*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdclient/ui/RichTextHtmlUtils;", "", "()V", "HR_SEPARATOR_TAG", "", "SEPARATOR_COLOR", "SEPARATOR_TAG", "TOOLTIP_SEPARATOR", "leadingSpacesRegex", "Lkotlin/text/Regex;", "j", "model", "Lcom/jetbrains/rd/ide/model/RichAttributedStringModel;", "escapeAndHighlight", "Lcom/jetbrains/rd/ide/model/RichAttributedTextModel;", "escapeToIdeaTooltip", "Lorg/jetbrains/annotations/NotNull;", "j", "N", "highlightAttributedParts", "removeAttributes", "j", "Lcom/jetbrains/rd/ide/model/FontStyle;", "intellij.rd.client"})
public final class RichTextHtmlUtils {
    @NotNull
    public static final RichTextHtmlUtils INSTANCE = new RichTextHtmlUtils();
    @NotNull
    public static final String TOOLTIP_SEPARATOR = "_HORIZONTAL_LINE_TOOLTIP_SEPARATOR_";
    @NotNull
    private static final String SEPARATOR_COLOR = "SEPARATOR_COLOR";
    @NotNull
    private static final String SEPARATOR_TAG = "<div style=\"padding-bottom:5px;margin-bottom:5px;border-bottom: thin solid #SEPARATOR_COLOR;\">";
    @NotNull
    private static final String HR_SEPARATOR_TAG = "<hr size=1 noshade>";
    @NotNull
    private static final Regex leadingSpacesRegex = new Regex("<br> +");

    private RichTextHtmlUtils() {
    }

    @NotNull
    public final String escapeToIdeaTooltip(@NotNull RichAttributedTextModel $this$escapeToIdeaTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeToIdeaTooltip, (String)"<this>");
        return StringUtilKt.wrapInHtml(this.escapeAndHighlight($this$escapeToIdeaTooltip));
    }

    @NotNull
    public final String escapeAndHighlight(@NotNull RichAttributedTextModel $this$escapeAndHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeAndHighlight, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$escapeAndHighlight.getParts(), (CharSequence)"", null, null, (int)0, null, (Function1)escapeAndHighlight.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final String escapeToIdeaTooltip(@NotNull String $this$escapeToIdeaTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeToIdeaTooltip, (String)"<this>");
        String string = StringUtilKt.escapeString($this$escapeToIdeaTooltip);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeString(...)");
        return StringUtilKt.wrapInHtml(StringsKt.replace$default((String)this.j(StringUtilKt.escapeNewLines(string)), (String)TOOLTIP_SEPARATOR, (String)HR_SEPARATOR_TAG, (boolean)false, (int)4, null));
    }

    @Nls
    @NotNull
    public final String highlightAttributedParts(@NotNull RichAttributedTextModel $this$highlightAttributedParts) {
        Intrinsics.checkNotNullParameter((Object)$this$highlightAttributedParts, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        for (RichAttributedStringModel richAttributedStringModel : $this$highlightAttributedParts.getParts()) {
            String string;
            if (StringsKt.contains$default((CharSequence)richAttributedStringModel.getText(), (CharSequence)TOOLTIP_SEPARATOR, (boolean)false, (int)2, null)) {
                String string2 = ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHex(...)");
                stringBuilder.insert(0, StringsKt.replace$default((String)SEPARATOR_TAG, (String)SEPARATOR_COLOR, (String)string2, (boolean)false, (int)4, null));
                string = StringsKt.replace$default((String)richAttributedStringModel.getText(), (String)TOOLTIP_SEPARATOR, (String)"</div>", (boolean)false, (int)4, null);
            } else {
                string = richAttributedStringModel.getText();
            }
            String string3 = string;
            stringBuilder.append(this.j(this.N(string3, richAttributedStringModel), richAttributedStringModel));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String removeAttributes(@NotNull RichAttributedTextModel $this$removeAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$removeAttributes, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        for (RichAttributedStringModel richAttributedStringModel : $this$removeAttributes.getParts()) {
            String string;
            if (StringsKt.contains$default((CharSequence)richAttributedStringModel.getText(), (CharSequence)TOOLTIP_SEPARATOR, (boolean)false, (int)2, null)) {
                String string2 = ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHex(...)");
                stringBuilder.insert(0, StringsKt.replace$default((String)SEPARATOR_TAG, (String)SEPARATOR_COLOR, (String)string2, (boolean)false, (int)4, null));
                string = StringsKt.replace$default((String)richAttributedStringModel.getText(), (String)TOOLTIP_SEPARATOR, (String)"</div>", (boolean)false, (int)4, null);
            } else {
                string = richAttributedStringModel.getText();
            }
            String string3 = string;
            stringBuilder.append(string3);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String N(String string, RichAttributedStringModel richAttributedStringModel) {
        TextAttributesKeyModel textAttributesKeyModel = richAttributedStringModel.getTextAttributesKey();
        if (textAttributesKeyModel == null) {
            return string;
        }
        TextAttributesKeyModel textAttributesKeyModel2 = textAttributesKeyModel;
        TextAttributes textAttributes = FrontendHighlighterAttributeCustomizer.Companion.getTextAttributes(textAttributesKeyModel2);
        if (textAttributes == null && (textAttributes = TextAttributesRegistrationHost.getTextAttributes$default(TextAttributesRegistrationHost.Companion.getInstance(), textAttributesKeyModel2, null, 2, null)) == null) {
            return string;
        }
        TextAttributes textAttributes2 = textAttributes;
        Color color = textAttributes2.getForegroundColor();
        if (color == null) {
            return string;
        }
        Color color2 = color;
        return "<span style=\"color:#" + ColorUtil.toHex((Color)color2) + "\">" + string + "</span>";
    }

    private final String j(String string, RichAttributedStringModel richAttributedStringModel) {
        String string2 = this.j(richAttributedStringModel.getFontStyle());
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        return "<" + string3 + ">" + string + "</" + string3 + ">";
    }

    private final String j(FontStyle fontStyle) {
        return switch (WhenMappings.$EnumSwitchMapping$0[fontStyle.ordinal()]) {
            case 1 -> null;
            case 2 -> "b";
            case 3 -> "i";
            case 4 -> "u";
            case 5 -> "s";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String j(String string) {
        CharSequence charSequence = string;
        Regex regex = leadingSpacesRegex;
        Function1 function1 = fixLeadingSpaces.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    public static final /* synthetic */ String access$applyFontStyle(RichTextHtmlUtils $this, String $receiver, RichAttributedStringModel model2) {
        return $this.j($receiver, model2);
    }

    public static final /* synthetic */ String access$highlight(RichTextHtmlUtils $this, String $receiver, RichAttributedStringModel model2) {
        return $this.N($receiver, model2);
    }

    public static final /* synthetic */ String access$fixLeadingSpaces(RichTextHtmlUtils $this, String $receiver) {
        return $this.j($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FontStyle.values().length];
            try {
                nArray[FontStyle.Regular.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Bold.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Italic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Underline.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FontStyle.Strikeout.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

