/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.protocol;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.InvocationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.collections.CountingSet;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.SingleThreadScheduler;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.ModalityStateWithCondition;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010+\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0012\u0010-\u001a\u00020)2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0018\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020)H\u0016J\b\u00105\u001a\u00020)H\u0002J\u0016\u00106\u001a\u00020)2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f0(H\u0016J\u0016\u00108\u001a\u00020)2\f\u00109\u001a\b\u0012\u0004\u0012\u00020)0(H\u0016J\b\u0010:\u001a\u00020)H\u0016J\b\u0010;\u001a\u00020)H\u0002J\u0010\u0010<\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0014\u0010!\u001a\u00020\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/jetbrains/rdclient/protocol/RdDispatcher;", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "application", "Lcom/intellij/openapi/application/Application;", "(Lcom/intellij/openapi/application/Application;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "DEFAULT", "Lcom/jetbrains/rdclient/protocol/ModalityStateWithCondition;", "allowedOnAnyThread", "", "allowedOnThisThread", "Lcom/jetbrains/rd/util/collections/CountingSet;", "Ljava/lang/Thread;", "backgroundScheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "getBackgroundScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "currentModalityAndCondition", "getCurrentModalityAndCondition", "()Lcom/jetbrains/rdclient/protocol/ModalityStateWithCondition;", "setCurrentModalityAndCondition", "(Lcom/jetbrains/rdclient/protocol/ModalityStateWithCondition;)V", "executionOrder", "Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "getExecutionOrder", "()Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "flushAllRunnable", "Ljava/lang/Runnable;", "isActive", "", "()Z", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "processingInProgress", "requests", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lkotlin/Function0;", "", "suppressRequests", "allowAllBackgroundThreadsAndSuppressPumping", "allowBackgroundThreadAndSuppressPumping", "assertThread", "debugInfo", "", "createOrDefault", "lt", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "flush", "flushAll", "pumpProtocolQueue", "condition", "queue", "action", "repost", "repostConditionally", "suppressPumping", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nRdDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdDispatcher.kt\ncom/jetbrains/rdclient/protocol/RdDispatcher\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,228:1\n13#2:229\n*S KotlinDebug\n*F\n+ 1 RdDispatcher.kt\ncom/jetbrains/rdclient/protocol/RdDispatcher\n*L\n25#1:229\n*E\n"})
public class RdDispatcher
implements IRdDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private final LinkedBlockingQueue<Function0<Unit>> requests;
    @NotNull
    private final Runnable flushAllRunnable;
    private boolean processingInProgress;
    @NotNull
    private final Object lock;
    @NotNull
    private final IScheduler backgroundScheduler;
    @NotNull
    private final ModalityStateWithCondition DEFAULT;
    @NotNull
    private volatile ModalityStateWithCondition currentModalityAndCondition;
    @NotNull
    private final CountingSet<Thread> allowedOnThisThread;
    private int allowedOnAnyThread;
    private int suppressRequests;
    @NotNull
    private static final Logger LOG;

    public RdDispatcher(@NotNull Application application, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.application = application;
        this.requests = new LinkedBlockingQueue();
        this.flushAllRunnable = () -> RdDispatcher.flushAllRunnable$lambda$0(this);
        this.lock = new Object();
        this.backgroundScheduler = (IScheduler)new SingleThreadScheduler(lifetime, "BackgroundScheduler");
        ModalityState modalityState = ModalityState.nonModal();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
        this.currentModalityAndCondition = this.DEFAULT = new ModalityStateWithCondition(modalityState, (Condition<Object>)((Condition)arg_0 -> RdDispatcher.DEFAULT$lambda$1(lifetime, arg_0)));
        SwingUtilities.invokeLater(() -> RdDispatcher._init_$lambda$2(this, lifetime));
        this.allowedOnThisThread = new CountingSet();
    }

    public RdDispatcher(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        this(application, lifetime);
    }

    @NotNull
    protected final Object getLock() {
        return this.lock;
    }

    @NotNull
    public IScheduler getBackgroundScheduler() {
        return this.backgroundScheduler;
    }

    @NotNull
    public ExecutionOrder getExecutionOrder() {
        return ExecutionOrder.Sequential;
    }

    @NotNull
    public final ModalityStateWithCondition getCurrentModalityAndCondition() {
        return this.currentModalityAndCondition;
    }

    public final void setCurrentModalityAndCondition(@NotNull ModalityStateWithCondition modalityStateWithCondition) {
        Intrinsics.checkNotNullParameter((Object)modalityStateWithCondition, (String)"<set-?>");
        this.currentModalityAndCondition = modalityStateWithCondition;
    }

    private final ModalityStateWithCondition createOrDefault(Lifetime lt, ModalityState modalityState) {
        return !Intrinsics.areEqual((Object)ModalityState.nonModal(), (Object)modalityState) ? new ModalityStateWithCondition(modalityState, (Condition<Object>)((Condition)arg_0 -> RdDispatcher.createOrDefault$lambda$3(lt, arg_0))) : this.DEFAULT;
    }

    public void flush() {
        this.flushAll();
    }

    public void assertThread(@Nullable Object debugInfo) {
        if (!this.isActive()) {
            LOG.error("Must be executed on UI thread or background threads with special permissions", (Throwable)new IllegalStateException("|E| Wrong thread " + debugInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActive() {
        if (this.application.isDispatchThread()) return true;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (((Number)this.allowedOnThisThread.get((Object)Thread.currentThread())).intValue() > 0) return true;
            if (this.allowedOnAnyThread <= 0) return false;
            return true;
        }
    }

    @Override
    public void pumpProtocolQueue(@NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        IScheduler.DefaultImpls.assertThread$default((IScheduler)((IScheduler)this), null, (int)1, null);
        while (((Boolean)condition.invoke()).booleanValue()) {
            try {
                Function0<Unit> function0 = this.requests.poll(10L, TimeUnit.MILLISECONDS);
                if (function0 == null) continue;
                function0.invoke();
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flushAll() {
        IScheduler.DefaultImpls.assertThread$default((IScheduler)((IScheduler)this), null, (int)1, null);
        while (true) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    boolean bl = false;
                    if (this.suppressRequests > 0 || this.requests.size() == 0) {
                        this.processingInProgress = false;
                        return;
                    }
                    Unit $i$a$-synchronized-RdDispatcher$flushAll$4 = Unit.INSTANCE;
                }
                long startTime = System.currentTimeMillis();
                Function0<Unit> next = this.requests.poll();
                if (next != null) {
                    ModalityState old;
                    boolean isModalityChanged;
                    Intrinsics.checkNotNullExpressionValue((Object)ModalityState.current(), (String)"current(...)");
                    next.invoke();
                    boolean bl = isModalityChanged = !Intrinsics.areEqual((Object)old, (Object)ModalityState.current());
                    if (isModalityChanged) {
                        Object object2 = this.lock;
                        synchronized (object2) {
                            boolean bl2 = false;
                            this.processingInProgress = false;
                            Unit unit = Unit.INSTANCE;
                        }
                        this.repost();
                        return;
                    }
                }
                if (!InvocationUtil.priorityEventPending() && System.currentTimeMillis() - startTime <= 50L) continue;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl = false;
                    this.processingInProgress = false;
                    Unit unit = Unit.INSTANCE;
                }
                this.repost();
                return;
            }
            catch (Throwable t) {
                LOG.error(t);
                continue;
            }
            break;
        }
    }

    @Override
    public void allowBackgroundThreadAndSuppressPumping(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.suppressPumping(lifetime);
        Thread thread = Thread.currentThread();
        lifetime.bracketIfAlive((Function0)new Function0<Integer>(this, thread){
            final /* synthetic */ RdDispatcher this$0;
            final /* synthetic */ Thread $thread;
            {
                this.this$0 = $receiver;
                this.$thread = $thread;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Integer invoke() {
                Integer n;
                Object object = this.this$0.getLock();
                RdDispatcher rdDispatcher = this.this$0;
                Thread thread = this.$thread;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    CountingSet countingSet = RdDispatcher.access$getAllowedOnThisThread$p(rdDispatcher);
                    Intrinsics.checkNotNull((Object)thread);
                    n = countingSet.add((Object)thread, 1);
                }
                return n;
            }
        }, (Function0)new Function0<Unit>(this, thread){
            final /* synthetic */ RdDispatcher this$0;
            final /* synthetic */ Thread $thread;
            {
                this.this$0 = $receiver;
                this.$thread = $thread;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = this.this$0.getLock();
                RdDispatcher rdDispatcher = this.this$0;
                Thread thread = this.$thread;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    CountingSet countingSet = RdDispatcher.access$getAllowedOnThisThread$p(rdDispatcher);
                    Intrinsics.checkNotNull((Object)thread);
                    countingSet.add((Object)thread, -1);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    @Override
    public void allowAllBackgroundThreadsAndSuppressPumping(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.suppressPumping(lifetime);
        lifetime.bracketIfAlive((Function0)new Function0<Integer>(this){
            final /* synthetic */ RdDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Integer invoke() {
                Integer n;
                Object object = this.this$0.getLock();
                RdDispatcher rdDispatcher = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    int n2 = RdDispatcher.access$getAllowedOnAnyThread$p(rdDispatcher);
                    RdDispatcher.access$setAllowedOnAnyThread$p(rdDispatcher, n2 + 1);
                    n = n2;
                }
                return n;
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ RdDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = this.this$0.getLock();
                RdDispatcher rdDispatcher = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    int n = RdDispatcher.access$getAllowedOnAnyThread$p(rdDispatcher);
                    RdDispatcher.access$setAllowedOnAnyThread$p(rdDispatcher, n + -1);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    public void queue(@NotNull Function0<Unit> action3) {
        Intrinsics.checkNotNullParameter(action3, (String)"action");
        this.requests.add((Function0<Unit>)ClientId.Companion.decorateFunction(action3));
        this.repostConditionally();
    }

    @Override
    public void suppressPumping(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        lifetime.bracketIfAlive((Function0)new Function0<Integer>(this){
            final /* synthetic */ RdDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Integer invoke() {
                Integer n;
                Object object = this.this$0.getLock();
                RdDispatcher rdDispatcher = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    RdDispatcher.access$setSuppressRequests$p(rdDispatcher, RdDispatcher.access$getSuppressRequests$p(rdDispatcher) + 1);
                    n = RdDispatcher.access$getSuppressRequests$p(rdDispatcher);
                }
                return n;
            }
        }, (Function0)new Function0<Unit>(this){
            final /* synthetic */ RdDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = this.this$0.getLock();
                RdDispatcher rdDispatcher = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    int n = RdDispatcher.access$getSuppressRequests$p(rdDispatcher);
                    RdDispatcher.access$setSuppressRequests$p(rdDispatcher, n + -1);
                    int n2 = n;
                }
                RdDispatcher.access$repostConditionally(this.this$0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void repostConditionally() {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (this.suppressRequests > 0 || this.requests.size() == 0) break block5;
                    if (!this.processingInProgress) break block6;
                }
                return;
            }
            Unit unit = Unit.INSTANCE;
        }
        this.repost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repost() {
        Object object = this.lock;
        synchronized (object) {
            boolean $i$a$-synchronized-RdDispatcher$repost$22 = false;
            this.processingInProgress = true;
            Unit $i$a$-synchronized-RdDispatcher$repost$22 = Unit.INSTANCE;
        }
        if (LoadingState.COMPONENTS_LOADED.isOccurred()) {
            ModalityStateWithCondition modalityStateWithCondition = this.currentModalityAndCondition;
            ModalityState modality = modalityStateWithCondition.component1();
            Condition<Object> expired = modalityStateWithCondition.component2();
            this.application.invokeLater(this.flushAllRunnable, modality, expired);
        } else {
            SwingUtilities.invokeLater(this.flushAllRunnable);
        }
    }

    public void invokeOrQueue(@NotNull Function0<Unit> action3) {
        IRdDispatcher.DefaultImpls.invokeOrQueue(this, action3);
    }

    private static final void flushAllRunnable$lambda$0(RdDispatcher this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.flushAll();
    }

    private static final boolean DEFAULT$lambda$1(Lifetime $lifetime, Object it) {
        Intrinsics.checkNotNullParameter((Object)$lifetime, (String)"$lifetime");
        return RLifetimeKt.isNotAlive((Lifetime)$lifetime);
    }

    private static final void _init_$lambda$2(RdDispatcher this$0, Lifetime $lifetime) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$lifetime, (String)"$lifetime");
        IPermittedModalities.Companion.getInstance(this$0.application).viewPermittedModality($lifetime, (Function2<? super Lifetime, ? super ModalityState, Unit>)((Function2)new Function2<Lifetime, ModalityState, Unit>(this$0){
            final /* synthetic */ RdDispatcher this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Lifetime lt, @NotNull ModalityState modalityState) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
                this.this$0.setCurrentModalityAndCondition(RdDispatcher.access$createOrDefault(this.this$0, lt, modalityState));
                this.this$0.repost();
            }
        }));
    }

    private static final boolean createOrDefault$lambda$3(Lifetime $lt, Object it) {
        Intrinsics.checkNotNullParameter((Object)$lt, (String)"$lt");
        return RLifetimeKt.isNotAlive((Lifetime)$lt);
    }

    @NotNull
    protected static final Logger getLOG() {
        return Companion.getLOG();
    }

    public static final /* synthetic */ CountingSet access$getAllowedOnThisThread$p(RdDispatcher $this) {
        return $this.allowedOnThisThread;
    }

    public static final /* synthetic */ int access$getAllowedOnAnyThread$p(RdDispatcher $this) {
        return $this.allowedOnAnyThread;
    }

    public static final /* synthetic */ void access$setAllowedOnAnyThread$p(RdDispatcher $this, int n) {
        $this.allowedOnAnyThread = n;
    }

    public static final /* synthetic */ void access$setSuppressRequests$p(RdDispatcher $this, int n) {
        $this.suppressRequests = n;
    }

    public static final /* synthetic */ int access$getSuppressRequests$p(RdDispatcher $this) {
        return $this.suppressRequests;
    }

    public static final /* synthetic */ void access$repostConditionally(RdDispatcher $this) {
        $this.repostConditionally();
    }

    public static final /* synthetic */ ModalityStateWithCondition access$createOrDefault(RdDispatcher $this, Lifetime lt, ModalityState modalityState) {
        return $this.createOrDefault(lt, modalityState);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RdDispatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/protocol/RdDispatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$annotations", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLOG() {
            return LOG;
        }

        @JvmStatic
        protected static /* synthetic */ void getLOG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

