/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.ide.model.notifications.NotificationHyperlink;
import com.jetbrains.ide.model.notifications.NotificationModel;
import com.jetbrains.ide.model.notifications.NotificationsModel;
import com.jetbrains.ide.model.notifications.RdNotificationEntryType;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.ui.NotificationLinkHandler;
import com.jetbrains.rdclient.util.ReentrancyGuard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdclient/notifications/NotificationsHost;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/ide/model/notifications/NotificationsModel;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/ide/model/notifications/NotificationsModel;Lcom/intellij/openapi/client/ClientAppSession;)V", "idToNotification", "Ljava/util/HashMap;", "", "Lcom/intellij/notification/Notification;", "Lkotlin/collections/HashMap;", "reentrancyGuard", "Lcom/jetbrains/rdclient/util/ReentrancyGuard;", "j", "Lcom/intellij/openapi/actionSystem/AnAction;", "link", "Lcom/jetbrains/ide/model/notifications/NotificationHyperlink;", "j", "", "notification", "notificationModelId", "j", "entry", "Lcom/jetbrains/ide/model/notifications/NotificationModel;", "j", "Lcom/intellij/openapi/project/Project;", "Companion", "Listener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nNotificationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationsHost.kt\ncom/jetbrains/rdclient/notifications/NotificationsHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,136:1\n1549#2:137\n1620#2,3:138\n86#3,3:141\n13#3:145\n13#4:144\n*S KotlinDebug\n*F\n+ 1 NotificationsHost.kt\ncom/jetbrains/rdclient/notifications/NotificationsHost\n*L\n98#1:137\n98#1:138,3\n105#1:141,3\n35#1:145\n35#1:144\n*E\n"})
public final class NotificationsHost {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final NotificationsModel model;
    @NotNull
    private final ClientAppSession appSession;
    @NotNull
    private final HashMap<Integer, Notification> idToNotification;
    @NotNull
    private final ReentrancyGuard reentrancyGuard;
    @NotNull
    public static final String groupNameWithoutPopup = "FromBackendWithoutPopup";
    @NotNull
    private static final NotificationGroup group;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<Function1<Notification, Unit>> consumers;

    public NotificationsHost(@NotNull Lifetime lifetime, @NotNull NotificationsModel model2, @NotNull ClientAppSession appSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        this.model = model2;
        this.appSession = appSession;
        this.idToNotification = new HashMap();
        this.reentrancyGuard = new ReentrancyGuard();
        this.model.getNotification().advise(lifetime, (Function1)new Function1<NotificationModel, Unit>(){

            public final void invoke(@NotNull NotificationModel entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                this.j(entry);
            }
        });
        this.model.getNotificationExpired().advise(lifetime, (Function1)new Function1<Integer, Unit>(){

            public final void invoke(int id) {
                block0: {
                    Notification notification2 = (Notification)idToNotification.get(id);
                    if (notification2 == null) break block0;
                    Notification notification3 = notification2;
                    NotificationsHost notificationsHost = this;
                    Notification notification4 = notification3;
                    boolean bl = false;
                    notificationsHost.j(notification4, id);
                }
            }
        });
    }

    private final Project j(NotificationModel notificationModel) {
        ClientProjectSession clientProjectSession;
        ClientProjectSession clientProjectSession2 = SessionUtilKt.getProjectSession(this.appSession, notificationModel.getProjectId());
        if (clientProjectSession2 == null) {
            clientProjectSession2 = (ClientProjectSession)CollectionsKt.firstOrNull((List)this.appSession.getProjectSessions());
        }
        ClientProjectSession clientProjectSession3 = clientProjectSession = clientProjectSession2;
        return clientProjectSession3 != null ? clientProjectSession3.getProject() : null;
    }

    private final void j(NotificationModel notificationModel) {
        ThreadingAssertions.assertEventDispatchThread();
        if (StringsKt.isBlank((CharSequence)notificationModel.getTitle()) && StringsKt.isBlank((CharSequence)notificationModel.getMessage())) {
            return;
        }
        NotificationType notificationType = Companion.convert(notificationModel.getType());
        Notification notification2 = new Notification(notificationModel.getShowPopup() ? "Rider" : groupNameWithoutPopup, notificationModel.getTitle(), notificationModel.getMessage(), notificationType);
        if (StringsKt.contains$default((CharSequence)notificationModel.getMessage(), (CharSequence)"<a href=", (boolean)false, (int)2, null)) {
            notification2.setListener((arg_0, arg_1) -> NotificationsHost.j(this, notificationModel, arg_0, arg_1));
        }
        Function1<Notification, Unit> function13 = (Function1<Notification, Unit>)notificationModel.getHyperlinks();
        Notification notification3 = notification2;
        int n = 0;
        Function1<Notification, Unit> function12 = function13;
        Object object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)function13, (int)10));
        boolean bl = false;
        for (Object t : function12) {
            NotificationHyperlink notificationHyperlink = (NotificationHyperlink)t;
            Collection collection = object;
            boolean bl2 = false;
            collection.add(this.j(notificationHyperlink));
        }
        notification3.addActions((Collection)((List)object));
        Integer n2 = notificationModel.getId();
        if (n2 != null) {
            n = ((Number)n2).intValue();
            boolean bl3 = false;
            object = n;
            ((Map)this.idToNotification).put(object, notification2);
            notification2.whenExpired(() -> NotificationsHost.j(this, notification2, n));
        }
        for (Function1<Notification, Unit> function13 : consumers) {
            Object object2;
            Logger logger = NotificationsHost.logger;
            boolean bl4 = false;
            object = logger;
            try {
                object2 = object;
                boolean bl5 = false;
                boolean bl6 = false;
                function13.invoke((Object)notification2);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object2, (Logger)logger);
        }
        notification2.notify(this.j(notificationModel));
    }

    private final void j(Notification notification2, int n) {
        this.reentrancyGuard.executeWithDefaultValueOnReentrancy(Unit.INSTANCE, (Function0)new Function0<Object>(notification2, this, n){
            final /* synthetic */ Notification $notification;
            final /* synthetic */ NotificationsHost this$0;
            final /* synthetic */ int $notificationModelId;
            {
                this.$notification = $notification;
                this.this$0 = $receiver;
                this.$notificationModelId = $notificationModelId;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                this.$notification.expire();
                NotificationsHost.access$getModel$p(this.this$0).getNotificationExpired().fire((Object)this.$notificationModelId);
                return NotificationsHost.access$getIdToNotification$p(this.this$0).remove(this.$notificationModelId);
            }
        });
    }

    private final AnAction j(NotificationHyperlink notificationHyperlink) {
        String string = notificationHyperlink.getText();
        return new AnAction(notificationHyperlink, this, string){
            final /* synthetic */ NotificationHyperlink $link;
            final /* synthetic */ NotificationsHost this$0;
            {
                this.$link = $link;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                String string = this.$link.getActionId();
                if (string != null) {
                    BackendActionDelegationKt.backendActionPerformed(string, e);
                } else {
                    NotificationsHost.access$getModel$p(this.this$0).getExecuteHyperlink().fire((Object)this.$link.getId());
                }
            }
        };
    }

    private static final void j(NotificationsHost notificationsHost, NotificationModel notificationModel, Notification notification2, HyperlinkEvent hyperlinkEvent) {
        Intrinsics.checkNotNullParameter((Object)notificationsHost, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)notificationModel, (String)"$entry");
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)hyperlinkEvent, (String)"hyperlinkEvent");
        if (!Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        Project project = notificationsHost.j(notificationModel);
        if (project == null) {
            return;
        }
        Project project2 = project;
        for (NotificationLinkHandler notificationLinkHandler : NotificationLinkHandler.Companion.getEP_NAME().getExtensionList()) {
            String string = hyperlinkEvent.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            if (!notificationLinkHandler.handleNotificationLink(project2, string, hyperlinkEvent)) continue;
            break;
        }
    }

    private static final void j(NotificationsHost notificationsHost, Notification notification2, int n) {
        Intrinsics.checkNotNullParameter((Object)notificationsHost, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"$notification");
        notificationsHost.j(notification2, n);
    }

    public static final /* synthetic */ NotificationsModel access$getModel$p(NotificationsHost $this) {
        return $this.model;
    }

    static {
        NotificationGroup notificationGroup;
        Companion = new Companion(null);
        NotificationGroup notificationGroup2 = notificationGroup = new NotificationGroup(groupNameWithoutPopup, NotificationDisplayType.NONE, true, null, null, 24, null);
        boolean bl = false;
        notificationGroup2.setHideFromSettings(true);
        group = notificationGroup;
        boolean bl2 = false;
        boolean bl3 = false;
        Logger logger = Logger.getInstance(NotificationsHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        NotificationsHost.logger = logger;
        consumers = new ArrayList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdclient/notifications/NotificationsHost$Companion;", "", "()V", "consumers", "", "Lkotlin/Function1;", "Lcom/intellij/notification/Notification;", "", "group", "Lcom/intellij/notification/NotificationGroup;", "getGroup", "()Lcom/intellij/notification/NotificationGroup;", "groupNameWithoutPopup", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "convert", "Lcom/intellij/notification/NotificationType;", "type", "Lcom/jetbrains/ide/model/notifications/RdNotificationEntryType;", "registerConsumer", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "consumer", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotificationGroup getGroup() {
            return group;
        }

        @NotNull
        public final NotificationType convert(@NotNull RdNotificationEntryType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1 -> NotificationType.ERROR;
                case 2 -> NotificationType.WARNING;
                case 3 -> NotificationType.INFORMATION;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public final void registerConsumer(@NotNull Lifetime lifetime, @NotNull Function1<? super Notification, Unit> consumer2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            ThreadingAssertions.assertEventDispatchThread();
            CollectionExKt.addUnique((Collection)consumers, (Lifetime)lifetime, consumer2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[RdNotificationEntryType.values().length];
                try {
                    nArray[RdNotificationEntryType.ERROR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RdNotificationEntryType.WARN.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[RdNotificationEntryType.INFO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/notifications/NotificationsHost$Listener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/ide/model/notifications/NotificationsModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.client"})
    public static final class Listener
    implements RootExtListener<NotificationsModel> {
        @Override
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull NotificationsModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            new NotificationsHost(lifetime, model2, session);
        }
    }
}

