/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.gotoType;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.GotoKey;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.gotoType.GotoPopupSession;
import com.jetbrains.rdclient.services.IdeBackend;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\tRB\u0010\u0005\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0004\u0012\u00020\n0\u0006j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myPopupMap", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lcom/intellij/openapi/Disposable;", "Lcom/jetbrains/rd/ide/model/GotoKey;", "Lcom/jetbrains/rdclient/gotoType/GotoPopupSession;", "Lkotlin/collections/HashMap;", "getItemContainingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getSessionForPopup", "popup", "gotoKey", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nGotoHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotoHost.kt\ncom/jetbrains/rdclient/gotoType/GotoHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n13#2:47\n13#3:48\n*S KotlinDebug\n*F\n+ 1 GotoHost.kt\ncom/jetbrains/rdclient/gotoType/GotoHost\n*L\n19#1:47\n19#1:48\n*E\n"})
public class GotoHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<Pair<Disposable, GotoKey>, GotoPopupSession> myPopupMap;
    @NotNull
    private static final Logger logger;

    public GotoHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myPopupMap = new HashMap();
    }

    @NotNull
    public final GotoPopupSession getSessionForPopup(@NotNull Disposable popup, @NotNull GotoKey gotoKey) {
        GotoPopupSession gotoPopupSession;
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Intrinsics.checkNotNullParameter((Object)gotoKey, (String)"gotoKey");
        GotoPopupSession gotoPopupSession2 = this.myPopupMap.get(TuplesKt.to((Object)popup, (Object)gotoKey));
        if (gotoPopupSession2 == null) {
            GotoHost gotoHost = this;
            boolean bl = false;
            logger.info("Creating a new session for goto popup " + popup.hashCode());
            LifetimeDefinition lifetimeDefinition = gotoHost.getServiceLifetime().createNested();
            Disposer.register((Disposable)popup, () -> GotoHost.N(lifetimeDefinition));
            Lifetime lifetime = lifetimeDefinition.getLifetime();
            GotoPopupSession gotoPopupSession3 = new GotoPopupSession(gotoHost.project, lifetime, gotoKey);
            ((Map)gotoHost.myPopupMap).put(TuplesKt.to((Object)popup, (Object)gotoKey), gotoPopupSession3);
            lifetime.onTermination((Function0)new Function0<Unit>(popup, gotoHost, gotoKey){
                final /* synthetic */ Disposable $popup;
                final /* synthetic */ GotoHost $this_run;
                final /* synthetic */ GotoKey $gotoKey;
                {
                    this.$popup = $popup;
                    this.$this_run = $receiver;
                    this.$gotoKey = $gotoKey;
                    super(0);
                }

                public final void invoke() {
                    GotoHost.access$getLogger$cp().info("Terminating session for goto popup " + this.$popup.hashCode());
                    GotoHost.access$getMyPopupMap$p(this.$this_run).remove(TuplesKt.to((Object)this.$popup, (Object)this.$gotoKey));
                }
            });
            gotoPopupSession = gotoPopupSession3;
        } else {
            gotoPopupSession = gotoPopupSession2;
        }
        return gotoPopupSession;
    }

    @Nullable
    public VirtualFile getItemContainingFile(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return IdeBackend.Companion.getInstance(this.project).findVirtualFile(documentId);
    }

    private static final void j(LifetimeDefinition lifetimeDefinition) {
        Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"$lifetimeDef");
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
    }

    private static final void N(LifetimeDefinition lifetimeDefinition) {
        Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"$lifetimeDef");
        ApplicationManager.getApplication().invokeLater(() -> GotoHost.j(lifetimeDefinition), ModalityState.nonModal());
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ HashMap access$getMyPopupMap$p(GotoHost $this) {
        return $this.myPopupMap;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(GotoHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GotoHost.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/gotoType/GotoHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdclient/gotoType/GotoHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GotoHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GotoHost.class);
            Intrinsics.checkNotNull((Object)object);
            return (GotoHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

