/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.filters;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rdclient.filters.FrontendFilterNavigationContext;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\f0\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/filters/FrontendHeavyFilterFrame;", "", "fragment", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "highlightRange", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;)V", "getHighlightRange", "()Lcom/intellij/openapi/util/TextRange;", "getNavigationContext", "Lcom/jetbrains/rdclient/filters/FrontendFilterNavigationContext;", "rangeStart", "", "rangeEnd", "getText", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.rd.client"})
public class FrontendHeavyFilterFrame {
    @NotNull
    private final Document fragment;
    @NotNull
    private final TextRange textRange;
    @NotNull
    private final TextRange highlightRange;

    public FrontendHeavyFilterFrame(@NotNull Document fragment, @NotNull TextRange textRange, @NotNull TextRange highlightRange) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)highlightRange, (String)"highlightRange");
        this.fragment = fragment;
        this.textRange = textRange;
        this.highlightRange = highlightRange;
    }

    @NotNull
    public final TextRange getHighlightRange() {
        return this.highlightRange;
    }

    @NotNull
    public final String getText() {
        String string = this.fragment.getText(this.textRange);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final FrontendFilterNavigationContext getNavigationContext(int rangeStart, int rangeEnd) {
        int n = this.highlightRange.getStartOffset();
        TextRange textRange = new TextRange(n + rangeStart, n + rangeEnd);
        int n2 = this.highlightRange.contains(textRange.getStartOffset());
        if (_Assertions.ENABLED && n2 == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        n2 = 5;
        Document document = this.fragment;
        boolean bl = false;
        int n3 = Math.max(document.getLineNumber(textRange.getStartOffset()) - n2, 0);
        int n4 = document.getLineStartOffset(n3);
        int n5 = Math.min(document.getLineNumber(textRange.getEndOffset()) + n2, document.getLineCount() - 1);
        int n6 = document.getLineEndOffset(n5);
        int n7 = this.highlightRange.getStartOffset() - n4;
        String string = document.getText(new TextRange(n4, n6));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        return new FrontendFilterNavigationContext(string2, n7);
    }
}

