/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.filters;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Consumer;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.ApplyFilterContext;
import com.jetbrains.rd.ide.model.FilterHighlighterModelBase;
import com.jetbrains.rd.ide.model.FilterHyperlinkModel;
import com.jetbrains.rd.ide.model.FilterKind;
import com.jetbrains.rd.ide.model.FilterProviderModel;
import com.jetbrains.rd.platform.daemon.TextAttributesRegistrationHost;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.filters.FrontendHeavyFilterFrame;
import com.jetbrains.rdclient.filters.FrontendHeavyFilterFrameBuffer;
import com.jetbrains.rdclient.filters.FrontendHyperlinkInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J0\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0\u001dH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lcom/jetbrains/rdclient/filters/FrontendHeavyFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/execution/filters/FilterMixin;", "project", "Lcom/intellij/openapi/project/Project;", "kind", "Lcom/jetbrains/rd/ide/model/FilterKind;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/FilterKind;)V", "filterProvider", "Lcom/jetbrains/rd/ide/model/FilterProviderModel;", "getFilterProvider", "()Lcom/jetbrains/rd/ide/model/FilterProviderModel;", "getKind", "()Lcom/jetbrains/rd/ide/model/FilterKind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "applyHeavyFilter", "", "copiedFragment", "Lcom/intellij/openapi/editor/Document;", "startOffset", "startLineNumber", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/execution/filters/FilterMixin$AdditionalHighlight;", "createHyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "highlighter", "Lcom/jetbrains/rd/ide/model/FilterHighlighterModelBase;", "frame", "Lcom/jetbrains/rdclient/filters/FrontendHeavyFilterFrame;", "shouldRunHeavy", "", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendHeavyFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendHeavyFilter.kt\ncom/jetbrains/rdclient/filters/FrontendHeavyFilter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n13#2:93\n*S KotlinDebug\n*F\n+ 1 FrontendHeavyFilter.kt\ncom/jetbrains/rdclient/filters/FrontendHeavyFilter\n*L\n90#1:93\n*E\n"})
public abstract class FrontendHeavyFilter
implements Filter,
FilterMixin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final FilterKind kind;
    @NotNull
    private static final Logger LOG;

    public FrontendHeavyFilter(@NotNull Project project, @NotNull FilterKind kind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        this.project = project;
        this.kind = kind;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FilterKind getKind() {
        return this.kind;
    }

    @Nullable
    public abstract FilterProviderModel getFilterProvider();

    public boolean shouldRunHeavy() {
        return true;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return null;
    }

    public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer2) {
        Intrinsics.checkNotNullParameter((Object)copiedFragment, (String)"copiedFragment");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        FilterProviderModel filterProviderModel2 = this.getFilterProvider();
        if (filterProviderModel2 == null) {
            return;
        }
        FilterProviderModel filterProviderModel3 = filterProviderModel2;
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            return;
        }
        Iterator<FrontendHeavyFilterFrame> iterator2 = new FrontendHeavyFilterFrameBuffer(copiedFragment).iterator();
        while (iterator2.hasNext()) {
            FrontendHeavyFilterFrame frontendHeavyFilterFrame = iterator2.next();
            IRdTask iRdTask = filterProviderModel3.getApplyFilter().start((Object)new ApplyFilterContext(frontendHeavyFilterFrame.getText(), this.kind));
            SourceExKt.adviseOnce((ISource)((ISource)iRdTask.getResult()), (Lifetime)ComponentsKt.getLifetime((UserDataHolder)this.project), (Function1)((Function1)new Function1<RdTaskResult<? extends List<? extends FilterHighlighterModelBase>>, Unit>(startOffset, frontendHeavyFilterFrame, this, consumer2){
                final /* synthetic */ int $startOffset;
                final /* synthetic */ FrontendHeavyFilterFrame $frame;
                final /* synthetic */ FrontendHeavyFilter this$0;
                final /* synthetic */ Consumer<? super FilterMixin.AdditionalHighlight> $consumer;
                {
                    this.$startOffset = $startOffset;
                    this.$frame = $frame;
                    this.this$0 = $receiver;
                    this.$consumer = $consumer;
                    super(1);
                }

                public final void invoke(@NotNull RdTaskResult<? extends List<? extends FilterHighlighterModelBase>> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    int n = this.$startOffset;
                    RdTaskResult<? extends List<? extends FilterHighlighterModelBase>> rdTaskResult = it;
                    if (rdTaskResult instanceof RdTaskResult.Success) {
                        ArrayList<Filter.ResultItem> arrayList = new ArrayList<Filter.ResultItem>();
                        TextRange textRange = this.$frame.getHighlightRange();
                        int n2 = textRange.getEndOffset() - textRange.getStartOffset();
                        for (FilterHighlighterModelBase filterHighlighterModelBase : (List)((RdTaskResult.Success)it).getValue()) {
                            if (filterHighlighterModelBase.getStart() >= n2) continue;
                            TextAttributes textAttributes = TextAttributesRegistrationHost.getTextAttributes$default(TextAttributesRegistrationHost.Companion.getInstance(), filterHighlighterModelBase.getTextAttributesKey(), null, 2, null);
                            HyperlinkInfo hyperlinkInfo2 = this.this$0.createHyperlinkInfo(filterHighlighterModelBase, this.$frame);
                            int n3 = this.$frame.getHighlightRange().getStartOffset();
                            int n4 = n + n3 + filterHighlighterModelBase.getStart();
                            int n5 = n + n3 + filterHighlighterModelBase.getEnd();
                            Filter.ResultItem resultItem = new Filter.ResultItem(n4, n5, hyperlinkInfo2, textAttributes);
                            arrayList.add(resultItem);
                        }
                        if (arrayList.isEmpty()) {
                            return;
                        }
                        this.$consumer.consume((Object)new FilterMixin.AdditionalHighlight((List)arrayList));
                    } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                        FrontendHeavyFilter.access$getLOG$cp().debug("Request has been canceled");
                    } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                        FrontendHeavyFilter.access$getLOG$cp().error("Request has faulted");
                    }
                }
            }));
        }
    }

    @Nullable
    public HyperlinkInfo createHyperlinkInfo(@NotNull FilterHighlighterModelBase highlighter2, @NotNull FrontendHeavyFilterFrame frame) {
        HyperlinkInfo hyperlinkInfo2;
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        if (highlighter2 instanceof FilterHyperlinkModel) {
            FilterProviderModel filterProviderModel2 = this.getFilterProvider();
            Intrinsics.checkNotNull((Object)((Object)filterProviderModel2));
            hyperlinkInfo2 = new FrontendHyperlinkInfo(this.kind, filterProviderModel2.getNavigate(), (FilterHyperlinkModel)highlighter2, frame);
        } else {
            hyperlinkInfo2 = null;
        }
        return hyperlinkInfo2;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendHeavyFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/filters/FrontendHeavyFilter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

